/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codeguruprofiler.AmazonCodeGuruProfiler;
import com.amazonaws.services.codeguruprofiler.AmazonCodeGuruProfilerClientBuilder;
import com.amazonaws.services.codeguruprofiler.model.AddNotificationChannelsRequest;
import com.amazonaws.services.codeguruprofiler.model.AddNotificationChannelsResult;
import com.amazonaws.services.codeguruprofiler.model.AmazonCodeGuruProfilerException;
import com.amazonaws.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest;
import com.amazonaws.services.codeguruprofiler.model.BatchGetFrameMetricDataResult;
import com.amazonaws.services.codeguruprofiler.model.ConfigureAgentRequest;
import com.amazonaws.services.codeguruprofiler.model.ConfigureAgentResult;
import com.amazonaws.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.CreateProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.DeleteProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.DeleteProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.DescribeProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.DescribeProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest;
import com.amazonaws.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResult;
import com.amazonaws.services.codeguruprofiler.model.GetNotificationConfigurationRequest;
import com.amazonaws.services.codeguruprofiler.model.GetNotificationConfigurationResult;
import com.amazonaws.services.codeguruprofiler.model.GetPolicyRequest;
import com.amazonaws.services.codeguruprofiler.model.GetPolicyResult;
import com.amazonaws.services.codeguruprofiler.model.GetProfileRequest;
import com.amazonaws.services.codeguruprofiler.model.GetProfileResult;
import com.amazonaws.services.codeguruprofiler.model.GetRecommendationsRequest;
import com.amazonaws.services.codeguruprofiler.model.GetRecommendationsResult;
import com.amazonaws.services.codeguruprofiler.model.ListFindingsReportsRequest;
import com.amazonaws.services.codeguruprofiler.model.ListFindingsReportsResult;
import com.amazonaws.services.codeguruprofiler.model.ListProfileTimesRequest;
import com.amazonaws.services.codeguruprofiler.model.ListProfileTimesResult;
import com.amazonaws.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import com.amazonaws.services.codeguruprofiler.model.ListProfilingGroupsResult;
import com.amazonaws.services.codeguruprofiler.model.ListTagsForResourceRequest;
import com.amazonaws.services.codeguruprofiler.model.ListTagsForResourceResult;
import com.amazonaws.services.codeguruprofiler.model.PostAgentProfileRequest;
import com.amazonaws.services.codeguruprofiler.model.PostAgentProfileResult;
import com.amazonaws.services.codeguruprofiler.model.PutPermissionRequest;
import com.amazonaws.services.codeguruprofiler.model.PutPermissionResult;
import com.amazonaws.services.codeguruprofiler.model.RemoveNotificationChannelRequest;
import com.amazonaws.services.codeguruprofiler.model.RemoveNotificationChannelResult;
import com.amazonaws.services.codeguruprofiler.model.RemovePermissionRequest;
import com.amazonaws.services.codeguruprofiler.model.RemovePermissionResult;
import com.amazonaws.services.codeguruprofiler.model.SubmitFeedbackRequest;
import com.amazonaws.services.codeguruprofiler.model.SubmitFeedbackResult;
import com.amazonaws.services.codeguruprofiler.model.TagResourceRequest;
import com.amazonaws.services.codeguruprofiler.model.TagResourceResult;
import com.amazonaws.services.codeguruprofiler.model.UntagResourceRequest;
import com.amazonaws.services.codeguruprofiler.model.UntagResourceResult;
import com.amazonaws.services.codeguruprofiler.model.UpdateProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.UpdateProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.transform.AddNotificationChannelsRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.AddNotificationChannelsResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.BatchGetFrameMetricDataRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.BatchGetFrameMetricDataResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ConfigureAgentRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ConfigureAgentResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.CreateProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.CreateProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DeleteProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DeleteProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DescribeProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DescribeProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetFindingsReportAccountSummaryRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetFindingsReportAccountSummaryResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetNotificationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetNotificationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetPolicyRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetPolicyResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetProfileRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetProfileResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListFindingsReportsRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListFindingsReportsResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfileTimesRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfileTimesResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfilingGroupsRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfilingGroupsResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PostAgentProfileRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PostAgentProfileResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PutPermissionRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PutPermissionResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.RemoveNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.RemoveNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.RemovePermissionRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.RemovePermissionResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.SubmitFeedbackRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.SubmitFeedbackResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UpdateProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UpdateProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCodeGuruProfilerClient
extends AmazonWebServiceClient
implements AmazonCodeGuruProfiler {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCodeGuruProfiler.class);
    private static final String DEFAULT_SIGNING_NAME = "codeguru-profiler";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCodeGuruProfilerException.class));

    public static AmazonCodeGuruProfilerClientBuilder builder() {
        return AmazonCodeGuruProfilerClientBuilder.standard();
    }

    AmazonCodeGuruProfilerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCodeGuruProfilerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codeguru-profiler.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codeguruprofiler/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codeguruprofiler/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddNotificationChannelsResult addNotificationChannels(AddNotificationChannelsRequest request) {
        request = (AddNotificationChannelsRequest)this.beforeClientExecution(request);
        return this.executeAddNotificationChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddNotificationChannelsResult executeAddNotificationChannels(AddNotificationChannelsRequest addNotificationChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addNotificationChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddNotificationChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddNotificationChannelsRequestProtocolMarshaller(protocolFactory).marshall((AddNotificationChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addNotificationChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddNotificationChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddNotificationChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddNotificationChannelsResult addNotificationChannelsResult = (AddNotificationChannelsResult)response.getAwsResponse();
            return addNotificationChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetFrameMetricDataResult batchGetFrameMetricData(BatchGetFrameMetricDataRequest request) {
        request = (BatchGetFrameMetricDataRequest)this.beforeClientExecution(request);
        return this.executeBatchGetFrameMetricData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetFrameMetricDataResult executeBatchGetFrameMetricData(BatchGetFrameMetricDataRequest batchGetFrameMetricDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetFrameMetricDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetFrameMetricDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetFrameMetricDataRequestProtocolMarshaller(protocolFactory).marshall((BatchGetFrameMetricDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetFrameMetricDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetFrameMetricData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetFrameMetricDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetFrameMetricDataResult batchGetFrameMetricDataResult = (BatchGetFrameMetricDataResult)response.getAwsResponse();
            return batchGetFrameMetricDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ConfigureAgentResult configureAgent(ConfigureAgentRequest request) {
        request = (ConfigureAgentRequest)this.beforeClientExecution(request);
        return this.executeConfigureAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ConfigureAgentResult executeConfigureAgent(ConfigureAgentRequest configureAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(configureAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfigureAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfigureAgentRequestProtocolMarshaller(protocolFactory).marshall((ConfigureAgentRequest)super.beforeMarshalling((AmazonWebServiceRequest)configureAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ConfigureAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConfigureAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfigureAgentResult configureAgentResult = (ConfigureAgentResult)response.getAwsResponse();
            return configureAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProfilingGroupResult createProfilingGroup(CreateProfilingGroupRequest request) {
        request = (CreateProfilingGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProfilingGroupResult executeCreateProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateProfilingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProfilingGroupResult createProfilingGroupResult = (CreateProfilingGroupResult)response.getAwsResponse();
            return createProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProfilingGroupResult deleteProfilingGroup(DeleteProfilingGroupRequest request) {
        request = (DeleteProfilingGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProfilingGroupResult executeDeleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteProfilingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProfilingGroupResult deleteProfilingGroupResult = (DeleteProfilingGroupResult)response.getAwsResponse();
            return deleteProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProfilingGroupResult describeProfilingGroup(DescribeProfilingGroupRequest request) {
        request = (DescribeProfilingGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribeProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProfilingGroupResult executeDescribeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribeProfilingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProfilingGroupResult describeProfilingGroupResult = (DescribeProfilingGroupResult)response.getAwsResponse();
            return describeProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFindingsReportAccountSummaryResult getFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest request) {
        request = (GetFindingsReportAccountSummaryRequest)this.beforeClientExecution(request);
        return this.executeGetFindingsReportAccountSummary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFindingsReportAccountSummaryResult executeGetFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest getFindingsReportAccountSummaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFindingsReportAccountSummaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFindingsReportAccountSummaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFindingsReportAccountSummaryRequestProtocolMarshaller(protocolFactory).marshall((GetFindingsReportAccountSummaryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFindingsReportAccountSummaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFindingsReportAccountSummary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsReportAccountSummaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFindingsReportAccountSummaryResult getFindingsReportAccountSummaryResult = (GetFindingsReportAccountSummaryResult)response.getAwsResponse();
            return getFindingsReportAccountSummaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNotificationConfigurationResult getNotificationConfiguration(GetNotificationConfigurationRequest request) {
        request = (GetNotificationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetNotificationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNotificationConfigurationResult executeGetNotificationConfiguration(GetNotificationConfigurationRequest getNotificationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNotificationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNotificationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNotificationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetNotificationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNotificationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNotificationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNotificationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNotificationConfigurationResult getNotificationConfigurationResult = (GetNotificationConfigurationResult)response.getAwsResponse();
            return getNotificationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        request = (GetPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPolicyResult executeGetPolicy(GetPolicyRequest getPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyResult getPolicyResult = (GetPolicyResult)response.getAwsResponse();
            return getPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        request = (GetProfileRequest)this.beforeClientExecution(request);
        return this.executeGetProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileResult executeGetProfile(GetProfileRequest getProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileRequestProtocolMarshaller(protocolFactory).marshall((GetProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileResult getProfileResult = (GetProfileResult)response.getAwsResponse();
            return getProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationsResult getRecommendations(GetRecommendationsRequest request) {
        request = (GetRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationsResult executeGetRecommendations(GetRecommendationsRequest getRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationsResult getRecommendationsResult = (GetRecommendationsResult)response.getAwsResponse();
            return getRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFindingsReportsResult listFindingsReports(ListFindingsReportsRequest request) {
        request = (ListFindingsReportsRequest)this.beforeClientExecution(request);
        return this.executeListFindingsReports(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFindingsReportsResult executeListFindingsReports(ListFindingsReportsRequest listFindingsReportsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsReportsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsReportsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsReportsRequestProtocolMarshaller(protocolFactory).marshall((ListFindingsReportsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingsReportsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFindingsReports");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsReportsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingsReportsResult listFindingsReportsResult = (ListFindingsReportsResult)response.getAwsResponse();
            return listFindingsReportsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfileTimesResult listProfileTimes(ListProfileTimesRequest request) {
        request = (ListProfileTimesRequest)this.beforeClientExecution(request);
        return this.executeListProfileTimes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfileTimesResult executeListProfileTimes(ListProfileTimesRequest listProfileTimesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfileTimesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfileTimesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfileTimesRequestProtocolMarshaller(protocolFactory).marshall((ListProfileTimesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfileTimesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfileTimes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfileTimesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfileTimesResult listProfileTimesResult = (ListProfileTimesResult)response.getAwsResponse();
            return listProfileTimesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfilingGroupsResult listProfilingGroups(ListProfilingGroupsRequest request) {
        request = (ListProfilingGroupsRequest)this.beforeClientExecution(request);
        return this.executeListProfilingGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfilingGroupsResult executeListProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfilingGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfilingGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfilingGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListProfilingGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfilingGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfilingGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfilingGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfilingGroupsResult listProfilingGroupsResult = (ListProfilingGroupsResult)response.getAwsResponse();
            return listProfilingGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PostAgentProfileResult postAgentProfile(PostAgentProfileRequest request) {
        request = (PostAgentProfileRequest)this.beforeClientExecution(request);
        return this.executePostAgentProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PostAgentProfileResult executePostAgentProfile(PostAgentProfileRequest postAgentProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(postAgentProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PostAgentProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PostAgentProfileRequestProtocolMarshaller(protocolFactory).marshall((PostAgentProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)postAgentProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PostAgentProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PostAgentProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PostAgentProfileResult postAgentProfileResult = (PostAgentProfileResult)response.getAwsResponse();
            return postAgentProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPermissionResult putPermission(PutPermissionRequest request) {
        request = (PutPermissionRequest)this.beforeClientExecution(request);
        return this.executePutPermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPermissionResult executePutPermission(PutPermissionRequest putPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPermissionRequestProtocolMarshaller(protocolFactory).marshall((PutPermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPermissionResult putPermissionResult = (PutPermissionResult)response.getAwsResponse();
            return putPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveNotificationChannelResult removeNotificationChannel(RemoveNotificationChannelRequest request) {
        request = (RemoveNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executeRemoveNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveNotificationChannelResult executeRemoveNotificationChannel(RemoveNotificationChannelRequest removeNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((RemoveNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveNotificationChannelResult removeNotificationChannelResult = (RemoveNotificationChannelResult)response.getAwsResponse();
            return removeNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest request) {
        request = (RemovePermissionRequest)this.beforeClientExecution(request);
        return this.executeRemovePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemovePermissionResult executeRemovePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestProtocolMarshaller(protocolFactory).marshall((RemovePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemovePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemovePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemovePermissionResult removePermissionResult = (RemovePermissionResult)response.getAwsResponse();
            return removePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubmitFeedbackResult submitFeedback(SubmitFeedbackRequest request) {
        request = (SubmitFeedbackRequest)this.beforeClientExecution(request);
        return this.executeSubmitFeedback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SubmitFeedbackResult executeSubmitFeedback(SubmitFeedbackRequest submitFeedbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitFeedbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitFeedbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitFeedbackRequestProtocolMarshaller(protocolFactory).marshall((SubmitFeedbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)submitFeedbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SubmitFeedback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubmitFeedbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubmitFeedbackResult submitFeedbackResult = (SubmitFeedbackResult)response.getAwsResponse();
            return submitFeedbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProfilingGroupResult updateProfilingGroup(UpdateProfilingGroupRequest request) {
        request = (UpdateProfilingGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProfilingGroupResult executeUpdateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateProfilingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProfilingGroupResult updateProfilingGroupResult = (UpdateProfilingGroupResult)response.getAwsResponse();
            return updateProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

