/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeImport" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeImportResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Represents the properties of the table created for the import, and parameters of the import. The import
     * parameters include import status, how many items were processed, and how many errors were encountered.
     * </p>
     */
    private ImportTableDescription importTableDescription;

    /**
     * <p>
     * Represents the properties of the table created for the import, and parameters of the import. The import
     * parameters include import status, how many items were processed, and how many errors were encountered.
     * </p>
     * 
     * @param importTableDescription
     *        Represents the properties of the table created for the import, and parameters of the import. The import
     *        parameters include import status, how many items were processed, and how many errors were encountered.
     */

    public void setImportTableDescription(ImportTableDescription importTableDescription) {
        this.importTableDescription = importTableDescription;
    }

    /**
     * <p>
     * Represents the properties of the table created for the import, and parameters of the import. The import
     * parameters include import status, how many items were processed, and how many errors were encountered.
     * </p>
     * 
     * @return Represents the properties of the table created for the import, and parameters of the import. The import
     *         parameters include import status, how many items were processed, and how many errors were encountered.
     */

    public ImportTableDescription getImportTableDescription() {
        return this.importTableDescription;
    }

    /**
     * <p>
     * Represents the properties of the table created for the import, and parameters of the import. The import
     * parameters include import status, how many items were processed, and how many errors were encountered.
     * </p>
     * 
     * @param importTableDescription
     *        Represents the properties of the table created for the import, and parameters of the import. The import
     *        parameters include import status, how many items were processed, and how many errors were encountered.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeImportResult withImportTableDescription(ImportTableDescription importTableDescription) {
        setImportTableDescription(importTableDescription);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getImportTableDescription() != null)
            sb.append("ImportTableDescription: ").append(getImportTableDescription());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeImportResult == false)
            return false;
        DescribeImportResult other = (DescribeImportResult) obj;
        if (other.getImportTableDescription() == null ^ this.getImportTableDescription() == null)
            return false;
        if (other.getImportTableDescription() != null && other.getImportTableDescription().equals(this.getImportTableDescription()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getImportTableDescription() == null) ? 0 : getImportTableDescription().hashCode());
        return hashCode;
    }

    @Override
    public DescribeImportResult clone() {
        try {
            return (DescribeImportResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
