/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.FaultStatistics;

@SdkInternalApi
public class FaultStatisticsMarshaller {
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final FaultStatisticsMarshaller instance = new FaultStatisticsMarshaller();

    public static FaultStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(FaultStatistics faultStatistics, ProtocolMarshaller protocolMarshaller) {
        if (faultStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)faultStatistics.getOtherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)faultStatistics.getTotalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

