/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.format;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b0\b\u0081\b\u0018\u0000 82\u00020\u0001:\u00018BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010&\u001a\u00020\u0003J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010(\u001a\u00020\u0006*\u00020\tH\u0002J\f\u0010)\u001a\u00020\t*\u00020\tH\u0002J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003Ji\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00104\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u0006H\u00d6\u0001J\t\u00107\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0014\u00a8\u00069"}, d2={"Lcom/facebook/ktfmt/format/MultilineTrimmedString;", "", "usesTrimMargin", "", "isDollarString", "indentCount", "", "lines", "", "", "lineStart", "lineEnd", "openStringOffset", "trimMethodCallOffset", "isNestedMultiline", "<init>", "(ZZILjava/util/List;IIIIZ)V", "getUsesTrimMargin", "()Z", "getIndentCount", "()I", "getLines", "()Ljava/util/List;", "getLineStart", "getLineEnd", "getOpenStringOffset", "getTrimMethodCallOffset", "usesTrimIndent", "getUsesTrimIndent", "lastStringLineIndex", "getLastStringLineIndex", "minimalIndent", "getMinimalIndent", "indentationSuffix", "getIndentationSuffix", "()Ljava/lang/String;", "stringLineCount", "getStringLineCount", "hasTemplateExpression", "getStringContent", "indentLevel", "trimmed", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Companion", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nMultilineStringFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineStringFormatter.kt\ncom/facebook/ktfmt/format/MultilineTrimmedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n388#2,7:226\n1761#2,3:234\n1878#2,3:237\n1#3:233\n*S KotlinDebug\n*F\n+ 1 MultilineStringFormatter.kt\ncom/facebook/ktfmt/format/MultilineTrimmedString\n*L\n174#1:226,7\n193#1:234,3\n198#1:237,3\n*E\n"})
public final class MultilineTrimmedString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean usesTrimMargin;
    private final boolean isDollarString;
    private final int indentCount;
    @NotNull
    private final List<String> lines;
    private final int lineStart;
    private final int lineEnd;
    private final int openStringOffset;
    private final int trimMethodCallOffset;
    private final boolean isNestedMultiline;
    private final int lastStringLineIndex;
    @NotNull
    private final String indentationSuffix;
    private final int stringLineCount;
    @NotNull
    private static final Regex simpleTemplateExpressionRegex = new Regex("\\${1}((\\{?[A-Za-z_\\s])|\\{$)");
    @NotNull
    private static final Regex dollarTemplateExpressionRegex = new Regex("\\${2}((\\{?[A-Za-z_\\s])|\\{$)");

    /*
     * WARNING - void declaration
     */
    public MultilineTrimmedString(boolean usesTrimMargin, boolean isDollarString, int indentCount, @NotNull List<String> lines, int lineStart, int lineEnd, int openStringOffset, int trimMethodCallOffset, boolean isNestedMultiline) {
        int n;
        int n2;
        block1: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.usesTrimMargin = usesTrimMargin;
            this.isDollarString = isDollarString;
            this.indentCount = indentCount;
            this.lines = lines;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.openStringOffset = openStringOffset;
            this.trimMethodCallOffset = trimMethodCallOffset;
            this.isNestedMultiline = isNestedMultiline;
            List<String> list = this.lines;
            MultilineTrimmedString multilineTrimmedString = this;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"\"\"\"", (boolean)false, (int)2, null)) continue;
                n2 = iterator$iv.nextIndex();
                break block1;
            }
            n2 = -1;
        }
        multilineTrimmedString.lastStringLineIndex = n = n2;
        this.indentationSuffix = this.usesTrimMargin ? "|" : "";
        this.stringLineCount = this.lastStringLineIndex + 1;
    }

    public final boolean getUsesTrimMargin() {
        return this.usesTrimMargin;
    }

    public final boolean isDollarString() {
        return this.isDollarString;
    }

    public final int getIndentCount() {
        return this.indentCount;
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    public final int getLineStart() {
        return this.lineStart;
    }

    public final int getLineEnd() {
        return this.lineEnd;
    }

    public final int getOpenStringOffset() {
        return this.openStringOffset;
    }

    public final int getTrimMethodCallOffset() {
        return this.trimMethodCallOffset;
    }

    public final boolean isNestedMultiline() {
        return this.isNestedMultiline;
    }

    public final boolean getUsesTrimIndent() {
        return !this.usesTrimMargin;
    }

    public final int getLastStringLineIndex() {
        return this.lastStringLineIndex;
    }

    public final int getMinimalIndent() {
        int n;
        Iterator iterator = ((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.lines.subList(1, this.lastStringLineIndex), (Object)StringsKt.substringAfterLast$default((String)((String)CollectionsKt.first(this.lines)), (String)"\"\"\"", null, (int)2, null)), (Object)StringsKt.substringBefore$default((String)this.lines.get(this.lastStringLineIndex), (String)"\"\"\"", null, (int)2, null))).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)iterator.next();
        boolean bl = false;
        int n2 = n = StringsKt.isBlank((CharSequence)it) ? Integer.MAX_VALUE : this.indentLevel(it);
        while (iterator.hasNext()) {
            String it2 = (String)iterator.next();
            $i$a$-minOf-MultilineTrimmedString$minimalIndent$1 = false;
            int n3 = StringsKt.isBlank((CharSequence)it2) ? Integer.MAX_VALUE : this.indentLevel(it2);
            if (n <= n3) continue;
            n = n3;
        }
        return n;
    }

    @NotNull
    public final String getIndentationSuffix() {
        return this.indentationSuffix;
    }

    public final int getStringLineCount() {
        return this.stringLineCount;
    }

    public final boolean hasTemplateExpression() {
        boolean bl;
        block3: {
            Regex regex = this.isDollarString ? dollarTemplateExpressionRegex : simpleTemplateExpressionRegex;
            Iterable $this$any$iv = this.lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStringContent() {
        List list;
        List $this$getStringContent_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = this.lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i == 0 || i == this.lastStringLineIndex) {
                String stringContent = i == 0 ? StringsKt.substringAfter$default((String)line2, (String)"\"\"\"", null, (int)2, null) : StringsKt.substringBeforeLast$default((String)line2, (String)"\"\"\"", null, (int)2, null);
                if (!(!StringsKt.isBlank((CharSequence)stringContent))) continue;
                $this$getStringContent_u24lambda_u244.add(this.trimmed(stringContent));
                continue;
            }
            if (i > this.lastStringLineIndex) continue;
            $this$getStringContent_u24lambda_u244.add(this.trimmed((String)line2));
        }
        return CollectionsKt.build((List)list);
    }

    private final int indentLevel(String $this$indentLevel) {
        return $this$indentLevel.length() - ((Object)StringsKt.trimStart((CharSequence)$this$indentLevel)).toString().length();
    }

    private final String trimmed(String $this$trimmed) {
        if (this.getUsesTrimIndent()) {
            return StringsKt.drop((String)$this$trimmed, (int)this.getMinimalIndent());
        }
        Character c = StringsKt.firstOrNull((CharSequence)((Object)StringsKt.trimStart((CharSequence)$this$trimmed)).toString());
        char c2 = '|';
        if (c != null && c.charValue() == c2) {
            return StringsKt.substringAfter$default((String)$this$trimmed, (String)"|", null, (int)2, null);
        }
        return $this$trimmed;
    }

    public final boolean component1() {
        return this.usesTrimMargin;
    }

    public final boolean component2() {
        return this.isDollarString;
    }

    public final int component3() {
        return this.indentCount;
    }

    @NotNull
    public final List<String> component4() {
        return this.lines;
    }

    public final int component5() {
        return this.lineStart;
    }

    public final int component6() {
        return this.lineEnd;
    }

    public final int component7() {
        return this.openStringOffset;
    }

    public final int component8() {
        return this.trimMethodCallOffset;
    }

    public final boolean component9() {
        return this.isNestedMultiline;
    }

    @NotNull
    public final MultilineTrimmedString copy(boolean usesTrimMargin, boolean isDollarString, int indentCount, @NotNull List<String> lines, int lineStart, int lineEnd, int openStringOffset, int trimMethodCallOffset, boolean isNestedMultiline) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        return new MultilineTrimmedString(usesTrimMargin, isDollarString, indentCount, lines, lineStart, lineEnd, openStringOffset, trimMethodCallOffset, isNestedMultiline);
    }

    public static /* synthetic */ MultilineTrimmedString copy$default(MultilineTrimmedString multilineTrimmedString, boolean bl, boolean bl2, int n, List list, int n2, int n3, int n4, int n5, boolean bl3, int n6, Object object) {
        if ((n6 & 1) != 0) {
            bl = multilineTrimmedString.usesTrimMargin;
        }
        if ((n6 & 2) != 0) {
            bl2 = multilineTrimmedString.isDollarString;
        }
        if ((n6 & 4) != 0) {
            n = multilineTrimmedString.indentCount;
        }
        if ((n6 & 8) != 0) {
            list = multilineTrimmedString.lines;
        }
        if ((n6 & 0x10) != 0) {
            n2 = multilineTrimmedString.lineStart;
        }
        if ((n6 & 0x20) != 0) {
            n3 = multilineTrimmedString.lineEnd;
        }
        if ((n6 & 0x40) != 0) {
            n4 = multilineTrimmedString.openStringOffset;
        }
        if ((n6 & 0x80) != 0) {
            n5 = multilineTrimmedString.trimMethodCallOffset;
        }
        if ((n6 & 0x100) != 0) {
            bl3 = multilineTrimmedString.isNestedMultiline;
        }
        return multilineTrimmedString.copy(bl, bl2, n, list, n2, n3, n4, n5, bl3);
    }

    @NotNull
    public String toString() {
        return "MultilineTrimmedString(usesTrimMargin=" + this.usesTrimMargin + ", isDollarString=" + this.isDollarString + ", indentCount=" + this.indentCount + ", lines=" + this.lines + ", lineStart=" + this.lineStart + ", lineEnd=" + this.lineEnd + ", openStringOffset=" + this.openStringOffset + ", trimMethodCallOffset=" + this.trimMethodCallOffset + ", isNestedMultiline=" + this.isNestedMultiline + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.usesTrimMargin);
        result2 = result2 * 31 + Boolean.hashCode(this.isDollarString);
        result2 = result2 * 31 + Integer.hashCode(this.indentCount);
        result2 = result2 * 31 + ((Object)this.lines).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.lineStart);
        result2 = result2 * 31 + Integer.hashCode(this.lineEnd);
        result2 = result2 * 31 + Integer.hashCode(this.openStringOffset);
        result2 = result2 * 31 + Integer.hashCode(this.trimMethodCallOffset);
        result2 = result2 * 31 + Boolean.hashCode(this.isNestedMultiline);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultilineTrimmedString)) {
            return false;
        }
        MultilineTrimmedString multilineTrimmedString = (MultilineTrimmedString)other;
        if (this.usesTrimMargin != multilineTrimmedString.usesTrimMargin) {
            return false;
        }
        if (this.isDollarString != multilineTrimmedString.isDollarString) {
            return false;
        }
        if (this.indentCount != multilineTrimmedString.indentCount) {
            return false;
        }
        if (!Intrinsics.areEqual(this.lines, multilineTrimmedString.lines)) {
            return false;
        }
        if (this.lineStart != multilineTrimmedString.lineStart) {
            return false;
        }
        if (this.lineEnd != multilineTrimmedString.lineEnd) {
            return false;
        }
        if (this.openStringOffset != multilineTrimmedString.openStringOffset) {
            return false;
        }
        if (this.trimMethodCallOffset != multilineTrimmedString.trimMethodCallOffset) {
            return false;
        }
        return this.isNestedMultiline == multilineTrimmedString.isNestedMultiline;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/ktfmt/format/MultilineTrimmedString$Companion;", "", "<init>", "()V", "simpleTemplateExpressionRegex", "Lkotlin/text/Regex;", "dollarTemplateExpressionRegex", "ktfmt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

