/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormatter;
import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u001e\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001e\u0010\u0014\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocCommentsHelper;", "Lcom/google/googlejavaformat/CommentsHelper;", "lineSeparator", "", "maxLineLength", "", "<init>", "(Ljava/lang/String;I)V", "kdocFormatter", "Lcom/facebook/ktfmt/kdoc/KDocFormatter;", "rewrite", "tok", "Lcom/google/googlejavaformat/Input$Tok;", "maxWidth", "column0", "preserveIndentation", "lines", "", "indentLineComments", "wrapLineComments", "indentJavadoc", "LINE_COMMENT_MISSING_SPACE_PREFIX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "javadocShaped", "", "ktfmt"})
public final class KDocCommentsHelper
implements CommentsHelper {
    @NotNull
    private final String lineSeparator;
    private final int maxLineLength;
    @NotNull
    private final KDocFormatter kdocFormatter;
    private final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX;

    /*
     * WARNING - void declaration
     */
    public KDocCommentsHelper(@NotNull String lineSeparator, int maxLineLength) {
        void $this$kdocFormatter_u24lambda_u240;
        KDocFormattingOptions kDocFormattingOptions;
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this.lineSeparator = lineSeparator;
        this.maxLineLength = maxLineLength;
        KDocFormattingOptions kDocFormattingOptions2 = kDocFormattingOptions = new KDocFormattingOptions(this.maxLineLength, this.maxLineLength);
        KDocCommentsHelper kDocCommentsHelper = this;
        boolean bl = false;
        $this$kdocFormatter_u24lambda_u240.setAllowParamBrackets(true);
        $this$kdocFormatter_u24lambda_u240.setConvertMarkup(false);
        $this$kdocFormatter_u24lambda_u240.setNestedListIndent(4);
        $this$kdocFormatter_u24lambda_u240.setOptimal(false);
        KDocFormattingOptions kDocFormattingOptions3 = kDocFormattingOptions;
        kDocCommentsHelper.kdocFormatter = new KDocFormatter(kDocFormattingOptions3);
        this.LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");
    }

    @NotNull
    public String rewrite(@NotNull Input.Tok tok, int maxWidth, int column0) {
        Intrinsics.checkNotNullParameter((Object)tok, (String)"tok");
        if (!tok.isComment()) {
            String string = tok.getOriginalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOriginalText(...)");
            return string;
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment()) {
            String string = text;
            Intrinsics.checkNotNull((Object)string);
            text = this.kdocFormatter.reformatComment(string, StringsKt.repeat((CharSequence)" ", (int)column0));
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator it = Newlines.lineIterator((String)text);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom((CharSequence)it.next()));
        }
        return tok.isSlashSlashComment() ? this.indentLineComments((List<String>)lines, column0) : (this.javadocShaped((List<String>)lines) ? this.indentJavadoc((List<String>)lines, column0) : this.preserveIndentation((List<String>)lines, column0));
    }

    private final String preserveIndentation(List<String> lines, int column0) {
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        int n = lines.size();
        for (i = 1; i < n; ++i) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn((CharSequence)lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder.append(lines.get(0));
        n = lines.size();
        for (i = 1; i < n; ++i) {
            StringBuilder stringBuilder;
            builder.append(this.lineSeparator).append(Strings.repeat((String)" ", (int)column0));
            if (lines.get(i).length() >= startCol) {
                String string = lines.get(i).substring(startCol);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                stringBuilder = builder.append(string);
                continue;
            }
            stringBuilder = builder.append(lines.get(i));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String indentLineComments(List<String> lines, int column0) {
        List<String> wrappedLines = this.wrapLineComments(lines, column0);
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)StringsKt.trim((CharSequence)wrappedLines.get(0))).toString());
        String indentString = Strings.repeat((String)" ", (int)column0);
        int n = wrappedLines.size();
        for (int i = 1; i < n; ++i) {
            builder.append(this.lineSeparator).append(indentString).append(((Object)StringsKt.trim((CharSequence)wrappedLines.get(i))).toString());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final List<String> wrapLineComments(List<String> lines, int column0) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (String originalLine : lines) {
            Object line2 = originalLine;
            Matcher matcher = this.LINE_COMMENT_MISSING_SPACE_PREFIX.matcher((CharSequence)line2);
            if (matcher.find()) {
                int length = matcher.group(1).length();
                String string = Strings.repeat((String)"/", (int)length);
                String string2 = ((String)line2).substring(length);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                line2 = string + " " + string2;
            }
            if (StringsKt.startsWith$default((String)line2, (String)"// MOE:", (boolean)false, (int)2, null)) {
                result2.add(line2);
                continue;
            }
            while (((String)line2).length() + column0 > this.maxLineLength) {
                int idx;
                for (idx = this.maxLineLength - column0; idx >= 2 && !CharMatcher.whitespace().matches(((String)line2).charAt(idx)); --idx) {
                }
                if (idx <= 2) break;
                String string = ((String)line2).substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result2.add(string);
                String string3 = ((String)line2).substring(idx);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                line2 = "//" + string3;
            }
            result2.add(line2);
        }
        return result2;
    }

    private final String indentJavadoc(List<String> lines, int column0) {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)StringsKt.trim((CharSequence)lines.get(0))).toString());
        int indent = column0 + 1;
        String indentString = Strings.repeat((String)" ", (int)indent);
        int n = lines.size();
        for (int i = 1; i < n; ++i) {
            builder.append(this.lineSeparator).append(indentString);
            String line2 = ((Object)StringsKt.trim((CharSequence)lines.get(i))).toString();
            if (!StringsKt.startsWith$default((String)line2, (String)"*", (boolean)false, (int)2, null)) {
                builder.append("* ");
            }
            builder.append(line2);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean javadocShaped(List<String> lines) {
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = ((Object)StringsKt.trim((CharSequence)it.next())).toString();
        if (StringsKt.startsWith$default((String)first, (String)"/**", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!StringsKt.startsWith$default((String)first, (String)"/*", (boolean)false, (int)2, null)) {
            return false;
        }
        while (it.hasNext()) {
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it.next())).toString(), (String)"*", (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }
}

