/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.CommentType;
import com.facebook.ktfmt.kdoc.FormattingTask;
import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.facebook.ktfmt.kdoc.UtilitiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001_B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010L\u001a\u00020\u001eJ\u0006\u0010M\u001a\u00020NJ\u0010\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020\u0012H\u0002J\u0010\u0010Q\u001a\u00020\u00122\u0006\u0010P\u001a\u00020\u0012H\u0002J\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00120S2\u0006\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020@J,\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00120S2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00120S2\u0006\u0010W\u001a\u00020@2\u0006\u0010X\u001a\u00020@H\u0002J\u0018\u0010Y\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012H\u0002J\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00120SJ$\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00120S2\u0006\u0010U\u001a\u00020@2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00120SH\u0002J,\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120S2\u0006\u0010W\u001a\u00020@2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00120SH\u0002J\b\u0010^\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001a\u0010)\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R\u001a\u0010,\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R\u001a\u0010/\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010 \"\u0004\b1\u0010\"R\u001a\u00102\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010 \"\u0004\b4\u0010\"R\u001a\u00105\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010 \"\u0004\b7\u0010\"R\u001a\u00108\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010 \"\u0004\b:\u0010\"R$\u0010<\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010 \"\u0004\b>\u0010\"R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0014\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0014\"\u0004\bK\u0010H\u00a8\u0006`"}, d2={"Lcom/facebook/ktfmt/kdoc/Paragraph;", "", "task", "Lcom/facebook/ktfmt/kdoc/FormattingTask;", "<init>", "(Lcom/facebook/ktfmt/kdoc/FormattingTask;)V", "options", "Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "getOptions", "()Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "content", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getContent", "()Ljava/lang/StringBuilder;", "setContent", "(Ljava/lang/StringBuilder;)V", "text", "", "getText", "()Ljava/lang/String;", "prev", "getPrev", "()Lcom/facebook/ktfmt/kdoc/Paragraph;", "setPrev", "(Lcom/facebook/ktfmt/kdoc/Paragraph;)V", "next", "getNext", "setNext", "separate", "", "getSeparate", "()Z", "setSeparate", "(Z)V", "continuation", "getContinuation", "setContinuation", "allowEmpty", "getAllowEmpty", "setAllowEmpty", "preformatted", "getPreformatted", "setPreformatted", "block", "getBlock", "setBlock", "doc", "getDoc", "setDoc", "quoted", "getQuoted", "setQuoted", "table", "getTable", "setTable", "separator", "getSeparator", "setSeparator", "value", "hanging", "getHanging", "setHanging", "originalIndent", "", "getOriginalIndent", "()I", "setOriginalIndent", "(I)V", "indent", "getIndent", "setIndent", "(Ljava/lang/String;)V", "hangingIndent", "getHangingIndent", "setHangingIndent", "isEmpty", "cleanup", "", "rewriteParams", "s", "convertMarkup", "reflow", "", "firstLineMaxWidth", "maxLineWidth", "words", "lineWidth", "hangingIndentSize", "canBreakAt", "word", "computeWords", "reflowOptimal", "reflowGreedy", "toString", "Quadruple", "ktfmt"})
@SourceDebugExtension(value={"SMAP\nParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paragraph.kt\ncom/facebook/ktfmt/kdoc/Paragraph\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,669:1\n1855#2,2:670\n1761#3,3:672\n1761#3,3:675\n774#3:678\n865#3,2:679\n1563#3:681\n1634#3,3:682\n1563#3:685\n1634#3,3:686\n*S KotlinDebug\n*F\n+ 1 Paragraph.kt\ncom/facebook/ktfmt/kdoc/Paragraph\n*L\n169#1:670,2\n356#1:672,3\n397#1:675,3\n460#1:678\n460#1:679,2\n460#1:681\n460#1:682,3\n537#1:685\n537#1:686,3\n*E\n"})
public final class Paragraph {
    @NotNull
    private final FormattingTask task;
    @NotNull
    private StringBuilder content;
    @Nullable
    private Paragraph prev;
    @Nullable
    private Paragraph next;
    private boolean separate;
    private boolean continuation;
    private boolean allowEmpty;
    private boolean preformatted;
    private boolean block;
    private boolean doc;
    private boolean quoted;
    private boolean table;
    private boolean separator;
    private boolean hanging;
    private int originalIndent;
    @NotNull
    private String indent;
    @NotNull
    private String hangingIndent;

    public Paragraph(@NotNull FormattingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        this.content = new StringBuilder();
        this.indent = "";
        this.hangingIndent = "";
    }

    private final KDocFormattingOptions getOptions() {
        return this.task.getOptions();
    }

    @NotNull
    public final StringBuilder getContent() {
        return this.content;
    }

    public final void setContent(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
        this.content = stringBuilder;
    }

    @NotNull
    public final String getText() {
        String string = this.content.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final Paragraph getPrev() {
        return this.prev;
    }

    public final void setPrev(@Nullable Paragraph paragraph) {
        this.prev = paragraph;
    }

    @Nullable
    public final Paragraph getNext() {
        return this.next;
    }

    public final void setNext(@Nullable Paragraph paragraph) {
        this.next = paragraph;
    }

    public final boolean getSeparate() {
        return this.separate;
    }

    public final void setSeparate(boolean bl) {
        this.separate = bl;
    }

    public final boolean getContinuation() {
        return this.continuation;
    }

    public final void setContinuation(boolean bl) {
        this.continuation = bl;
    }

    public final boolean getAllowEmpty() {
        return this.allowEmpty;
    }

    public final void setAllowEmpty(boolean bl) {
        this.allowEmpty = bl;
    }

    public final boolean getPreformatted() {
        return this.preformatted;
    }

    public final void setPreformatted(boolean bl) {
        this.preformatted = bl;
    }

    public final boolean getBlock() {
        return this.block;
    }

    public final void setBlock(boolean bl) {
        this.block = bl;
    }

    public final boolean getDoc() {
        return this.doc;
    }

    public final void setDoc(boolean bl) {
        this.doc = bl;
    }

    public final boolean getQuoted() {
        return this.quoted;
    }

    public final void setQuoted(boolean bl) {
        this.quoted = bl;
    }

    public final boolean getTable() {
        return this.table;
    }

    public final void setTable(boolean bl) {
        this.table = bl;
    }

    public final boolean getSeparator() {
        return this.separator;
    }

    public final void setSeparator(boolean bl) {
        this.separator = bl;
    }

    public final boolean getHanging() {
        return this.hanging;
    }

    public final void setHanging(boolean value) {
        this.block = true;
        this.hanging = value;
    }

    public final int getOriginalIndent() {
        return this.originalIndent;
    }

    public final void setOriginalIndent(int n) {
        this.originalIndent = n;
    }

    @NotNull
    public final String getIndent() {
        return this.indent;
    }

    public final void setIndent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indent = string;
    }

    @NotNull
    public final String getHangingIndent() {
        return this.hangingIndent;
    }

    public final void setHangingIndent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.hangingIndent = string;
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.content).length() == 0;
    }

    public final void cleanup() {
        String original = this.getText();
        if (this.preformatted) {
            return;
        }
        String s = original;
        if (this.getOptions().getConvertMarkup()) {
            s = this.convertMarkup(this.getText());
        }
        if (!this.getOptions().getAllowParamBrackets()) {
            s = this.rewriteParams(s);
        }
        if (!Intrinsics.areEqual((Object)s, (Object)original)) {
            StringsKt.clear((StringBuilder)this.content);
            this.content.append(s);
        }
    }

    private final String rewriteParams(String s) {
        int start;
        int length = s.length();
        for (start = 0; start < length && CharsKt.isWhitespace((char)s.charAt(start)); ++start) {
        }
        if (StringsKt.startsWith$default((String)s, (String)"@param", (int)start, (boolean)false, (int)4, null)) {
            start += 6;
            while (start < length && CharsKt.isWhitespace((char)s.charAt(start))) {
                ++start;
            }
            if (start < length && s.charAt(start++) == '[') {
                int end;
                while (start < length && CharsKt.isWhitespace((char)s.charAt(start))) {
                    ++start;
                }
                for (end = start; end < length && Character.isJavaIdentifierPart(s.charAt(end)); ++end) {
                }
                if (end > start) {
                    String string = s.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String name = string;
                    while (end < length && CharsKt.isWhitespace((char)s.charAt(end))) {
                        ++end;
                    }
                    if (end < length && s.charAt(end++) == ']') {
                        while (end < length && CharsKt.isWhitespace((char)s.charAt(end))) {
                            ++end;
                        }
                        String string2 = s.substring(end);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        return "@param " + name + " " + string2;
                    }
                }
            }
        }
        return s;
    }

    private final String convertMarkup(String s) {
        boolean convertKDocTag;
        boolean bl = convertKDocTag = UtilitiesKt.isKDocTag(s) && Character.isUpperCase(s.charAt(1));
        if (!convertKDocTag) {
            boolean bl2;
            block35: {
                CharSequence $this$none$iv = s;
                boolean $i$f$none = false;
                for (int i = 0; i < $this$none$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$none$iv.charAt(i);
                    boolean bl3 = false;
                    if (!(it == '<' || it == '&' || it == '{')) continue;
                    bl2 = false;
                    break block35;
                }
                bl2 = true;
            }
            if (bl2) {
                return s;
            }
        }
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        int n = s.length();
        if (convertKDocTag) {
            sb.append('@').append(Character.toLowerCase(s.charAt(1)));
            i += 2;
        }
        boolean code = false;
        int brackets = 0;
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                sb.append(c);
                if (i >= n - 1) continue;
                sb.append(s.charAt(i++));
                continue;
            }
            if (c == '`') {
                code = !code;
                sb.append(c);
                continue;
            }
            if (c == '[') {
                ++brackets;
                sb.append(c);
                continue;
            }
            if (c == ']') {
                --brackets;
                sb.append(c);
                continue;
            }
            if (code || brackets > 0) {
                sb.append(c);
                continue;
            }
            if (c == '<') {
                if (StringsKt.startsWith((String)s, (String)"b>", (int)i, (boolean)false) || StringsKt.startsWith((String)s, (String)"/b>", (int)i, (boolean)false)) {
                    sb.append('*').append('*');
                    if (s.charAt(i) == '/') {
                        ++i;
                    }
                    i += 2;
                    continue;
                }
                if (StringsKt.startsWith((String)s, (String)"i>", (int)i, (boolean)false) || StringsKt.startsWith((String)s, (String)"/i>", (int)i, (boolean)false)) {
                    sb.append('*');
                    if (s.charAt(i) == '/') {
                        ++i;
                    }
                    i += 2;
                    continue;
                }
                if (StringsKt.startsWith((String)s, (String)"em>", (int)i, (boolean)false) || StringsKt.startsWith((String)s, (String)"/em>", (int)i, (boolean)false)) {
                    sb.append('_');
                    if (s.charAt(i) == '/') {
                        ++i;
                    }
                    i += 3;
                    continue;
                }
            } else if (c == '&') {
                if (StringsKt.startsWith((String)s, (String)"lt;", (int)i, (boolean)true)) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (StringsKt.startsWith((String)s, (String)"gt;", (int)i, (boolean)true)) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
            } else if (c == '{') {
                int curr;
                if (StringsKt.startsWith((String)s, (String)"@param", (int)i, (boolean)true)) {
                    curr = i + 6;
                    int end = StringsKt.indexOf$default((CharSequence)s, (char)'}', (int)curr, (boolean)false, (int)4, null);
                    if (end == -1) {
                        end = n;
                    }
                    sb.append('[');
                    String string = s.substring(curr, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    sb.append(((Object)StringsKt.trim((CharSequence)string)).toString());
                    sb.append(']');
                    i = end + 1;
                    continue;
                }
                if (StringsKt.startsWith((String)s, (String)"@link", (int)i, (boolean)true) && !StringsKt.startsWith((String)s, (String)"@linkplain", (int)i, (boolean)true)) {
                    char ch;
                    sb.append('[');
                    curr = i + 5;
                    while (curr < n && !CharsKt.isWhitespace((char)(ch = s.charAt(curr++)))) {
                        if (ch != '}') continue;
                        --curr;
                        break;
                    }
                    boolean skip = false;
                    while (curr < n) {
                        char ch2 = s.charAt(curr);
                        if (ch2 == '}') {
                            sb.append(']');
                            ++curr;
                            break;
                        }
                        if (ch2 == '(') {
                            skip = true;
                        } else if (!skip) {
                            if (ch2 == '#') {
                                if (!StringsKt.endsWith$default((CharSequence)sb, (char)'[', (boolean)false, (int)2, null)) {
                                    sb.append('.');
                                }
                            } else {
                                sb.append(ch2);
                            }
                        }
                        ++curr;
                    }
                    i = curr;
                    continue;
                }
            }
            sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final List<String> reflow(int firstLineMaxWidth, int maxLineWidth) {
        int lineWidth = maxLineWidth - UtilitiesKt.getIndentSize(this.indent, this.getOptions());
        int hangingIndentSize = UtilitiesKt.getIndentSize(this.hangingIndent, this.getOptions()) - (this.quoted ? 2 : 0);
        if (this.getText().length() < firstLineMaxWidth - hangingIndentSize) {
            return CollectionsKt.listOf((Object)UtilitiesKt.collapseSpaces(this.getText()));
        }
        List<String> words = this.computeWords();
        if (words.size() == 1) {
            return CollectionsKt.listOf((Object)words.get(0));
        }
        if (firstLineMaxWidth < maxLineWidth) {
            StringBuilder line2 = new StringBuilder();
            int firstLineWidth = firstLineMaxWidth - UtilitiesKt.getIndentSize(this.indent, this.getOptions());
            int n = ((Collection)words).size();
            for (int i = 0; i < n; ++i) {
                StringBuilder stringBuilder;
                String word = words.get(i);
                if (((CharSequence)line2).length() == 0) {
                    if (word.length() + this.task.getType().lineOverhead() > firstLineMaxWidth) {
                        return this.reflow(words, lineWidth, hangingIndentSize);
                    }
                    stringBuilder = line2.append(word);
                    continue;
                }
                if (line2.length() + word.length() + 1 <= firstLineWidth) {
                    line2.append(' ');
                    stringBuilder = line2.append(word);
                    continue;
                }
                List<String> remainingWords = words.subList(i, words.size());
                List<String> reflownRemaining = this.reflow(remainingWords, lineWidth, hangingIndentSize);
                return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)line2.toString()), (Iterable)reflownRemaining);
            }
            return CollectionsKt.listOf((Object)line2.toString());
        }
        return this.reflow(words, lineWidth, hangingIndentSize);
    }

    private final List<String> reflow(List<String> words, int lineWidth, int hangingIndentSize) {
        block15: {
            block14: {
                boolean bl;
                block12: {
                    if (this.getOptions().getAlternate() || !this.getOptions().getOptimal() || this.hanging && hangingIndentSize > 0) break block14;
                    Iterable $this$any$iv = words;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(it.length() > lineWidth)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block15;
            }
            return this.reflowGreedy(lineWidth, this.getOptions(), words);
        }
        List<String> lines = this.reflowOptimal(lineWidth - hangingIndentSize, words);
        if (lines.size() <= 2) {
            return this.reflowGreedy(lineWidth, this.getOptions(), words);
        }
        Function1 maxLine = Paragraph::reflow$lambda$2;
        int longestLine = ((Number)UtilitiesKt.maxOf((Iterable)lines, maxLine)).intValue();
        for (int lastWord = words.size() - 1; lastWord > 0; --lastWord) {
            boolean bl;
            List<String> newLines;
            block13: {
                newLines = this.reflowOptimal(lineWidth - hangingIndentSize, words.subList(0, lastWord));
                if (newLines.size() >= lines.size()) continue;
                int newLongestLine = ((Number)UtilitiesKt.maxOf((Iterable)newLines, maxLine)).intValue();
                if (newLongestLine <= longestLine) break;
                Iterable $this$any$iv = newLines.subList(0, newLines.size() - 1);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!(it.length() > longestLine)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (!bl) break;
            return CollectionsKt.plus((Collection)newLines, (Iterable)this.reflowGreedy(lineWidth - hangingIndentSize, this.getOptions(), words.subList(lastWord, words.size())));
        }
        return lines;
    }

    private final boolean canBreakAt(String prev, String word) {
        String wordWithSpace;
        if (StringsKt.startsWith$default((String)word, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)word, (String)"```", (boolean)false, (int)2, null) || UtilitiesKt.isDirectiveMarker(word) || StringsKt.startsWith$default((String)word, (String)"@", (boolean)false, (int)2, null) || UtilitiesKt.isTodo(word) || StringsKt.startsWith$default((String)word, (String)">", (boolean)false, (int)2, null)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)prev, (Object)"@sample")) {
            return false;
        }
        return Character.isLetter(StringsKt.first((CharSequence)word)) || (!UtilitiesKt.isListItem(wordWithSpace = word + " ") || StringsKt.equals((String)word, (String)"<li>", (boolean)true)) && !UtilitiesKt.isQuoted(wordWithSpace);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> computeWords() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        CharSequence charSequence = this.getText();
        Regex regex = new Regex("\\s+");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        List words = (List)destination$iv$iv;
        if (words.size() == 1) {
            return words;
        }
        if (this.task.getType() != CommentType.KDOC) {
            return words;
        }
        ArrayList combined = new ArrayList(words.size());
        int from = 0;
        int end = words.size();
        while (from < end) {
            int start = from == 0 && (this.quoted || this.hanging && !UtilitiesKt.isKDocTag(this.getText())) ? from + 2 : from + 1;
            int to = words.size();
            int n2 = words.size();
            for (int i = start; i < n2; ++i) {
                String next = (String)words.get(i);
                if (StringsKt.startsWith$default((String)next, (String)"[", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)next, (String)"[[", (boolean)false, (int)2, null)) {
                    int j = -1;
                    int n3 = words.size();
                    for (int k = i; k < n3; ++k) {
                        if (!StringsKt.contains$default((CharSequence)((CharSequence)words.get(k)), (char)']', (boolean)false, (int)2, null)) continue;
                        j = k;
                        break;
                    }
                    if (j == -1) continue;
                    if (start == from + 1 && this.canBreakAt((String)words.get(start - 1), (String)words.get(start))) {
                        combined.add(words.get(from));
                        from = start;
                    }
                    if ((to = j + 1) != words.size() && !this.canBreakAt((String)words.get(to - 1), (String)words.get(to))) continue;
                    break;
                }
                if (!this.canBreakAt((String)words.get(i - 1), next)) continue;
                to = i;
                break;
            }
            if (to == from + 1) {
                combined.add(words.get(from));
            } else if (to > from) {
                combined.add(CollectionsKt.joinToString$default((Iterable)words.subList(from, to), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
            from = to;
        }
        return combined;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> reflowOptimal(int maxLineWidth, List<String> words) {
        void $this$mapTo$iv$iv2;
        int count = words.size();
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.add(0);
        Iterable $this$map$iv = words;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.length());
        }
        Iterator iterator = CollectionsKt.toList((Iterable)((List)destination$iv$iv)).iterator();
        while (iterator.hasNext()) {
            int boxWidth = ((Number)iterator.next()).intValue();
            offsets.add(((Number)CollectionsKt.last((List)offsets)).intValue() + Math.min(boxWidth, maxLineWidth));
        }
        int big = 0xA00000;
        $i$f$map = 0;
        int $this$mapTo$iv$iv2 = count + 1;
        destination$iv$iv = new int[$this$mapTo$iv$iv2];
        while ($i$f$map < $this$mapTo$iv$iv2) {
            $i$f$mapTo = $i$f$map++;
            destination$iv$iv[$i$f$mapTo] = big;
        }
        Object minimum = destination$iv$iv;
        int[] breaks = new int[count + 1];
        minimum[0] = false;
        int n = count + 1;
        int i = 0;
        int offset = 0;
        while (true) {
            int r = Math.min(n, 1 << i + 1);
            int edge = (1 << i) + offset;
            Paragraph.reflowOptimal$search((int[])minimum, breaks, offsets, maxLineWidth, big, 0 + offset, edge, edge, r + offset);
            Object x = minimum[r - 1 + offset];
            boolean flag = true;
            int n2 = r - 1;
            for (int j = 1 << i; j < n2; ++j) {
                int y = Paragraph.reflowOptimal$cost(offsets, maxLineWidth, (int[])minimum, big, j + offset, r - 1 + offset);
                if (y > x) continue;
                n -= j;
                i = 0;
                offset += j;
                flag = false;
                break;
            }
            if (!flag) continue;
            if (r == n) break;
            ++i;
        }
        int j = count;
        while (j > 0) {
            i = breaks[j];
            StringBuilder sb = new StringBuilder();
            int n3 = j;
            for (int w = i; w < n3; ++w) {
                sb.append(words.get(w));
                if (w >= j - 1) continue;
                sb.append(' ');
            }
            lines.add(sb.toString());
            j = i;
        }
        CollectionsKt.reverse((List)lines);
        return lines;
    }

    private final List<String> reflowGreedy(int lineWidth, KDocFormattingOptions options, List<String> words) {
        int width = lineWidth;
        if (options.getHangingIndent() > 0 && this.hanging && this.continuation) {
            width -= UtilitiesKt.getIndentSize(this.hangingIndent, options);
        }
        List lines = new ArrayList();
        int column = 0;
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (((CharSequence)sb).length() == 0) {
                sb.append(word);
                column += word.length();
                continue;
            }
            if (column + word.length() + 1 <= width) {
                sb.append(' ').append(word);
                column += word.length() + 1;
                continue;
            }
            width = lineWidth;
            if (options.getHangingIndent() > 0 && this.hanging) {
                width -= UtilitiesKt.getIndentSize(this.hangingIndent, options);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            lines.add(string);
            sb.setLength(0);
            sb.append(word);
            column = sb.length();
        }
        if (((CharSequence)sb).length() > 0) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            lines.add(string);
        }
        return lines;
    }

    @NotNull
    public String toString() {
        return this.content + ", separate=" + this.separate + ", block=" + this.block + ", hanging=" + this.hanging + ", preformatted=" + this.preformatted + ", quoted=" + this.quoted + ", continuation=" + this.continuation + ", allowempty=" + this.allowEmpty + ", separator=" + this.separator;
    }

    private static final int reflow$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.indexOf$default((CharSequence)it, (char)' ', (int)0, (boolean)false, (int)6, null) == -1 ? 0 : it.length();
    }

    private static final int reflowOptimal$cost(ArrayList<Integer> offsets, int $maxLineWidth, int[] minimum, int big, int i, int j) {
        int n;
        int n2 = ((Number)offsets.get(j)).intValue();
        Integer n3 = offsets.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"get(...)");
        int width = n2 - ((Number)n3).intValue() + j - i - 1;
        if (width <= $maxLineWidth) {
            int squared = ($maxLineWidth - width) * ($maxLineWidth - width);
            n = minimum[i] + squared;
        } else {
            n = big;
        }
        return n;
    }

    private static final void reflowOptimal$search(int[] minimum, int[] breaks, ArrayList<Integer> offsets, int $maxLineWidth, int big, int pi0, int pj0, int pi1, int pj1) {
        ArrayDeque stack = new ArrayDeque();
        stack.add((Object)new Quadruple(pi0, pj0, pi1, pj1));
        while (!((Collection)stack).isEmpty()) {
            Quadruple quadruple = (Quadruple)stack.removeLast();
            int i0 = quadruple.component1();
            int j0 = quadruple.component2();
            int i1 = quadruple.component3();
            int j1 = quadruple.component4();
            if (j0 >= j1) continue;
            int j = (j0 + j1) / 2;
            for (int i = i0; i < i1; ++i) {
                int c = Paragraph.reflowOptimal$cost(offsets, $maxLineWidth, minimum, big, i, j);
                if (c > minimum[j]) continue;
                minimum[j] = c;
                breaks[j] = i;
            }
            stack.add((Object)new Quadruple(breaks[j], j + 1, i1, j1));
            stack.add((Object)new Quadruple(i0, j0, breaks[j] + 1, j));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/facebook/ktfmt/kdoc/Paragraph$Quadruple;", "", "i0", "", "j0", "i1", "j1", "<init>", "(IIII)V", "getI0", "()I", "getJ0", "getI1", "getJ1", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ktfmt"})
    private static final class Quadruple {
        private final int i0;
        private final int j0;
        private final int i1;
        private final int j1;

        public Quadruple(int i0, int j0, int i1, int j1) {
            this.i0 = i0;
            this.j0 = j0;
            this.i1 = i1;
            this.j1 = j1;
        }

        public final int getI0() {
            return this.i0;
        }

        public final int getJ0() {
            return this.j0;
        }

        public final int getI1() {
            return this.i1;
        }

        public final int getJ1() {
            return this.j1;
        }

        public final int component1() {
            return this.i0;
        }

        public final int component2() {
            return this.j0;
        }

        public final int component3() {
            return this.i1;
        }

        public final int component4() {
            return this.j1;
        }

        @NotNull
        public final Quadruple copy(int i0, int j0, int i1, int j1) {
            return new Quadruple(i0, j0, i1, j1);
        }

        public static /* synthetic */ Quadruple copy$default(Quadruple quadruple, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = quadruple.i0;
            }
            if ((n5 & 2) != 0) {
                n2 = quadruple.j0;
            }
            if ((n5 & 4) != 0) {
                n3 = quadruple.i1;
            }
            if ((n5 & 8) != 0) {
                n4 = quadruple.j1;
            }
            return quadruple.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Quadruple(i0=" + this.i0 + ", j0=" + this.j0 + ", i1=" + this.i1 + ", j1=" + this.j1 + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.i0);
            result2 = result2 * 31 + Integer.hashCode(this.j0);
            result2 = result2 * 31 + Integer.hashCode(this.i1);
            result2 = result2 * 31 + Integer.hashCode(this.j1);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Quadruple)) {
                return false;
            }
            Quadruple quadruple = (Quadruple)other;
            if (this.i0 != quadruple.i0) {
                return false;
            }
            if (this.j0 != quadruple.j0) {
                return false;
            }
            if (this.i1 != quadruple.i1) {
                return false;
            }
            return this.j1 == quadruple.j1;
        }
    }
}

