/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TypeSafeTemplate;
import com.github.jknack.handlebars.internal.FastStringWriter;
import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

abstract class BaseTemplate
implements Template {
    protected final Handlebars handlebars;
    protected int line;
    protected int column;
    protected String filename;
    private String javaScript;

    BaseTemplate(Handlebars handlebars) {
        this.handlebars = Validate.notNull(handlebars, "The handlebars can't be null.", new Object[0]);
    }

    @Override
    public final String apply(Object context) throws IOException {
        return this.apply(BaseTemplate.wrap(context));
    }

    @Override
    public final void apply(Object context, Writer writer) throws IOException {
        this.apply(BaseTemplate.wrap(context), writer);
    }

    @Override
    public String apply(Context context) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        this.apply(context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public void apply(Context context, Writer writer) throws IOException {
        boolean decorate = this.decorate();
        try {
            if (decorate) {
                this.before(context, writer);
            }
            this.merge(context, writer);
        }
        catch (HandlebarsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String evidence = this.toString();
            String reason = ex.toString();
            String message = this.filename + ":" + this.line + ":" + this.column + ": " + reason + "\n";
            message = message + "    " + StringUtils.join((Object[])StringUtils.split(evidence, "\n"), "\n    ");
            HandlebarsError error = new HandlebarsError(this.filename, this.line, this.column, reason, evidence, message);
            HandlebarsException hex = new HandlebarsException(error, (Throwable)ex);
            hex.setStackTrace(ex.getStackTrace());
            throw hex;
        }
        finally {
            if (decorate) {
                this.after(context, writer);
            }
        }
    }

    private static Context wrap(Object candidate) {
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        return Context.newContext(candidate);
    }

    public void before(Context context, Writer writer) throws IOException {
    }

    public void after(Context context, Writer writer) throws IOException {
    }

    protected abstract void merge(Context var1, Writer var2) throws IOException;

    public String toString() {
        return this.filename + ":" + this.line + ":" + this.column;
    }

    public BaseTemplate filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public int[] position() {
        return new int[]{this.line, this.column};
    }

    public BaseTemplate position(int line, int column) {
        this.line = line;
        this.column = column;
        return this;
    }

    @Override
    public <T, S extends TypeSafeTemplate<T>> S as(Class<S> rootType) {
        Validate.notNull(rootType, "The rootType can't be null.", new Object[0]);
        Validate.isTrue(rootType.isInterface(), "Not an interface: %s", rootType.getName());
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(rootType, this);
        return (S)template;
    }

    @Override
    public <T> TypeSafeTemplate<T> as() {
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(TypeSafeTemplate.class, this);
        return template;
    }

    private static Object newTypeSafeTemplate(final Class<?> rootType, final Template template) {
        return Proxy.newProxyInstance(rootType.getClassLoader(), new Class[]{rootType}, new InvocationHandler(){
            private final Map<String, Object> attributes = new HashMap<String, Object>();
            private final Object[] emptyArgs = new Object[0];

            private boolean isDefault(Method method) {
                return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
            }

            private Object invokeDefaultMethod(Method method, Class<?> lookupClass, Object proxy, Object ... args) throws Throwable {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                return ((MethodHandles.Lookup)constructor.newInstance(lookupClass, -1)).unreflectSpecial(method, lookupClass).bindTo(proxy).invokeWithArguments(args);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] methodArgs) throws Throwable {
                Object[] args;
                Object[] objectArray = args = methodArgs == null ? this.emptyArgs : methodArgs;
                if (this.isDefault(method)) {
                    return this.invokeDefaultMethod(method, rootType, proxy, args);
                }
                String methodName = method.getName();
                if (args.length == 0 && methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                if (args.length == 0 && methodName.equals("toString")) {
                    return String.format("TypeSafeTemplateProxy{interface=%s}", rootType.getSimpleName());
                }
                if (args.length == 1 && methodName.equals("equals") && method.getParameterTypes()[0] == Object.class) {
                    return args[0] == proxy;
                }
                if ("apply".equals(methodName)) {
                    Context context = Context.newBuilder(args[0]).combine(this.attributes).build();
                    this.attributes.clear();
                    if (args.length == 2) {
                        template.apply(context, (Writer)args[1]);
                        return null;
                    }
                    return template.apply(context);
                }
                if (Modifier.isPublic(method.getModifiers()) && methodName.startsWith("set")) {
                    String attrName = StringUtils.uncapitalize(methodName.substring("set".length()));
                    if (args.length == 1 && attrName.length() > 0) {
                        this.attributes.put(attrName, args[0]);
                        if (TypeSafeTemplate.class.isAssignableFrom(method.getReturnType())) {
                            return proxy;
                        }
                        return null;
                    }
                }
                String message = String.format("No handler method for: '%s(%s)', expected method signature is: 'setXxx(value)'", methodName, StringUtils.join(args, ", "));
                throw new UnsupportedOperationException(message);
            }
        });
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        Validate.isTrue(tagType.length > 0, "At least one tag type is required.", new Object[0]);
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        for (TagType tt : tagType) {
            this.collect(tagNames, tt);
        }
        return new ArrayList<String>(tagNames);
    }

    protected void collect(Collection<String> result, TagType tagType) {
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        this.collectReferenceParameters(paramNames);
        return new ArrayList<String>(paramNames);
    }

    protected void collectReferenceParameters(Collection<String> result) {
    }

    @Override
    public String toJavaScript() {
        if (this.javaScript == null) {
            this.javaScript = this.handlebars.precompileInline(this.text());
        }
        return this.javaScript;
    }

    public boolean decorate() {
        return false;
    }
}

