/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventNotifier;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.TTY;
import com.sun.tools.example.debug.tty.ThreadInfo;

public class EventHandler
implements Runnable {
    EventNotifier notifier;
    Thread thread;
    volatile boolean connected = true;
    boolean completed = false;
    String shutdownMessageKey;
    boolean stopOnVMStart;
    private boolean vmDied = false;

    EventHandler(EventNotifier notifier, boolean stopOnVMStart) {
        this.notifier = notifier;
        this.stopOnVMStart = stopOnVMStart;
        this.thread = new Thread((Runnable)this, "event-handler");
        this.thread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventQueue queue = Env.vm().eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                boolean resumeStoppedApp = false;
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    resumeStoppedApp |= !this.handleEvent(it.nextEvent());
                }
                if (resumeStoppedApp) {
                    eventSet.resume();
                    continue;
                }
                if (eventSet.suspendPolicy() != 2) continue;
                this.setCurrentThread(eventSet);
                this.notifier.vmInterrupted();
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private boolean handleEvent(Event event) {
        this.notifier.receivedEvent(event);
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent(event);
        }
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent(event);
        }
        if (event instanceof WatchpointEvent) {
            return this.fieldWatchEvent(event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent(event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.methodEntryEvent(event);
        }
        if (event instanceof MethodExitEvent) {
            return this.methodExitEvent(event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent(event);
        }
        if (event instanceof ClassUnloadEvent) {
            return this.classUnloadEvent(event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.threadStartEvent(event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.threadDeathEvent(event);
        }
        if (event instanceof VMStartEvent) {
            return this.vmStartEvent(event);
        }
        return this.handleExitEvent(event);
    }

    private boolean handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            return this.vmDeathEvent(event);
        }
        if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            if (!this.vmDied) {
                this.vmDisconnectEvent(event);
            }
            ((TTY)this.notifier).setShuttingDown(true);
            Env.shutdown(this.shutdownMessageKey);
            return false;
        }
        throw new InternalError(MessageOutput.format("Unexpected event type", new Object[]{event.getClass()}));
    }

    synchronized void handleDisconnectedException() {
        EventQueue queue = Env.vm().eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    this.handleExitEvent((Event)iter.next());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InternalError internalError) {
            }
        }
    }

    private ThreadReference eventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private void setCurrentThread(EventSet set) {
        ThreadReference thread;
        if (set.size() > 0) {
            Event event = (Event)set.iterator().next();
            thread = this.eventThread(event);
        } else {
            thread = null;
        }
        this.setCurrentThread(thread);
    }

    private void setCurrentThread(ThreadReference thread) {
        ThreadInfo.invalidateAll();
        ThreadInfo.setCurrentThread(thread);
    }

    private boolean vmStartEvent(Event event) {
        VMStartEvent se = (VMStartEvent)event;
        this.notifier.vmStartEvent(se);
        return this.stopOnVMStart;
    }

    private boolean breakpointEvent(Event event) {
        BreakpointEvent be = (BreakpointEvent)event;
        this.notifier.breakpointEvent(be);
        return true;
    }

    private boolean methodEntryEvent(Event event) {
        MethodEntryEvent me = (MethodEntryEvent)event;
        this.notifier.methodEntryEvent(me);
        return true;
    }

    private boolean methodExitEvent(Event event) {
        MethodExitEvent me = (MethodExitEvent)event;
        return this.notifier.methodExitEvent(me);
    }

    private boolean fieldWatchEvent(Event event) {
        WatchpointEvent fwe = (WatchpointEvent)event;
        this.notifier.fieldWatchEvent(fwe);
        return true;
    }

    private boolean stepEvent(Event event) {
        StepEvent se = (StepEvent)event;
        this.notifier.stepEvent(se);
        return true;
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent cle = (ClassPrepareEvent)event;
        this.notifier.classPrepareEvent(cle);
        if (!Env.specList.resolve(cle)) {
            MessageOutput.lnprint("Stopping due to deferred breakpoint errors.");
            return true;
        }
        return false;
    }

    private boolean classUnloadEvent(Event event) {
        ClassUnloadEvent cue = (ClassUnloadEvent)event;
        this.notifier.classUnloadEvent(cue);
        return false;
    }

    private boolean exceptionEvent(Event event) {
        ExceptionEvent ee = (ExceptionEvent)event;
        this.notifier.exceptionEvent(ee);
        return true;
    }

    private boolean threadDeathEvent(Event event) {
        ThreadDeathEvent tee = (ThreadDeathEvent)event;
        ThreadInfo.removeThread(tee.thread());
        return false;
    }

    private boolean threadStartEvent(Event event) {
        ThreadStartEvent tse = (ThreadStartEvent)event;
        ThreadInfo.addThread(tse.thread());
        this.notifier.threadStartEvent(tse);
        return false;
    }

    public boolean vmDeathEvent(Event event) {
        this.shutdownMessageKey = "The application exited";
        this.notifier.vmDeathEvent((VMDeathEvent)event);
        return false;
    }

    public boolean vmDisconnectEvent(Event event) {
        this.shutdownMessageKey = "The application has been disconnected";
        this.notifier.vmDisconnectEvent((VMDisconnectEvent)event);
        return false;
    }
}

