/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;

class ExceptionSpec
extends EventRequestSpec {
    private boolean notifyCaught;
    private boolean notifyUncaught;

    private ExceptionSpec(ReferenceTypeSpec refSpec) {
        this(refSpec, true, true);
    }

    ExceptionSpec(ReferenceTypeSpec refSpec, boolean notifyCaught, boolean notifyUncaught) {
        super(refSpec);
        this.notifyCaught = notifyCaught;
        this.notifyUncaught = notifyUncaught;
    }

    @Override
    EventRequest resolveEventRequest(ReferenceType refType) {
        EventRequestManager em = refType.virtualMachine().eventRequestManager();
        ExceptionRequest excReq = em.createExceptionRequest(refType, this.notifyCaught, this.notifyUncaught);
        excReq.enable();
        return excReq;
    }

    public boolean notifyCaught() {
        return this.notifyCaught;
    }

    public boolean notifyUncaught() {
        return this.notifyUncaught;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.notifyCaught() ? 0 : 1);
        result = 37 * result + (this.notifyUncaught() ? 0 : 1);
        result = 37 * result + this.refSpec.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExceptionSpec) {
            ExceptionSpec es = (ExceptionSpec)obj;
            if (this.refSpec.equals(es.refSpec) && this.notifyCaught() == es.notifyCaught() && this.notifyUncaught() == es.notifyUncaught()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = this.notifyCaught && !this.notifyUncaught ? MessageOutput.format("exceptionSpec caught", this.refSpec.toString()) : (this.notifyUncaught && !this.notifyCaught ? MessageOutput.format("exceptionSpec uncaught", this.refSpec.toString()) : MessageOutput.format("exceptionSpec all", this.refSpec.toString()));
        return s;
    }
}

