/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.javac.util.Warner;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public class Infer {
    protected static final Context.Key<Infer> inferKey = new Context.Key();
    Resolve rs;
    Check chk;
    Symtab syms;
    Types types;
    JCDiagnostic.Factory diags;
    Log log;
    boolean allowGraphInference;
    private final String dependenciesFolder;
    private List<String> pendingGraphs;
    public static final Type anyPoly = new Type.JCNoType();
    protected final InferenceException inferenceException;
    Type.TypeMapping<Void> fromTypeVarFun = new Type.TypeMapping<Void>(){

        @Override
        public Type visitTypeVar(Type.TypeVar tv, Void aVoid) {
            return new Type.UndetVar(tv, Infer.this.incorporationEngine(), Infer.this.types);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType t, Void aVoid) {
            return new Type.CapturedUndetVar(t, (Type.UndetVar.UndetVarListener)Infer.this.incorporationEngine(), Infer.this.types);
        }
    };
    AbstractIncorporationEngine legacyEngine = new AbstractIncorporationEngine(){

        @Override
        List<IncorporationAction> getIncorporationActions(Type.UndetVar uv, Type.UndetVar.InferenceBound ib, Type t, boolean update) {
            ListBuffer<CheckBounds> actions = new ListBuffer<CheckBounds>();
            Type inst = uv.getInst();
            if (inst != null) {
                actions.add(new CheckInst(uv, ib, new Type.UndetVar.InferenceBound[0]));
            }
            actions.add(new EqCheckLegacy(uv, t, ib));
            return actions.toList();
        }
    };
    AbstractIncorporationEngine graphEngine = new AbstractIncorporationEngine(){

        @Override
        List<IncorporationAction> getIncorporationActions(Type.UndetVar uv, Type.UndetVar.InferenceBound ib, Type t, boolean update) {
            ListBuffer<IncorporationAction> actions = new ListBuffer<IncorporationAction>();
            Type inst = uv.getInst();
            if (inst != null) {
                actions.add(new CheckInst(uv, ib, new Type.UndetVar.InferenceBound[0]));
            }
            actions.add(new CheckBounds(uv, t, ib));
            if (update) {
                return actions.toList();
            }
            if (ib == Type.UndetVar.InferenceBound.UPPER) {
                actions.add(new CheckUpperBounds(uv, t));
            }
            actions.add(new PropagateBounds(uv, t, ib));
            return actions.toList();
        }
    };
    static final int MAX_INCORPORATION_STEPS = 10000;
    Map<IncorporationBinaryOp, Boolean> incorporationCache = new HashMap<IncorporationBinaryOp, Boolean>();
    final InferenceContext emptyContext;

    public static Infer instance(Context context) {
        Infer instance = context.get(inferKey);
        if (instance == null) {
            instance = new Infer(context);
        }
        return instance;
    }

    protected Infer(Context context) {
        context.put(inferKey, this);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.inferenceException = new InferenceException(this.diags);
        Options options = Options.instance(context);
        this.allowGraphInference = Source.instance(context).allowGraphInference() && options.isUnset("useLegacyInference");
        this.dependenciesFolder = options.get("dumpInferenceGraphsTo");
        this.pendingGraphs = List.nil();
        this.emptyContext = new InferenceContext(this, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type instantiateMethod(Env<AttrContext> env, List<Type> tvars, Type.MethodType mt, Attr.ResultInfo resultInfo, Symbol.MethodSymbol msym, List<Type> argtypes, boolean allowBoxing, boolean useVarargs, Resolve.MethodResolutionContext resolveContext, Warner warn) throws InferenceException {
        InferenceContext inferenceContext = new InferenceContext(this, tvars);
        this.inferenceException.clear();
        try {
            DeferredAttr.DeferredAttrContext deferredAttrContext = resolveContext.deferredAttrContext(msym, inferenceContext, resultInfo, warn);
            resolveContext.methodCheck.argumentsAcceptable(env, deferredAttrContext, argtypes, (List<Type>)mt.getParameterTypes(), warn);
            if (this.allowGraphInference && resultInfo != null && resultInfo.pt == anyPoly) {
                this.doIncorporation(inferenceContext, warn);
                PartiallyInferredMethodType partiallyInferredMethodType = new PartiallyInferredMethodType(mt, inferenceContext, env, warn);
                return partiallyInferredMethodType;
            }
            if (this.allowGraphInference && resultInfo != null && !warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.doIncorporation(inferenceContext, warn);
                boolean shouldPropagate = this.shouldPropagate(mt.getReturnType(), resultInfo, inferenceContext);
                InferenceContext minContext = shouldPropagate ? inferenceContext.min(this.roots(mt, deferredAttrContext), true, warn) : inferenceContext;
                Type newRestype = this.generateReturnConstraints(env.tree, resultInfo, mt, minContext);
                mt = (Type.MethodType)this.types.createMethodTypeWithReturn(mt, newRestype);
                if (shouldPropagate) {
                    minContext.dupTo(resultInfo.checkContext.inferenceContext());
                    deferredAttrContext.complete();
                    Type.MethodType methodType = mt;
                    return methodType;
                }
            }
            deferredAttrContext.complete();
            if (this.allowGraphInference) {
                inferenceContext.solve(warn);
            } else {
                inferenceContext.solveLegacy(true, warn, LegacyInferenceSteps.EQ_LOWER.steps);
            }
            mt = (Type.MethodType)inferenceContext.asInstType(mt);
            if (!this.allowGraphInference && inferenceContext.restvars().nonEmpty() && resultInfo != null && !warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.generateReturnConstraints(env.tree, resultInfo, mt, inferenceContext);
                inferenceContext.solveLegacy(false, warn, LegacyInferenceSteps.EQ_UPPER.steps);
                mt = (Type.MethodType)inferenceContext.asInstType(mt);
            }
            if (resultInfo != null && this.rs.verboseResolutionMode.contains((Object)Resolve.VerboseResolutionMode.DEFERRED_INST)) {
                this.log.note(env.tree.pos, "deferred.method.inst", msym, mt, resultInfo.pt);
            }
            Type.MethodType methodType = mt;
            return methodType;
        }
        finally {
            if (resultInfo != null || !this.allowGraphInference) {
                inferenceContext.notifyChange();
            } else {
                inferenceContext.notifyChange(inferenceContext.boundedVars());
            }
            if (resultInfo == null) {
                inferenceContext.captureTypeCache.clear();
            }
            this.dumpGraphsIfNeeded(env.tree, msym, resolveContext);
        }
    }

    private boolean shouldPropagate(Type restype, Attr.ResultInfo target, InferenceContext inferenceContext) {
        return target.checkContext.inferenceContext() != this.emptyContext && inferenceContext.free(restype) && (!inferenceContext.inferencevars.contains(restype) || !this.needsEagerInstantiation((Type.UndetVar)inferenceContext.asUndetVar(restype), target.pt, inferenceContext));
    }

    private List<Type> roots(Type.MethodType mt, DeferredAttr.DeferredAttrContext deferredAttrContext) {
        ListBuffer<Type> roots = new ListBuffer<Type>();
        roots.add(mt.getReturnType());
        if (deferredAttrContext != null && deferredAttrContext.mode == DeferredAttr.AttrMode.CHECK) {
            roots.addAll(mt.getThrownTypes());
            for (DeferredAttr.DeferredAttrNode n : deferredAttrContext.deferredAttrNodes) {
                roots.addAll((Collection<Type>)n.deferredStuckPolicy.stuckVars());
                roots.addAll((Collection<Type>)n.deferredStuckPolicy.depVars());
            }
        }
        return roots.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpGraphsIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol msym, Resolve.MethodResolutionContext rsContext) {
        int round = 0;
        try {
            for (String graph : this.pendingGraphs.reverse()) {
                Assert.checkNonNull(this.dependenciesFolder);
                Name name = msym.name == msym.name.table.names.init ? msym.owner.name : msym.name;
                String filename = String.format("%s@%s[mode=%s,step=%s]_%d.dot", new Object[]{name, pos.getStartPosition(), rsContext.attrMode(), rsContext.step, round});
                Path dotFile = Paths.get(this.dependenciesFolder, filename);
                try (BufferedWriter w = Files.newBufferedWriter(dotFile, new OpenOption[0]);){
                    w.append(graph);
                }
                ++round;
            }
        }
        catch (IOException ex) {
            Assert.error("Error occurred when dumping inference graph: " + ex.getMessage());
        }
        finally {
            this.pendingGraphs = List.nil();
        }
    }

    Type generateReturnConstraints(JCTree tree, Attr.ResultInfo resultInfo, Type.MethodType mt, InferenceContext inferenceContext) {
        InferenceContext rsInfoInfContext = resultInfo.checkContext.inferenceContext();
        Type from = mt.getReturnType();
        if (mt.getReturnType().containsAny(inferenceContext.inferencevars) && rsInfoInfContext != this.emptyContext) {
            from = this.types.capture(from);
            for (Type t : from.getTypeArguments()) {
                if (!t.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)t).isCaptured()) continue;
                inferenceContext.addVar((Type.TypeVar)t);
            }
        }
        Type qtype = inferenceContext.asUndetVar(from);
        Type to = resultInfo.pt;
        if (qtype.hasTag(TypeTag.VOID)) {
            to = this.syms.voidType;
        } else if (to.hasTag(TypeTag.NONE)) {
            to = from.isPrimitive() ? from : this.syms.objectType;
        } else if (qtype.hasTag(TypeTag.UNDETVAR)) {
            if (this.needsEagerInstantiation((Type.UndetVar)qtype, to, inferenceContext) && (this.allowGraphInference || !to.isPrimitive())) {
                to = this.generateReferenceToTargetConstraint(tree, (Type.UndetVar)qtype, to, resultInfo, inferenceContext);
            } else if (to.isPrimitive()) {
                to = this.types.boxedClass((Type)to).type;
            }
        } else if (rsInfoInfContext.free(resultInfo.pt)) {
            qtype = inferenceContext.asUndetVar(rsInfoInfContext.cachedCapture(tree, from, false));
        }
        Assert.check(this.allowGraphInference || !rsInfoInfContext.free(to), "legacy inference engine cannot handle constraints on both sides of a subtyping assertion");
        Warner retWarn = new Warner();
        if (!resultInfo.checkContext.compatible(qtype, rsInfoInfContext.asUndetVar(to), retWarn) || !this.allowGraphInference && retWarn.hasLint(Lint.LintCategory.UNCHECKED)) {
            throw this.inferenceException.setMessage("infer.no.conforming.instance.exists", inferenceContext.restvars(), mt.getReturnType(), to);
        }
        return from;
    }

    private boolean needsEagerInstantiation(Type.UndetVar from, Type to, InferenceContext inferenceContext) {
        if (to.isPrimitive()) {
            for (Type t : from.getBounds(Type.UndetVar.InferenceBound.values())) {
                Type boundAsPrimitive = this.types.unboxedType(t);
                if (boundAsPrimitive == null || boundAsPrimitive.hasTag(TypeTag.NONE)) continue;
                return true;
            }
            return false;
        }
        Type captureOfTo = this.types.capture(to);
        if (captureOfTo == to) {
            for (Type t : from.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                Type captureOfBound = this.types.capture(t);
                if (captureOfBound == t) continue;
                return true;
            }
            for (Type aLowerBound : from.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                for (Type anotherLowerBound : from.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    if (aLowerBound == anotherLowerBound || inferenceContext.free(aLowerBound) || inferenceContext.free(anotherLowerBound) || !this.commonSuperWithDiffParameterization(aLowerBound, anotherLowerBound)) continue;
                    return true;
                }
            }
        }
        if (to.isParameterized()) {
            for (Type t : from.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                Type sup = this.types.asSuper(t, to.tsym);
                if (sup == null || !sup.isRaw()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean commonSuperWithDiffParameterization(Type t, Type s) {
        for (Pair<Type, Type> supers : this.getParameterizedSupers(t, s)) {
            if (this.types.isSameType((Type)supers.fst, (Type)supers.snd)) continue;
            return true;
        }
        return false;
    }

    private Type generateReferenceToTargetConstraint(JCTree tree, Type.UndetVar from, Type to, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        inferenceContext.solve(List.of(from.qtype), new Warner());
        inferenceContext.notifyChange();
        Type capturedType = resultInfo.checkContext.inferenceContext().cachedCapture(tree, from.getInst(), false);
        if (this.types.isConvertible(capturedType, resultInfo.checkContext.inferenceContext().asUndetVar(to))) {
            return this.syms.objectType;
        }
        return to;
    }

    void instantiateAsUninferredVars(List<Type> vars, InferenceContext inferenceContext) {
        ListBuffer<Type.UndetVar> todo = new ListBuffer<Type.UndetVar>();
        for (Type t : vars) {
            Type.UndetVar undetVar = (Type.UndetVar)inferenceContext.asUndetVar(t);
            List<Type> upperBounds = undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER);
            if (Type.containsAny(upperBounds, vars)) {
                Symbol.TypeVariableSymbol fresh_tvar = new Symbol.TypeVariableSymbol(4096L, undetVar.qtype.tsym.name, null, undetVar.qtype.tsym.owner);
                fresh_tvar.type = new Type.TypeVar(fresh_tvar, this.types.makeIntersectionType(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)), null);
                todo.append(undetVar);
                undetVar.setInst(fresh_tvar.type);
                continue;
            }
            if (upperBounds.nonEmpty()) {
                undetVar.setInst(this.types.glb(upperBounds));
                continue;
            }
            undetVar.setInst(this.syms.objectType);
        }
        List<Type> formals = vars;
        for (Type type : todo) {
            Type.UndetVar uv = (Type.UndetVar)type;
            Type.TypeVar ct2 = (Type.TypeVar)uv.getInst();
            ct2.bound = this.types.glb(inferenceContext.asInstTypes(this.types.getBounds(ct2)));
            if (ct2.bound.isErroneous()) {
                this.reportBoundError(uv, Type.UndetVar.InferenceBound.UPPER);
            }
            formals = formals.tail;
        }
    }

    Type instantiatePolymorphicSignatureInstance(Env<AttrContext> env, Symbol.MethodSymbol spMethod, Resolve.MethodResolutionContext resolveContext, List<Type> argtypes) {
        Type restype;
        switch (env.next.tree.getTag()) {
            case TYPECAST: {
                JCTree.JCTypeCast castTree = (JCTree.JCTypeCast)env.next.tree;
                restype = TreeInfo.skipParens(castTree.expr) == env.tree ? castTree.clazz.type : this.syms.objectType;
                break;
            }
            case EXEC: {
                JCTree.JCExpressionStatement execTree = (JCTree.JCExpressionStatement)env.next.tree;
                restype = TreeInfo.skipParens(execTree.expr) == env.tree ? this.syms.voidType : this.syms.objectType;
                break;
            }
            default: {
                restype = this.syms.objectType;
            }
        }
        List<Type> paramtypes = argtypes.map(new ImplicitArgType(spMethod, resolveContext.step));
        List<Type> exType = spMethod != null ? spMethod.getThrownTypes() : List.of(this.syms.throwableType);
        Type.MethodType mtype = new Type.MethodType(paramtypes, restype, exType, this.syms.methodClass);
        return mtype;
    }

    public Type instantiateFunctionalInterface(JCDiagnostic.DiagnosticPosition pos, Type funcInterface, List<Type> paramTypes, Check.CheckContext checkContext) {
        if (this.types.capture(funcInterface) == funcInterface) {
            return funcInterface;
        }
        Type formalInterface = funcInterface.tsym.type;
        InferenceContext funcInterfaceContext = new InferenceContext(this, funcInterface.tsym.type.getTypeArguments());
        Assert.check(paramTypes != null);
        List<Type> descParameterTypes = this.types.findDescriptorType(formalInterface).getParameterTypes();
        if (descParameterTypes.size() != paramTypes.size()) {
            checkContext.report(pos, this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
            return this.types.createErrorType(funcInterface);
        }
        for (Type type : descParameterTypes) {
            if (!this.types.isSameType(funcInterfaceContext.asUndetVar(type), (Type)paramTypes.head)) {
                checkContext.report(pos, this.diags.fragment("no.suitable.functional.intf.inst", funcInterface));
                return this.types.createErrorType(funcInterface);
            }
            paramTypes = paramTypes.tail;
        }
        List<Type> actualTypeargs = funcInterface.getTypeArguments();
        for (Type t : funcInterfaceContext.undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            Optional<Type> inst = uv.getBounds(Type.UndetVar.InferenceBound.EQ).stream().filter(b -> !b.containsAny(formalInterface.getTypeArguments())).findFirst();
            uv.setInst(inst.orElse((Type)actualTypeargs.head));
            actualTypeargs = actualTypeargs.tail;
        }
        Type type = funcInterfaceContext.asInstType(formalInterface);
        if (!this.chk.checkValidGenericType(type)) {
            checkContext.report(pos, this.diags.fragment("no.suitable.functional.intf.inst", funcInterface));
        }
        checkContext.compatible(type, funcInterface, this.types.noWarnings);
        return type;
    }

    AbstractIncorporationEngine incorporationEngine() {
        return this.allowGraphInference ? this.graphEngine : this.legacyEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIncorporation(InferenceContext inferenceContext, Warner warn) throws InferenceException {
        try {
            boolean progress = true;
            for (int round = 0; progress && round < 10000; ++round) {
                progress = false;
                for (Type t : inferenceContext.undetvars) {
                    Type.UndetVar uv = (Type.UndetVar)t;
                    if (uv.incorporationActions.isEmpty()) continue;
                    progress = true;
                    uv.incorporationActions.removeFirst().apply(inferenceContext, warn);
                }
            }
        }
        finally {
            this.incorporationCache.clear();
        }
    }

    private List<Pair<Type, Type>> getParameterizedSupers(Type t, Type s) {
        Type lubResult = this.types.lub(t, s);
        if (lubResult == this.syms.errType || lubResult == this.syms.botType) {
            return List.nil();
        }
        List<Type> supertypesToCheck = lubResult.isIntersection() ? ((Type.IntersectionClassType)lubResult).getComponents() : List.of(lubResult);
        ListBuffer<Pair<Type, Type>> commonSupertypes = new ListBuffer<Pair<Type, Type>>();
        for (Type sup : supertypesToCheck) {
            if (!sup.isParameterized()) continue;
            Type asSuperOfT = this.asSuper(t, sup);
            Type asSuperOfS = this.asSuper(s, sup);
            commonSupertypes.add(new Pair<Type, Type>(asSuperOfT, asSuperOfS));
        }
        return commonSupertypes.toList();
    }

    private Type asSuper(Type t, Type sup) {
        return sup.hasTag(TypeTag.ARRAY) ? new Type.ArrayType(this.asSuper(this.types.elemtype(t), this.types.elemtype(sup)), this.syms.arrayClass) : this.types.asSuper(t, sup.tsym);
    }

    boolean doIncorporationOp(IncorporationBinaryOpKind opKind, Type op1, Type op2, Warner warn) {
        IncorporationBinaryOp newOp = new IncorporationBinaryOp(opKind, op1, op2);
        Boolean res = this.incorporationCache.get(newOp);
        if (res == null) {
            res = newOp.apply(warn);
            this.incorporationCache.put(newOp, res);
        }
        return res;
    }

    void reportInstError(Type.UndetVar uv, Type.UndetVar.InferenceBound ib) {
        this.reportInferenceError(String.format("inferred.do.not.conform.to.%s.bounds", StringUtils.toLowerCase(ib.name())), uv.getInst(), uv.getBounds(ib));
    }

    void reportBoundError(Type.UndetVar uv, Type.UndetVar.InferenceBound ib) {
        this.reportInferenceError(String.format("incompatible.%s.bounds", StringUtils.toLowerCase(ib.name())), uv.qtype, uv.getBounds(ib));
    }

    void reportBoundError(Type.UndetVar uv, Type.UndetVar.InferenceBound ib1, Type.UndetVar.InferenceBound ib2) {
        this.reportInferenceError(String.format("incompatible.%s.%s.bounds", StringUtils.toLowerCase(ib1.name()), StringUtils.toLowerCase(ib2.name())), uv.qtype, uv.getBounds(ib1), uv.getBounds(ib2));
    }

    void reportInferenceError(String key, Object ... args) {
        throw this.inferenceException.setMessage(key, args);
    }

    static interface FreeTypeListener {
        public void typesInferred(InferenceContext var1);
    }

    class GraphSolver {
        InferenceContext inferenceContext;
        Warner warn;

        GraphSolver(InferenceContext inferenceContext, Warner warn) {
            this.inferenceContext = inferenceContext;
            this.warn = warn;
        }

        void solve(GraphStrategy sstrategy) {
            Infer.this.doIncorporation(this.inferenceContext, this.warn);
            InferenceGraph inferenceGraph = new InferenceGraph();
            while (!sstrategy.done()) {
                if (Infer.this.dependenciesFolder != null) {
                    Infer.this.pendingGraphs = Infer.this.pendingGraphs.prepend(inferenceGraph.toDot());
                }
                InferenceGraph.Node nodeToSolve = sstrategy.pickNode(inferenceGraph);
                List<Type> varsToSolve = List.from((Iterable)nodeToSolve.data);
                List<Type> saved_undet = this.inferenceContext.save();
                try {
                    block3: while (Type.containsAny(this.inferenceContext.restvars(), varsToSolve)) {
                        for (GraphInferenceSteps step : GraphInferenceSteps.values()) {
                            if (!this.inferenceContext.solveBasic(varsToSolve, step.steps).nonEmpty()) continue;
                            Infer.this.doIncorporation(this.inferenceContext, this.warn);
                            continue block3;
                        }
                        throw Infer.this.inferenceException.setMessage();
                    }
                }
                catch (InferenceException ex) {
                    this.inferenceContext.rollback(saved_undet);
                    Infer.this.instantiateAsUninferredVars(varsToSolve, this.inferenceContext);
                    Infer.this.doIncorporation(this.inferenceContext, this.warn);
                }
                inferenceGraph.deleteNode(nodeToSolve);
            }
        }

        class InferenceGraph {
            ArrayList<Node> nodes;

            InferenceGraph() {
                this.initNodes();
            }

            public Node findNode(Type t) {
                for (Node n : this.nodes) {
                    if (!((ListBuffer)n.data).contains(t)) continue;
                    return n;
                }
                return null;
            }

            public void deleteNode(Node n) {
                Assert.check(this.nodes.contains(n));
                this.nodes.remove(n);
                this.notifyUpdate(n, null);
            }

            void notifyUpdate(Node from, Node to) {
                for (Node n : this.nodes) {
                    n.graphChanged(from, to);
                }
            }

            void initNodes() {
                this.nodes = new ArrayList();
                for (Type t : GraphSolver.this.inferenceContext.restvars()) {
                    this.nodes.add(new Node(t));
                }
                for (Node n_i : this.nodes) {
                    Type i = (Type)((ListBuffer)n_i.data).first();
                    for (Node n_j : this.nodes) {
                        Type j = (Type)((ListBuffer)n_j.data).first();
                        Type.UndetVar uv_i = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(i);
                        if (!Type.containsAny(uv_i.getBounds(Type.UndetVar.InferenceBound.values()), List.of(j))) continue;
                        n_i.addDependency(n_j);
                    }
                }
                ArrayList acyclicNodes = new ArrayList();
                for (List<Node> conSubGraph : GraphUtils.tarjan(this.nodes)) {
                    if (conSubGraph.length() > 1) {
                        Node root = (Node)conSubGraph.head;
                        root.mergeWith(conSubGraph.tail);
                        for (Node n : conSubGraph) {
                            this.notifyUpdate(n, root);
                        }
                    }
                    acyclicNodes.add(conSubGraph.head);
                }
                this.nodes = acyclicNodes;
            }

            String toDot() {
                StringBuilder buf = new StringBuilder();
                for (Type t : GraphSolver.this.inferenceContext.undetvars) {
                    Type.UndetVar uv = (Type.UndetVar)t;
                    buf.append(String.format("var %s - upper bounds = %s, lower bounds = %s, eq bounds = %s\\n", uv.qtype, uv.getBounds(Type.UndetVar.InferenceBound.UPPER), uv.getBounds(Type.UndetVar.InferenceBound.LOWER), uv.getBounds(Type.UndetVar.InferenceBound.EQ)));
                }
                return GraphUtils.toDot(this.nodes, "inferenceGraph" + this.hashCode(), buf.toString());
            }

            class Node
            extends GraphUtils.TarjanNode<ListBuffer<Type>, Node>
            implements GraphUtils.DottableNode<ListBuffer<Type>, Node> {
                Set<Node> deps;

                Node(Type ivar) {
                    super(ListBuffer.of(ivar));
                    this.deps = new HashSet<Node>();
                }

                @Override
                public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                    return DependencyKind.values();
                }

                @Override
                public Iterable<? extends Node> getAllDependencies() {
                    return this.deps;
                }

                @Override
                public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                    if (dk == DependencyKind.BOUND) {
                        return this.deps;
                    }
                    throw new IllegalStateException();
                }

                protected void addDependency(Node depToAdd) {
                    this.deps.add(depToAdd);
                }

                protected void addDependencies(Set<Node> depsToAdd) {
                    for (Node n : depsToAdd) {
                        this.addDependency(n);
                    }
                }

                protected boolean removeDependency(Node n) {
                    return this.deps.remove(n);
                }

                protected Set<Node> closure() {
                    boolean progress = true;
                    HashSet<Node> closure = new HashSet<Node>();
                    closure.add(this);
                    while (progress) {
                        progress = false;
                        for (Node n1 : new HashSet<Node>(closure)) {
                            progress = closure.addAll(n1.deps);
                        }
                    }
                    return closure;
                }

                protected boolean isLeaf() {
                    if (this.deps.isEmpty()) {
                        return true;
                    }
                    for (Node n : this.deps) {
                        if (n == this) continue;
                        return false;
                    }
                    return true;
                }

                protected void mergeWith(List<? extends Node> nodes) {
                    for (Node node : nodes) {
                        Assert.check(((ListBuffer)node.data).length() == 1, "Attempt to merge a compound node!");
                        ((ListBuffer)this.data).appendList((ListBuffer)node.data);
                        this.addDependencies(node.deps);
                    }
                    HashSet<Node> deps2 = new HashSet<Node>();
                    for (Node d : this.deps) {
                        if (((ListBuffer)this.data).contains(((ListBuffer)d.data).first())) {
                            deps2.add(this);
                            continue;
                        }
                        deps2.add(d);
                    }
                    this.deps = deps2;
                }

                private void graphChanged(Node from, Node to) {
                    if (this.removeDependency(from) && to != null) {
                        this.addDependency(to);
                    }
                }

                @Override
                public Properties nodeAttributes() {
                    Properties p = new Properties();
                    p.put("label", "\"" + this.toString() + "\"");
                    return p;
                }

                @Override
                public Properties dependencyAttributes(Node sink, GraphUtils.DependencyKind dk) {
                    Properties p = new Properties();
                    p.put("style", ((DependencyKind)dk).dotSyle);
                    StringBuilder buf = new StringBuilder();
                    String sep = "";
                    for (Type from : (ListBuffer)this.data) {
                        Type.UndetVar uv = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(from);
                        for (Type bound : uv.getBounds(Type.UndetVar.InferenceBound.values())) {
                            if (!bound.containsAny(List.from((Iterable)sink.data))) continue;
                            buf.append(sep);
                            buf.append(bound);
                            sep = ",";
                        }
                    }
                    p.put("label", "\"" + buf.toString() + "\"");
                    return p;
                }
            }
        }
    }

    static enum DependencyKind implements GraphUtils.DependencyKind
    {
        BOUND("dotted"),
        STUCK("dashed");

        final String dotSyle;

        private DependencyKind(String dotSyle) {
            this.dotSyle = dotSyle;
        }
    }

    static enum GraphInferenceSteps {
        EQ(EnumSet.of(InferenceStep.EQ)),
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_LOWER_THROWS_UPPER_CAPTURED(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER, InferenceStep.UPPER, InferenceStep.THROWS, InferenceStep.CAPTURED));

        final EnumSet<InferenceStep> steps;

        private GraphInferenceSteps(EnumSet<InferenceStep> steps) {
            this.steps = steps;
        }
    }

    static enum LegacyInferenceSteps {
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_UPPER(EnumSet.of(InferenceStep.EQ, InferenceStep.UPPER_LEGACY));

        final EnumSet<InferenceStep> steps;

        private LegacyInferenceSteps(EnumSet<InferenceStep> steps) {
            this.steps = steps;
        }
    }

    static enum InferenceStep {
        EQ(Type.UndetVar.InferenceBound.EQ){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return (Type)this.filterBounds((Type.UndetVar)uv, (InferenceContext)inferenceContext).head;
            }
        }
        ,
        LOWER(Type.UndetVar.InferenceBound.LOWER){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Type owntype;
                Infer infer = inferenceContext.infer;
                List<Type> lobounds = this.filterBounds(uv, inferenceContext);
                Type type = owntype = lobounds.tail.tail == null ? (Type)lobounds.head : infer.types.lub(lobounds);
                if (owntype.isPrimitive() || owntype.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.minimal.instance.exists", uv.qtype, lobounds);
                }
                return owntype;
            }
        }
        ,
        THROWS(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                if ((t.qtype.tsym.flags() & 0x800000000000L) == 0L) {
                    return false;
                }
                Types types = inferenceContext.types;
                Symtab syms = inferenceContext.infer.syms;
                return t.getBounds(Type.UndetVar.InferenceBound.UPPER).stream().filter(b -> !inferenceContext.free((Type)b)).allMatch(u -> types.isSubtype(syms.runtimeExceptionType, (Type)u));
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return inferenceContext.infer.syms.runtimeExceptionType;
            }
        }
        ,
        UPPER(Type.UndetVar.InferenceBound.UPPER){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Type owntype;
                Infer infer = inferenceContext.infer;
                List<Type> hibounds = this.filterBounds(uv, inferenceContext);
                Type type = owntype = hibounds.tail.tail == null ? (Type)hibounds.head : infer.types.glb(hibounds);
                if (owntype.isPrimitive() || owntype.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.maximal.instance.exists", uv.qtype, hibounds);
                }
                return owntype;
            }
        }
        ,
        UPPER_LEGACY(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                return !inferenceContext.free(t.getBounds(this.ib)) && !t.isCaptured();
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return UPPER.solve(uv, inferenceContext);
            }
        }
        ,
        CAPTURED(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                return t.isCaptured() && !inferenceContext.free(t.getBounds(Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER));
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Infer infer = inferenceContext.infer;
                Type upper = UPPER.filterBounds(uv, inferenceContext).nonEmpty() ? UPPER.solve(uv, inferenceContext) : infer.syms.objectType;
                Type lower = LOWER.filterBounds(uv, inferenceContext).nonEmpty() ? LOWER.solve(uv, inferenceContext) : infer.syms.botType;
                Type.CapturedType prevCaptured = (Type.CapturedType)uv.qtype;
                return new Type.CapturedType(prevCaptured.tsym.name, prevCaptured.tsym.owner, upper, lower, prevCaptured.wildcard);
            }
        };

        final Type.UndetVar.InferenceBound ib;

        private InferenceStep(Type.UndetVar.InferenceBound ib) {
            this.ib = ib;
        }

        abstract Type solve(Type.UndetVar var1, InferenceContext var2);

        public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
            return this.filterBounds(t, inferenceContext).nonEmpty() && !t.isCaptured();
        }

        List<Type> filterBounds(Type.UndetVar uv, InferenceContext inferenceContext) {
            return Type.filter(uv.getBounds(this.ib), new BoundFilter(inferenceContext));
        }
    }

    abstract class BestLeafSolver
    extends LeafSolver {
        List<Type> varsToSolve;
        final Map<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>> treeCache;
        final Pair<List<GraphSolver.InferenceGraph.Node>, Integer> noPath;

        BestLeafSolver(List<Type> varsToSolve) {
            this.treeCache = new HashMap<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>>();
            this.noPath = new Pair<Object, Integer>(null, Integer.MAX_VALUE);
            this.varsToSolve = varsToSolve;
        }

        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> computeTreeToLeafs(GraphSolver.InferenceGraph.Node n) {
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> cachedPath = this.treeCache.get(n);
            if (cachedPath == null) {
                if (n.isLeaf()) {
                    cachedPath = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(n), ((ListBuffer)n.data).length());
                } else {
                    Pair<List<GraphSolver.InferenceGraph.Node>, Integer> path = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(n), ((ListBuffer)n.data).length());
                    for (GraphSolver.InferenceGraph.Node node : n.getAllDependencies()) {
                        if (node == n) continue;
                        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> subpath = this.computeTreeToLeafs(node);
                        path = new Pair(((List)path.fst).prependList((List)subpath.fst), (Integer)path.snd + (Integer)subpath.snd);
                    }
                    cachedPath = path;
                }
                this.treeCache.put(n, cachedPath);
            }
            return cachedPath;
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph g) {
            this.treeCache.clear();
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> bestPath = this.noPath;
            for (GraphSolver.InferenceGraph.Node n : g.nodes) {
                if (Collections.disjoint((Collection)n.data, this.varsToSolve)) continue;
                Pair<List<GraphSolver.InferenceGraph.Node>, Integer> path = this.computeTreeToLeafs(n);
                if ((Integer)path.snd >= (Integer)bestPath.snd) continue;
                bestPath = path;
            }
            if (bestPath == this.noPath) {
                throw new GraphStrategy.NodeNotFoundException(g);
            }
            return (GraphSolver.InferenceGraph.Node)((List)bestPath.fst).head;
        }
    }

    abstract class LeafSolver
    implements GraphStrategy {
        LeafSolver() {
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph g) {
            if (g.nodes.isEmpty()) {
                throw new GraphStrategy.NodeNotFoundException(g);
            }
            return g.nodes.get(0);
        }
    }

    static interface GraphStrategy {
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph var1) throws NodeNotFoundException;

        public boolean done();

        public static class NodeNotFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 0L;
            GraphSolver.InferenceGraph graph;

            public NodeNotFoundException(GraphSolver.InferenceGraph graph) {
                this.graph = graph;
            }
        }
    }

    protected static class BoundFilter
    implements Filter<Type> {
        InferenceContext inferenceContext;

        public BoundFilter(InferenceContext inferenceContext) {
            this.inferenceContext = inferenceContext;
        }

        @Override
        public boolean accepts(Type t) {
            return !t.isErroneous() && !this.inferenceContext.free(t) && !t.hasTag(TypeTag.BOT);
        }
    }

    class IncorporationBinaryOp {
        IncorporationBinaryOpKind opKind;
        Type op1;
        Type op2;

        IncorporationBinaryOp(IncorporationBinaryOpKind opKind, Type op1, Type op2) {
            this.opKind = opKind;
            this.op1 = op1;
            this.op2 = op2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IncorporationBinaryOp)) {
                return false;
            }
            IncorporationBinaryOp that = (IncorporationBinaryOp)o;
            return this.opKind == that.opKind && Infer.this.types.isSameType(this.op1, that.op1, true) && Infer.this.types.isSameType(this.op2, that.op2, true);
        }

        public int hashCode() {
            int result = this.opKind.hashCode();
            result *= 127;
            result += Infer.this.types.hashCode(this.op1);
            result *= 127;
            return result += Infer.this.types.hashCode(this.op2);
        }

        boolean apply(Warner warn) {
            return this.opKind.apply(this.op1, this.op2, warn, Infer.this.types);
        }
    }

    static enum IncorporationBinaryOpKind {
        IS_SUBTYPE{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                return types.isSubtypeUnchecked(op1, op2, warn);
            }
        }
        ,
        IS_SAME_TYPE{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                return types.isSameType(op1, op2);
            }
        };


        abstract boolean apply(Type var1, Type var2, Warner var3, Types var4);
    }

    abstract class AbstractIncorporationEngine
    implements Type.UndetVar.UndetVarListener {
        AbstractIncorporationEngine() {
        }

        @Override
        public void varInstantiated(Type.UndetVar uv) {
            uv.incorporationActions.addFirst(new SubstBounds(uv));
        }

        @Override
        public void varBoundChanged(Type.UndetVar uv, Type.UndetVar.InferenceBound ib, Type bound, boolean update) {
            if (uv.isCaptured()) {
                return;
            }
            uv.incorporationActions.addAll(this.getIncorporationActions(uv, ib, bound, update));
        }

        abstract List<IncorporationAction> getIncorporationActions(Type.UndetVar var1, Type.UndetVar.InferenceBound var2, Type var3, boolean var4);
    }

    class PropagateBounds
    extends IncorporationAction {
        Type.UndetVar.InferenceBound ib;

        public PropagateBounds(Type.UndetVar uv, Type t, Type.UndetVar.InferenceBound ib) {
            super(uv, t);
            this.ib = ib;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new PropagateBounds(that, this.t, this.ib);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warner) {
            Type undetT = inferenceContext.asUndetVar(this.t);
            if (undetT.hasTag(TypeTag.UNDETVAR) && !((Type.UndetVar)undetT).isCaptured()) {
                Type.UndetVar uv2 = (Type.UndetVar)undetT;
                uv2.addBound(this.ib.complement(), this.uv, Infer.this.types);
                for (Type.UndetVar.InferenceBound ib2 : this.backwards()) {
                    for (Type b : uv2.getBounds(ib2)) {
                        this.uv.addBound(ib2, b, Infer.this.types);
                    }
                }
            }
            for (Type.UndetVar.InferenceBound ib2 : this.forward()) {
                for (Type l : this.uv.getBounds(ib2)) {
                    Type undet = inferenceContext.asUndetVar(l);
                    if (!undet.hasTag(TypeTag.UNDETVAR) || ((Type.UndetVar)undet).isCaptured()) continue;
                    Type.UndetVar uv2 = (Type.UndetVar)undet;
                    uv2.addBound(this.ib, inferenceContext.asInstType(this.t), Infer.this.types);
                }
            }
        }

        EnumSet<Type.UndetVar.InferenceBound> forward() {
            return this.ib == Type.UndetVar.InferenceBound.EQ ? EnumSet.of(Type.UndetVar.InferenceBound.EQ) : EnumSet.complementOf(EnumSet.of(this.ib));
        }

        EnumSet<Type.UndetVar.InferenceBound> backwards() {
            return this.ib == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.of(this.ib);
        }

        @Override
        public String toString() {
            return String.format("%s[undet=%s,t=%s,bound=%s]", new Object[]{this.getClass().getSimpleName(), this.uv.qtype, this.t, this.ib});
        }
    }

    class CheckUpperBounds
    extends IncorporationAction {
        public CheckUpperBounds(Type.UndetVar uv, Type t) {
            super(uv, t);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new CheckUpperBounds(that, this.t);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warn) {
            List<Type> boundList = this.uv.getBounds(Type.UndetVar.InferenceBound.UPPER).stream().collect(Infer.this.types.closureCollector(true, Infer.this.types::isSameType));
            for (Type b2 : boundList) {
                if (this.t == b2 || this.t == b2 || this.t.hasTag(TypeTag.WILDCARD) || b2.hasTag(TypeTag.WILDCARD)) continue;
                for (Pair commonSupers : Infer.this.getParameterizedSupers(this.t, b2)) {
                    List<Type> allParamsSuperBound1 = ((Type)commonSupers.fst).allparams();
                    List<Type> allParamsSuperBound2 = ((Type)commonSupers.snd).allparams();
                    while (allParamsSuperBound1.nonEmpty() && allParamsSuperBound2.nonEmpty()) {
                        if (!(((Type)allParamsSuperBound1.head).hasTag(TypeTag.WILDCARD) || ((Type)allParamsSuperBound2.head).hasTag(TypeTag.WILDCARD) || this.isSameType(inferenceContext.asUndetVar((Type)allParamsSuperBound1.head), inferenceContext.asUndetVar((Type)allParamsSuperBound2.head)))) {
                            Infer.this.reportBoundError(this.uv, Type.UndetVar.InferenceBound.UPPER);
                        }
                        allParamsSuperBound1 = allParamsSuperBound1.tail;
                        allParamsSuperBound2 = allParamsSuperBound2.tail;
                    }
                    Assert.check(allParamsSuperBound1.isEmpty() && allParamsSuperBound2.isEmpty());
                }
            }
        }
    }

    class SubstBounds
    extends CheckInst {
        SubstBounds(Type.UndetVar uv) {
            super(uv, Type.UndetVar.InferenceBound.LOWER, Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.UPPER);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new SubstBounds(that);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warn) {
            for (Type undet : inferenceContext.undetvars) {
                Type.UndetVar uv2 = (Type.UndetVar)undet;
                uv2.substBounds(List.of(this.uv.qtype), List.of(this.uv.getInst()), Infer.this.types);
                this.checkCompatibleUpperBounds(uv2, inferenceContext);
            }
            super.apply(inferenceContext, warn);
        }

        void checkCompatibleUpperBounds(Type.UndetVar uv, InferenceContext inferenceContext) {
            List<Type> hibounds = Type.filter(uv.getBounds(Type.UndetVar.InferenceBound.UPPER), new BoundFilter(inferenceContext));
            Type hb = hibounds.isEmpty() ? Infer.this.syms.objectType : (hibounds.tail.isEmpty() ? (Type)hibounds.head : Infer.this.types.glb(hibounds));
            if (hb == null || hb.isErroneous()) {
                Infer.this.reportBoundError(uv, Type.UndetVar.InferenceBound.UPPER);
            }
        }
    }

    class CheckInst
    extends CheckBounds {
        EnumSet<Type.UndetVar.InferenceBound> to;

        CheckInst(Type.UndetVar uv, Type.UndetVar.InferenceBound ib, Type.UndetVar.InferenceBound ... rest) {
            this(uv, EnumSet.of(ib, rest));
        }

        CheckInst(Type.UndetVar uv, EnumSet<Type.UndetVar.InferenceBound> to) {
            super(uv, uv.getInst(), Type.UndetVar.InferenceBound.EQ);
            this.to = to;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new CheckInst(that, this.to);
        }

        @Override
        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.to;
        }

        @Override
        void report(Type.UndetVar.InferenceBound from, Type.UndetVar.InferenceBound to) {
            Infer.this.reportInstError(this.uv, to);
        }
    }

    class EqCheckLegacy
    extends CheckBounds {
        EqCheckLegacy(Type.UndetVar uv, Type t, Type.UndetVar.InferenceBound from) {
            super(uv, t, InferenceContext::asInstType, InferenceContext::free, from);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new EqCheckLegacy(that, this.t, this.from);
        }

        @Override
        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.from == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.of(Type.UndetVar.InferenceBound.EQ);
        }
    }

    class CheckBounds
    extends IncorporationAction {
        Type.UndetVar.InferenceBound from;
        BiFunction<InferenceContext, Type, Type> typeFunc;
        BiPredicate<InferenceContext, Type> optFilter;

        CheckBounds(Type.UndetVar uv, Type t, Type.UndetVar.InferenceBound from) {
            this(uv, t, InferenceContext::asUndetVar, null, from);
        }

        CheckBounds(Type.UndetVar uv, Type t, BiFunction<InferenceContext, Type, Type> typeFunc, BiPredicate<InferenceContext, Type> typeFilter, Type.UndetVar.InferenceBound from) {
            super(uv, t);
            this.from = from;
            this.typeFunc = typeFunc;
            this.optFilter = typeFilter;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar that) {
            return new CheckBounds(that, this.t, this.typeFunc, this.optFilter, this.from);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warn) {
            this.t = this.typeFunc.apply(inferenceContext, this.t);
            if (this.optFilter != null && this.optFilter.test(inferenceContext, this.t)) {
                return;
            }
            for (Type.UndetVar.InferenceBound to : this.boundsToCheck()) {
                for (Type b : this.uv.getBounds(to)) {
                    boolean success;
                    b = this.typeFunc.apply(inferenceContext, b);
                    if (this.optFilter != null && this.optFilter.test(inferenceContext, b) || (success = this.checkBound(this.t, b, this.from, to, warn))) continue;
                    this.report(this.from, to);
                }
            }
        }

        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.from == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.complementOf(EnumSet.of(this.from));
        }

        boolean checkBound(Type s, Type t, Type.UndetVar.InferenceBound ib_s, Type.UndetVar.InferenceBound ib_t, Warner warn) {
            if (ib_s.lessThan(ib_t)) {
                return this.isSubtype(s, t, warn);
            }
            if (ib_t.lessThan(ib_s)) {
                return this.isSubtype(t, s, warn);
            }
            return this.isSameType(s, t);
        }

        void report(Type.UndetVar.InferenceBound from, Type.UndetVar.InferenceBound to) {
            if (from == to) {
                Infer.this.reportBoundError(this.uv, from);
            } else if (from == Type.UndetVar.InferenceBound.LOWER || to == Type.UndetVar.InferenceBound.EQ) {
                Infer.this.reportBoundError(this.uv, to, from);
            } else {
                Infer.this.reportBoundError(this.uv, from, to);
            }
        }

        @Override
        public String toString() {
            return String.format("%s[undet=%s,t=%s,bound=%s]", new Object[]{this.getClass().getSimpleName(), this.uv.qtype, this.t, this.from});
        }
    }

    public abstract class IncorporationAction {
        Type.UndetVar uv;
        Type t;

        IncorporationAction(Type.UndetVar uv, Type t) {
            this.uv = uv;
            this.t = t;
        }

        public abstract IncorporationAction dup(Type.UndetVar var1);

        abstract void apply(InferenceContext var1, Warner var2);

        boolean isSubtype(Type s, Type t, Warner warn) {
            return Infer.this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, s, t, warn);
        }

        boolean isSameType(Type s, Type t) {
            return Infer.this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, s, t, null);
        }

        public String toString() {
            return String.format("%s[undet=%s,t=%s]", this.getClass().getSimpleName(), this.uv.qtype, this.t);
        }
    }

    class ImplicitArgType
    extends DeferredAttr.DeferredTypeMap {
        public ImplicitArgType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            DeferredAttr deferredAttr = Infer.this.rs.deferredAttr;
            deferredAttr.getClass();
            super(DeferredAttr.AttrMode.SPECULATIVE, msym, phase);
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void aVoid) {
            return Infer.this.types.erasure(t);
        }

        @Override
        public Type visitType(Type t, Void _unused) {
            if (t.hasTag(TypeTag.DEFERRED)) {
                return this.visit(super.visitType(t, null));
            }
            if (t.hasTag(TypeTag.BOT)) {
                t = Infer.this.types.boxedClass((Type)Infer.this.syms.voidType).type;
            }
            return t;
        }
    }

    public class PartiallyInferredMethodType
    extends Type.MethodType {
        final InferenceContext inferenceContext;
        Env<AttrContext> env;
        final Warner warn;

        public PartiallyInferredMethodType(Type.MethodType mtype, InferenceContext inferenceContext, Env<AttrContext> env, Warner warn) {
            super((List<Type>)mtype.getParameterTypes(), mtype.getReturnType(), (List<Type>)mtype.getThrownTypes(), mtype.tsym);
            this.inferenceContext = inferenceContext;
            this.env = env;
            this.warn = warn;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type check(Attr.ResultInfo resultInfo) {
            Warner noWarnings = new Warner(null);
            Infer.this.inferenceException.clear();
            List<Type> saved_undet = null;
            try {
                saved_undet = this.inferenceContext.save();
                if (Infer.this.allowGraphInference && !this.warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                    boolean shouldPropagate = Infer.this.shouldPropagate(this.getReturnType(), resultInfo, this.inferenceContext);
                    InferenceContext minContext = shouldPropagate ? this.inferenceContext.min(Infer.this.roots(this.asMethodType(), null), false, this.warn) : this.inferenceContext;
                    Type.MethodType other = (Type.MethodType)minContext.update(this.asMethodType());
                    Type newRestype = Infer.this.generateReturnConstraints(this.env.tree, resultInfo, other, minContext);
                    if (shouldPropagate) {
                        minContext.dupTo(resultInfo.checkContext.inferenceContext(), resultInfo.checkContext.deferredAttrContext().insideOverloadPhase());
                        Type type = newRestype;
                        return type;
                    }
                }
                this.inferenceContext.solve(noWarnings);
                Type shouldPropagate = this.inferenceContext.asInstType(this).getReturnType();
                return shouldPropagate;
            }
            catch (InferenceException ex) {
                resultInfo.checkContext.report(null, ex.getDiagnostic());
                Assert.error();
                Type type = null;
                return type;
            }
            finally {
                if (saved_undet != null) {
                    this.inferenceContext.rollback(saved_undet);
                }
            }
        }
    }

    public static class InferenceException
    extends Resolve.InapplicableMethodException {
        private static final long serialVersionUID = 0L;
        List<JCDiagnostic> messages = List.nil();

        InferenceException(JCDiagnostic.Factory diags) {
            super(diags);
        }

        @Override
        Resolve.InapplicableMethodException setMessage() {
            return this;
        }

        @Override
        Resolve.InapplicableMethodException setMessage(JCDiagnostic diag) {
            this.messages = this.messages.append(diag);
            return this;
        }

        @Override
        public JCDiagnostic getDiagnostic() {
            return (JCDiagnostic)this.messages.head;
        }

        void clear() {
            this.messages = List.nil();
        }
    }
}

