/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jshell.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import jdk.internal.jline.NoInterruptUnixTerminal;
import jdk.internal.jline.Terminal;
import jdk.internal.jline.TerminalSupport;
import jdk.internal.jline.UnsupportedTerminal;
import jdk.internal.jline.WindowsTerminal;
import jdk.internal.jline.console.ConsoleReader;
import jdk.internal.jline.console.KeyMap;
import jdk.internal.jline.console.UserInterruptException;
import jdk.internal.jline.console.completer.Completer;
import jdk.internal.jshell.tool.EditingHistory;
import jdk.internal.jshell.tool.IOContext;
import jdk.internal.jshell.tool.JShellTool;
import jdk.internal.jshell.tool.StopDetectingInputStream;
import jdk.jshell.SourceCodeAnalysis;

class ConsoleIOContext
extends IOContext {
    final JShellTool repl;
    final StopDetectingInputStream input;
    final ConsoleReader in;
    final EditingHistory history;
    String prefix = "";
    private static final String DOCUMENTATION_SHORTCUT = "\u001b[Z";
    private static final String CTRL_UP = "\u001b[1;5A";
    private static final String CTRL_DOWN = "\u001b[1;5B";
    private static final String[] SHORTCUT_FIXES = new String[]{"\u001b\r", "\u001b[17~", "\u001bO3P"};
    private static final FixComputer[] FIX_COMPUTERS = new FixComputer[]{new FixComputer('v', false){

        @Override
        public FixResult compute(JShellTool repl, String code, int cursor) {
            final String type = repl.analysis.analyzeType(code, cursor);
            if (type == null) {
                return new FixResult(Collections.emptyList(), null);
            }
            return new FixResult(Collections.singletonList(new Fix(){

                @Override
                public String displayName() {
                    return "Create variable";
                }

                @Override
                public void perform(ConsoleReader in) throws IOException {
                    in.redrawLine();
                    in.setCursorPosition(0);
                    in.putString(type + "  = ");
                    in.setCursorPosition(in.getCursorBuffer().cursor - 3);
                    in.flush();
                }
            }), null);
        }
    }, new FixComputer('i', true){

        @Override
        public FixResult compute(final JShellTool repl, String code, int cursor) {
            SourceCodeAnalysis.QualifiedNames res = repl.analysis.listQualifiedNames(code, cursor);
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            for (final String fqn : res.getNames()) {
                fixes.add(new Fix(){

                    @Override
                    public String displayName() {
                        return "import: " + fqn;
                    }

                    @Override
                    public void perform(ConsoleReader in) throws IOException {
                        repl.state.eval("import " + fqn + ";");
                        in.println("Imported: " + fqn);
                        in.redrawLine();
                    }
                });
            }
            if (res.isResolvable()) {
                return new FixResult(Collections.emptyList(), "\nThe identifier is resolvable in this context.");
            }
            String error = "";
            if (fixes.isEmpty()) {
                error = "\nNo candidate fully qualified names found to import.";
            }
            if (!res.isUpToDate()) {
                error = error + "\nResults may be incomplete; try again later for complete results.";
            }
            return new FixResult(fixes, error);
        }
    }};

    ConsoleIOContext(final JShellTool repl, InputStream cmdin, PrintStream cmdout) throws Exception {
        this.repl = repl;
        this.input = new StopDetectingInputStream(() -> repl.state.stop(), ex -> repl.hard("Error on input: %s", ex));
        TerminalSupport term = System.getProperty("test.jdk") != null ? new UnsupportedTerminal() : (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows") ? new JShellWindowsTerminal(this.input) : new JShellUnixTerminal(this.input));
        term.init();
        this.in = new ConsoleReader(cmdin, cmdout, term);
        this.in.setExpandEvents(false);
        this.in.setHandleUserInterrupt(true);
        this.history = new EditingHistory(JShellTool.PREFS){

            @Override
            protected SourceCodeAnalysis.CompletionInfo analyzeCompletion(String input) {
                return repl.analysis.analyzeCompletion(input);
            }
        };
        this.in.setHistory(this.history);
        this.in.setBellEnabled(true);
        this.in.addCompleter(new Completer(){
            private String lastTest;
            private int lastCursor;
            private boolean allowSmart = false;

            @Override
            public int complete(String test, int cursor, List<CharSequence> result) {
                List<SourceCodeAnalysis.Suggestion> suggestions;
                int[] anchor = new int[]{-1};
                if (ConsoleIOContext.this.prefix.isEmpty() && test.trim().startsWith("/")) {
                    suggestions = repl.commandCompletionSuggestions(test, cursor, anchor);
                } else {
                    int prefixLength = ConsoleIOContext.this.prefix.length();
                    suggestions = repl.analysis.completionSuggestions(ConsoleIOContext.this.prefix + test, cursor + prefixLength, anchor);
                    anchor[0] = anchor[0] - prefixLength;
                }
                if (!Objects.equals(this.lastTest, test) || this.lastCursor != cursor) {
                    this.allowSmart = true;
                }
                boolean smart = this.allowSmart && suggestions.stream().anyMatch(s -> s.isSmart);
                this.lastTest = test;
                this.lastCursor = cursor;
                this.allowSmart = !this.allowSmart;
                suggestions.stream().filter(s -> !smart || s.isSmart).map(s -> s.continuation).forEach(result::add);
                boolean onlySmart = suggestions.stream().allMatch(s -> s.isSmart);
                if (smart && !onlySmart) {
                    Optional<String> prefix = suggestions.stream().map(s -> s.continuation).reduce((x$0, x$1) -> ConsoleIOContext.commonPrefix(x$0, x$1));
                    String prefixStr = prefix.orElse("").substring(cursor - anchor[0]);
                    try {
                        ConsoleIOContext.this.in.putString(prefixStr);
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                    result.add("<press tab to see more>");
                    return cursor += prefixStr.length();
                }
                if (result.isEmpty()) {
                    try {
                        ConsoleIOContext.this.in.beep();
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                return anchor[0];
            }
        });
        this.bind(DOCUMENTATION_SHORTCUT, evt -> this.documentation(repl));
        this.bind(CTRL_UP, evt -> this.moveHistoryToSnippet(((EditingHistory)this.in.getHistory())::previousSnippet));
        this.bind(CTRL_DOWN, evt -> this.moveHistoryToSnippet(((EditingHistory)this.in.getHistory())::nextSnippet));
        for (FixComputer computer : FIX_COMPUTERS) {
            for (String shortcuts : SHORTCUT_FIXES) {
                this.bind(shortcuts + computer.shortcut, evt -> this.fixes(computer));
            }
        }
    }

    @Override
    public String readLine(String prompt, String prefix) throws IOException, IOContext.InputInterruptedException {
        this.prefix = prefix;
        try {
            return this.in.readLine(prompt);
        }
        catch (UserInterruptException ex) {
            throw (IOContext.InputInterruptedException)new IOContext.InputInterruptedException(this).initCause(ex);
        }
    }

    @Override
    public boolean interactiveOutput() {
        return true;
    }

    @Override
    public Iterable<String> currentSessionHistory() {
        return this.history.currentSessionEntries();
    }

    @Override
    public void close() throws IOException {
        this.history.save();
        this.in.shutdown();
        try {
            this.in.getTerminal().restore();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void moveHistoryToSnippet(Supplier<Boolean> action) {
        if (!action.get().booleanValue()) {
            try {
                this.in.beep();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            Method setBuffer = this.in.getClass().getDeclaredMethod("setBuffer", String.class);
            setBuffer.setAccessible(true);
            setBuffer.invoke((Object)this.in, this.in.getHistory().current().toString());
            this.in.flush();
        }
        catch (IOException | ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void bind(String shortcut, Object action) {
        KeyMap km = this.in.getKeys();
        for (int i = 0; i < shortcut.length(); ++i) {
            Object value = km.getBound(Character.toString(shortcut.charAt(i)));
            if (value instanceof KeyMap) {
                km = (KeyMap)value;
                continue;
            }
            km.bind(shortcut.substring(i), action);
        }
    }

    private void documentation(JShellTool repl) {
        String buffer = this.in.getCursorBuffer().buffer.toString();
        int cursor = this.in.getCursorBuffer().cursor;
        String doc = this.prefix.isEmpty() && buffer.trim().startsWith("/") ? repl.commandDocumentation(buffer, cursor) : repl.analysis.documentation(this.prefix + buffer, cursor + this.prefix.length());
        try {
            if (doc != null) {
                this.in.println();
                this.in.println(doc);
                this.in.redrawLine();
                this.in.flush();
            } else {
                this.in.beep();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String commonPrefix(String str1, String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            if (str1.startsWith(str2.substring(0, i + 1))) continue;
            return str2.substring(0, i);
        }
        return str2;
    }

    @Override
    public boolean terminalEditorRunning() {
        Terminal terminal = this.in.getTerminal();
        if (terminal instanceof JShellUnixTerminal) {
            return ((JShellUnixTerminal)terminal).isRaw();
        }
        return false;
    }

    @Override
    public void suspend() {
        try {
            this.in.getTerminal().restore();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void resume() {
        try {
            this.in.getTerminal().init();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void beforeUserCode() {
        this.input.setState(StopDetectingInputStream.State.BUFFER);
    }

    @Override
    public void afterUserCode() {
        this.input.setState(StopDetectingInputStream.State.WAIT);
    }

    @Override
    public void replaceLastHistoryEntry(String source) {
        this.history.fullHistoryReplace(source);
    }

    private void fixes(FixComputer computer) {
        String input = this.prefix + this.in.getCursorBuffer().toString();
        int cursor = this.prefix.length() + this.in.getCursorBuffer().cursor;
        FixResult candidates = computer.compute(this.repl, input, cursor);
        try {
            boolean printError;
            boolean bl = printError = candidates.error != null && !candidates.error.isEmpty();
            if (printError) {
                this.in.println(candidates.error);
            }
            if (candidates.fixes.isEmpty()) {
                this.in.beep();
                if (printError) {
                    this.in.redrawLine();
                    this.in.flush();
                }
            } else if (candidates.fixes.size() == 1 && !computer.showMenu) {
                if (printError) {
                    this.in.redrawLine();
                    this.in.flush();
                }
                candidates.fixes.get(0).perform(this.in);
            } else {
                Fix fix;
                ArrayList<Fix> fixes = new ArrayList<Fix>(candidates.fixes);
                fixes.add(0, new Fix(){

                    @Override
                    public String displayName() {
                        return "Do nothing";
                    }

                    @Override
                    public void perform(ConsoleReader in) throws IOException {
                        in.redrawLine();
                    }
                });
                HashMap<Character, Fix> char2Fix = new HashMap<Character, Fix>();
                this.in.println();
                for (int i = 0; i < fixes.size(); ++i) {
                    fix = (Fix)fixes.get(i);
                    char2Fix.put(Character.valueOf((char)(48 + i)), fix);
                    this.in.println("" + i + ": " + ((Fix)fixes.get(i)).displayName());
                }
                this.in.print("Choice: ");
                this.in.flush();
                int read = this.in.readCharacter();
                fix = (Fix)char2Fix.get(Character.valueOf((char)read));
                if (fix == null) {
                    this.in.beep();
                    fix = (Fix)fixes.get(0);
                }
                this.in.println();
                fix.perform(this.in);
                this.in.flush();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static final class JShellWindowsTerminal
    extends WindowsTerminal {
        private final StopDetectingInputStream input;

        public JShellWindowsTerminal(StopDetectingInputStream input) throws Exception {
            this.input = input;
        }

        @Override
        public void init() throws Exception {
            super.init();
            this.setAnsiSupported(false);
        }

        @Override
        public InputStream wrapInIfNeeded(InputStream in) throws IOException {
            return this.input.setInputStream(super.wrapInIfNeeded(in));
        }
    }

    private static final class JShellUnixTerminal
    extends NoInterruptUnixTerminal {
        private final StopDetectingInputStream input;

        public JShellUnixTerminal(StopDetectingInputStream input) throws Exception {
            this.input = input;
        }

        public boolean isRaw() {
            try {
                return this.getSettings().get("-a").contains("-icanon");
            }
            catch (IOException | InterruptedException ex) {
                return false;
            }
        }

        @Override
        public InputStream wrapInIfNeeded(InputStream in) throws IOException {
            return this.input.setInputStream(super.wrapInIfNeeded(in));
        }

        @Override
        public void disableInterruptCharacter() {
        }

        @Override
        public void enableInterruptCharacter() {
        }
    }

    public static class FixResult {
        public final List<Fix> fixes;
        public final String error;

        public FixResult(List<Fix> fixes, String error) {
            this.fixes = fixes;
            this.error = error;
        }
    }

    public static abstract class FixComputer {
        private final char shortcut;
        private final boolean showMenu;

        public FixComputer(char shortcut, boolean showMenu) {
            this.shortcut = shortcut;
            this.showMenu = showMenu;
        }

        public abstract FixResult compute(JShellTool var1, String var2, int var3);
    }

    public static interface Fix {
        public String displayName();

        public void perform(ConsoleReader var1) throws IOException;
    }
}

