/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.ConstructorWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.EnumConstantWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.FieldWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.MethodWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.NestedClassWriterImpl;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DeprecatedAPIListBuilder;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    private EnumMap<DeprecatedAPIListBuilder.DeprElementKind, AbstractMemberWriter> writerMap;
    private ConfigurationImpl configuration;

    private String getAnchorName(DeprecatedAPIListBuilder.DeprElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return "package";
            }
            case INTERFACE: {
                return "interface";
            }
            case CLASS: {
                return "class";
            }
            case ENUM: {
                return "enum";
            }
            case EXCEPTION: {
                return "exception";
            }
            case ERROR: {
                return "error";
            }
            case ANNOTATION_TYPE: {
                return "annotation.type";
            }
            case FIELD: {
                return "field";
            }
            case METHOD: {
                return "method";
            }
            case CONSTRUCTOR: {
                return "constructor";
            }
            case ENUM_CONSTANT: {
                return "enum.constant";
            }
            case ANNOTATION_TYPE_MEMBER: {
                return "annotation.type.member";
            }
        }
        throw new AssertionError((Object)("unknown kind: " + (Object)((Object)kind)));
    }

    private String getHeadingKey(DeprecatedAPIListBuilder.DeprElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return "doclet.Deprecated_Packages";
            }
            case INTERFACE: {
                return "doclet.Deprecated_Interfaces";
            }
            case CLASS: {
                return "doclet.Deprecated_Classes";
            }
            case ENUM: {
                return "doclet.Deprecated_Enums";
            }
            case EXCEPTION: {
                return "doclet.Deprecated_Exceptions";
            }
            case ERROR: {
                return "doclet.Deprecated_Errors";
            }
            case ANNOTATION_TYPE: {
                return "doclet.Deprecated_Annotation_Types";
            }
            case FIELD: {
                return "doclet.Deprecated_Fields";
            }
            case METHOD: {
                return "doclet.Deprecated_Methods";
            }
            case CONSTRUCTOR: {
                return "doclet.Deprecated_Constructors";
            }
            case ENUM_CONSTANT: {
                return "doclet.Deprecated_Enum_Constants";
            }
            case ANNOTATION_TYPE_MEMBER: {
                return "doclet.Deprecated_Annotation_Type_Members";
            }
        }
        throw new AssertionError((Object)("unknown kind: " + (Object)((Object)kind)));
    }

    private String getSummaryKey(DeprecatedAPIListBuilder.DeprElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return "doclet.deprecated_packages";
            }
            case INTERFACE: {
                return "doclet.deprecated_interfaces";
            }
            case CLASS: {
                return "doclet.deprecated_classes";
            }
            case ENUM: {
                return "doclet.deprecated_enums";
            }
            case EXCEPTION: {
                return "doclet.deprecated_exceptions";
            }
            case ERROR: {
                return "doclet.deprecated_errors";
            }
            case ANNOTATION_TYPE: {
                return "doclet.deprecated_annotation_types";
            }
            case FIELD: {
                return "doclet.deprecated_fields";
            }
            case METHOD: {
                return "doclet.deprecated_methods";
            }
            case CONSTRUCTOR: {
                return "doclet.deprecated_constructors";
            }
            case ENUM_CONSTANT: {
                return "doclet.deprecated_enum_constants";
            }
            case ANNOTATION_TYPE_MEMBER: {
                return "doclet.deprecated_annotation_type_members";
            }
        }
        throw new AssertionError((Object)("unknown kind: " + (Object)((Object)kind)));
    }

    private String getHeaderKey(DeprecatedAPIListBuilder.DeprElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return "doclet.Package";
            }
            case INTERFACE: {
                return "doclet.Interface";
            }
            case CLASS: {
                return "doclet.Class";
            }
            case ENUM: {
                return "doclet.Enum";
            }
            case EXCEPTION: {
                return "doclet.Exceptions";
            }
            case ERROR: {
                return "doclet.Errors";
            }
            case ANNOTATION_TYPE: {
                return "doclet.AnnotationType";
            }
            case FIELD: {
                return "doclet.Field";
            }
            case METHOD: {
                return "doclet.Method";
            }
            case CONSTRUCTOR: {
                return "doclet.Constructor";
            }
            case ENUM_CONSTANT: {
                return "doclet.Enum_Constant";
            }
            case ANNOTATION_TYPE_MEMBER: {
                return "doclet.Annotation_Type_Member";
            }
        }
        throw new AssertionError((Object)("unknown kind: " + (Object)((Object)kind)));
    }

    public DeprecatedListWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.configuration = configuration;
        NestedClassWriterImpl classW = new NestedClassWriterImpl(this);
        this.writerMap = new EnumMap(DeprecatedAPIListBuilder.DeprElementKind.class);
        block8: for (DeprecatedAPIListBuilder.DeprElementKind kind : DeprecatedAPIListBuilder.DeprElementKind.values()) {
            switch (kind) {
                case PACKAGE: 
                case INTERFACE: 
                case CLASS: 
                case ENUM: 
                case EXCEPTION: 
                case ERROR: 
                case ANNOTATION_TYPE: {
                    this.writerMap.put(kind, classW);
                    continue block8;
                }
                case FIELD: {
                    this.writerMap.put(kind, new FieldWriterImpl(this));
                    continue block8;
                }
                case METHOD: {
                    this.writerMap.put(kind, new MethodWriterImpl(this));
                    continue block8;
                }
                case CONSTRUCTOR: {
                    this.writerMap.put(kind, new ConstructorWriterImpl(this));
                    continue block8;
                }
                case ENUM_CONSTANT: {
                    this.writerMap.put(kind, new EnumConstantWriterImpl(this));
                    continue block8;
                }
                case ANNOTATION_TYPE_MEMBER: {
                    this.writerMap.put(kind, new AnnotationTypeOptionalMemberWriterImpl(this, null));
                    continue block8;
                }
                default: {
                    throw new AssertionError((Object)("unknown kind: " + (Object)((Object)kind)));
                }
            }
        }
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.DEPRECATED_LIST;
        try {
            DeprecatedListWriter depr = new DeprecatedListWriter(configuration, filename);
            depr.generateDeprecatedListFile(new DeprecatedAPIListBuilder(configuration));
            depr.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprapi) throws IOException {
        HtmlTree body = this.getHeader();
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN() : body;
        htmlTree.addContent(this.getContentsList(deprapi));
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        for (DeprecatedAPIListBuilder.DeprElementKind kind : DeprecatedAPIListBuilder.DeprElementKind.values()) {
            if (!deprapi.hasDocumentation(kind)) continue;
            this.addAnchor(deprapi, kind, div);
            String memberTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText(this.getHeadingKey(kind)), this.configuration.getText(this.getSummaryKey(kind)));
            ArrayList<String> memberTableHeader = new ArrayList<String>();
            memberTableHeader.add(this.configuration.getText("doclet.0_and_1", this.configuration.getText(this.getHeaderKey(kind)), this.configuration.getText("doclet.Description")));
            if (kind == DeprecatedAPIListBuilder.DeprElementKind.PACKAGE) {
                this.addPackageDeprecatedAPI(deprapi.getSet(kind), this.getHeadingKey(kind), memberTableSummary, memberTableHeader, div);
                continue;
            }
            this.writerMap.get((Object)kind).addDeprecatedAPI(deprapi.getSet(kind), this.getHeadingKey(kind), memberTableSummary, memberTableHeader, div);
        }
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            htmlTree.addContent(div);
            body.addContent(htmlTree);
        } else {
            body.addContent(div);
        }
        htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.printHtmlDocument(null, true, body);
    }

    private void addIndexLink(DeprecatedAPIListBuilder builder, DeprecatedAPIListBuilder.DeprElementKind kind, Content contentTree) {
        if (builder.hasDocumentation(kind)) {
            HtmlTree li = HtmlTree.LI(this.getHyperLink(this.getAnchorName(kind), this.getResource(this.getHeadingKey(kind))));
            contentTree.addContent(li);
        }
    }

    public Content getContentsList(DeprecatedAPIListBuilder deprapi) {
        Content headContent = this.getResource("doclet.Deprecated_API");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        Content headingContent = this.getResource("doclet.Contents");
        ((Content)div).addContent(HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, headingContent));
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        for (DeprecatedAPIListBuilder.DeprElementKind kind : DeprecatedAPIListBuilder.DeprElementKind.values()) {
            this.addIndexLink(deprapi, kind, ul);
        }
        ((Content)div).addContent(ul);
        return div;
    }

    private void addAnchor(DeprecatedAPIListBuilder builder, DeprecatedAPIListBuilder.DeprElementKind kind, Content htmlTree) {
        if (builder.hasDocumentation(kind)) {
            htmlTree.addContent(this.getMarkerAnchor(this.getAnchorName(kind)));
        }
    }

    public HtmlTree getHeader() {
        String title = this.configuration.getText("doclet.Window_Deprecated_List");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        return bodyTree;
    }

    @Override
    protected Content getNavLinkDeprecated() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.deprecatedLabel);
        return li;
    }
}

