/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import javax.lang.model.element.PackageElement;
import jdk.javadoc.internal.doclets.formats.html.AbstractTreeWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageElement packageElement;
    protected PackageElement prev;
    protected PackageElement next;

    public PackageTreeWriter(ConfigurationImpl configuration, DocPath path, PackageElement packageElement, PackageElement prev, PackageElement next) throws IOException {
        super(configuration, path, new ClassTree(configuration.typeElementCatalog.allClasses(packageElement), (Configuration)configuration));
        this.packageElement = packageElement;
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, PackageElement pkg, PackageElement prev, PackageElement next, boolean noDeprecated) {
        DocPath path = DocPath.forPackage(pkg).resolve(DocPaths.PACKAGE_TREE);
        try {
            PackageTreeWriter packgen = new PackageTreeWriter(configuration, path, pkg, prev, next);
            packgen.generatePackageTreeFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), path.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        HtmlTree body = this.getPackageTreeHeader();
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN() : body;
        Content headContent = this.getResource("doclet.Hierarchy_For_Package", this.utils.getPackageName(this.packageElement));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.packages.size() > 1) {
            this.addLinkToMainTree(div);
        }
        htmlTree.addContent(div);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseClasses(), "doclet.Class_Hierarchy", divTree);
        this.addTree(this.classtree.baseInterfaces(), "doclet.Interface_Hierarchy", divTree);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", divTree);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", divTree, true);
        htmlTree.addContent(divTree);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            body.addContent(htmlTree);
        }
        HtmlTree tree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, tree);
        this.addBottom(tree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(tree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected HtmlTree getPackageTreeHeader() {
        String packageName = this.packageElement.isUnnamed() ? "" : this.utils.getPackageName(this.packageElement);
        String title = packageName + " " + this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        return bodyTree;
    }

    protected void addLinkToMainTree(Content div) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.packageHierarchyLabel, this.getResource("doclet.Package_Hierarchies"));
        div.addContent(span);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.horizontal);
        ul.addContent(this.getNavLinkMainTree(this.configuration.getText("doclet.All_Packages")));
        div.addContent(ul);
    }

    @Override
    protected Content getNavLinkPrevious() {
        if (this.prev == null) {
            return this.getNavLinkPrevious(null);
        }
        DocPath path = DocPath.relativePath(this.packageElement, this.prev);
        return this.getNavLinkPrevious(path.resolve(DocPaths.PACKAGE_TREE));
    }

    @Override
    protected Content getNavLinkNext() {
        if (this.next == null) {
            return this.getNavLinkNext(null);
        }
        DocPath path = DocPath.relativePath(this.packageElement, this.next);
        return this.getNavLinkNext(path.resolve(DocPaths.PACKAGE_TREE));
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

