/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import jdk.javadoc.internal.doclets.formats.html.AbstractTreeWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class TreeWriter
extends AbstractTreeWriter {
    SortedSet<PackageElement> packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationImpl configuration, DocPath filename, ClassTree classtree) throws IOException {
        super(configuration, filename, classtree);
        this.packages = configuration.packages;
        this.classesonly = this.packages.isEmpty();
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        DocPath filename = DocPaths.OVERVIEW_TREE;
        try {
            TreeWriter treegen = new TreeWriter(configuration, filename, classtree);
            treegen.generateTreeFile();
            treegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    public void generateTreeFile() throws IOException {
        HtmlTree body = this.getTreeHeader();
        Content headContent = this.getResource("doclet.Hierarchy_For_All_Packages");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        this.addPackageTreeLinks(div);
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN() : body;
        htmlTree.addContent(div);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseClasses(), "doclet.Class_Hierarchy", divTree);
        this.addTree(this.classtree.baseInterfaces(), "doclet.Interface_Hierarchy", divTree);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", divTree);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", divTree, true);
        htmlTree.addContent(divTree);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            body.addContent(htmlTree);
        }
        htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected void addPackageTreeLinks(Content contentTree) {
        if (this.isUnnamedPackage()) {
            return;
        }
        if (!this.classesonly) {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.packageHierarchyLabel, this.getResource("doclet.Package_Hierarchies"));
            contentTree.addContent(span);
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.addStyle(HtmlStyle.horizontal);
            int i = 0;
            for (PackageElement pkg : this.packages) {
                if (pkg.isUnnamed() || this.configuration.nodeprecated && this.utils.isDeprecated(pkg)) {
                    ++i;
                    continue;
                }
                DocPath link = this.pathString(pkg, DocPaths.PACKAGE_TREE);
                HtmlTree li = HtmlTree.LI(this.getHyperLink(link, (Content)new StringContent(this.utils.getPackageName(pkg))));
                if (i < this.packages.size() - 1) {
                    ((Content)li).addContent(", ");
                }
                ul.addContent(li);
                ++i;
            }
            contentTree.addContent(ul);
        }
    }

    protected HtmlTree getTreeHeader() {
        String title = this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        return bodyTree;
    }

    private boolean isUnnamedPackage() {
        return this.packages.size() == 1 && this.packages.first().isUnnamed();
    }
}

