/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.toolkit.Configuration;

public class MetaKeywords {
    private final Configuration config;

    public MetaKeywords(Configuration configuration) {
        this.config = configuration;
    }

    public List<String> getMetaKeywords(TypeElement typeElement) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.config.keywords) {
            results.addAll(this.getClassKeyword(typeElement));
            results.addAll(this.getMemberKeywords(this.config.utils.getFields(typeElement)));
            results.addAll(this.getMemberKeywords(this.config.utils.getMethods(typeElement)));
        }
        results.trimToSize();
        return results;
    }

    protected List<String> getClassKeyword(TypeElement typeElement) {
        ArrayList<String> metakeywords = new ArrayList<String>(1);
        String cltypelower = this.config.utils.isInterface(typeElement) ? "interface" : "class";
        metakeywords.add(this.config.utils.getFullyQualifiedName(typeElement) + " " + cltypelower);
        return metakeywords;
    }

    public List<String> getMetaKeywords(PackageElement packageElement) {
        ArrayList<String> result = new ArrayList<String>(1);
        if (this.config.keywords) {
            String pkgName = this.config.utils.getPackageName(packageElement);
            result.add(pkgName + " package");
        }
        return result;
    }

    public List<String> getOverviewMetaKeywords(String title, String docTitle) {
        ArrayList<String> result = new ArrayList<String>(1);
        if (this.config.keywords) {
            String windowOverview = this.config.getText(title);
            if (docTitle.length() > 0) {
                result.add(windowOverview + ", " + docTitle);
            } else {
                result.add(windowOverview);
            }
        }
        return result;
    }

    protected List<String> getMemberKeywords(List<? extends Element> members) {
        ArrayList<String> results = new ArrayList<String>();
        for (Element element : members) {
            String membername = this.config.utils.isMethod(element) ? this.config.utils.getSimpleName(element) + "()" : this.config.utils.getSimpleName(element);
            if (results.contains(membername)) continue;
            results.add(membername);
        }
        results.trimToSize();
        return results;
    }
}

