/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.util;

import com.sun.tools.javac.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileFactory;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;

class StandardDocFileFactory
extends DocFileFactory {
    private final StandardJavaFileManager fileManager;
    private Path destDir;

    public StandardDocFileFactory(Configuration configuration) {
        super(configuration);
        this.fileManager = (StandardJavaFileManager)configuration.getFileManager();
    }

    private Path getDestDir() {
        if (this.destDir == null) {
            if (!this.configuration.destDirName.isEmpty() || !this.fileManager.hasLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT)) {
                try {
                    String dirName = this.configuration.destDirName.isEmpty() ? "." : this.configuration.destDirName;
                    Path dir = Paths.get(dirName, new String[0]);
                    this.fileManager.setLocationFromPaths(DocumentationTool.Location.DOCUMENTATION_OUTPUT, Arrays.asList(dir));
                }
                catch (IOException e) {
                    throw new DocletAbortException(e);
                }
            }
            this.destDir = this.fileManager.getLocationAsPaths(DocumentationTool.Location.DOCUMENTATION_OUTPUT).iterator().next();
        }
        return this.destDir;
    }

    @Override
    public DocFile createFileForDirectory(String file) {
        return new StandardDocFile(Paths.get(file, new String[0]));
    }

    @Override
    public DocFile createFileForInput(String file) {
        return new StandardDocFile(Paths.get(file, new String[0]));
    }

    @Override
    public DocFile createFileForOutput(DocPath path) {
        return new StandardDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, path);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath path) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> files = new LinkedHashSet<DocFile>();
        StandardLocation l = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        for (Path path2 : this.fileManager.getLocationAsPaths(l)) {
            Path path3;
            if (!Files.isDirectory(path2, new LinkOption[0]) || !Files.exists(path3 = path2.resolve(path.getPath()), new LinkOption[0])) continue;
            files.add(new StandardDocFile(path3));
        }
        return files;
    }

    private static Path newFile(Path dir, String path) {
        return dir == null ? Paths.get(path, new String[0]) : dir.resolve(path);
    }

    class StandardDocFile
    extends DocFile {
        private Path file;

        private StandardDocFile(Path file) {
            super(StandardDocFileFactory.this.configuration);
            this.file = file;
        }

        private StandardDocFile(JavaFileManager.Location location, DocPath path) {
            super(StandardDocFileFactory.this.configuration, location, path);
            Assert.check(location == DocumentationTool.Location.DOCUMENTATION_OUTPUT);
            this.file = StandardDocFileFactory.newFile(StandardDocFileFactory.this.getDestDir(), path.getPath());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            JavaFileObject fo = this.getJavaFileObjectForInput(this.file);
            return new BufferedInputStream(fo.openInputStream());
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream out = this.getFileObjectForOutput(this.path).openOutputStream();
            return new BufferedOutputStream(out);
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream out = this.getFileObjectForOutput(this.path).openOutputStream();
            if (StandardDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(out));
            }
            return new BufferedWriter(new OutputStreamWriter(out, StandardDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return Files.isReadable(this.file);
        }

        @Override
        public boolean canWrite() {
            return Files.isWritable(this.file);
        }

        @Override
        public boolean exists() {
            return Files.exists(this.file, new LinkOption[0]);
        }

        @Override
        public String getName() {
            return this.file.getFileName().toString();
        }

        @Override
        public String getPath() {
            return this.file.toString();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return Files.isDirectory(this.file, new LinkOption[0]);
        }

        @Override
        public boolean isFile() {
            return Files.isRegularFile(this.file, new LinkOption[0]);
        }

        @Override
        public boolean isSameFile(DocFile other) {
            if (!(other instanceof StandardDocFile)) {
                return false;
            }
            try {
                return Files.isSameFile(this.file, ((StandardDocFile)other).file);
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() throws IOException {
            ArrayList<DocFile> files = new ArrayList<DocFile>();
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.file);){
                for (Path f : ds) {
                    files.add(new StandardDocFile(f));
                }
            }
            return files;
        }

        @Override
        public boolean mkdirs() {
            try {
                Files.createDirectories(this.file, new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public DocFile resolve(DocPath p) {
            return this.resolve(p.getPath());
        }

        @Override
        public DocFile resolve(String p) {
            if (this.location == null && this.path == null) {
                return new StandardDocFile(this.file.resolve(p));
            }
            return new StandardDocFile(this.location, this.path.resolve(p));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location locn) {
            if (locn != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new StandardDocFile(StandardDocFileFactory.this.getDestDir().resolve(this.file));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StandardDocFile[");
            if (this.location != null) {
                sb.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                sb.append("path:").append(this.path.getPath()).append(",");
            }
            sb.append("file:").append(this.file);
            sb.append("]");
            return sb.toString();
        }

        private JavaFileObject getJavaFileObjectForInput(Path file) {
            return StandardDocFileFactory.this.fileManager.getJavaFileObjects(file).iterator().next();
        }

        private FileObject getFileObjectForOutput(DocPath path) throws IOException {
            String p = path.getPath();
            int lastSep = -1;
            for (int i = 0; i < p.length(); ++i) {
                char ch = p.charAt(i);
                if (ch == '/') {
                    lastSep = i;
                    continue;
                }
                if (i == lastSep + 1 && !Character.isJavaIdentifierStart(ch) || !Character.isJavaIdentifierPart(ch)) break;
            }
            String pkg = lastSep == -1 ? "" : p.substring(0, lastSep);
            String rest = p.substring(lastSep + 1);
            return StandardDocFileFactory.this.fileManager.getFileForOutput(this.location, pkg, rest, null);
        }
    }
}

