/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.cert.ocsp;

import com.itextpdf.bouncycastle.asn1.ASN1ObjectIdentifierBC;
import com.itextpdf.bouncycastle.asn1.x509.ExtensionBC;
import com.itextpdf.bouncycastle.cert.ocsp.ReqBC;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.IExtension;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReq;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IReq;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.Req;

public class OCSPReqBC
implements IOCSPReq {
    private final OCSPReq ocspReq;

    public OCSPReqBC(OCSPReq ocspReq) {
        this.ocspReq = ocspReq;
    }

    public OCSPReq getOcspReq() {
        return this.ocspReq;
    }

    public byte[] getEncoded() throws IOException {
        return this.ocspReq.getEncoded();
    }

    public IReq[] getRequestList() {
        Req[] reqs = this.ocspReq.getRequestList();
        IReq[] reqsBC = new IReq[reqs.length];
        for (int i = 0; i < reqs.length; ++i) {
            reqsBC[i] = new ReqBC(reqs[i]);
        }
        return reqsBC;
    }

    public IExtension getExtension(IASN1ObjectIdentifier objectIdentifier) {
        return new ExtensionBC(this.ocspReq.getExtension(((ASN1ObjectIdentifierBC)objectIdentifier).getASN1ObjectIdentifier()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSPReqBC ocspReqBC = (OCSPReqBC)o;
        return Objects.equals(this.ocspReq, ocspReqBC.ocspReq);
    }

    public int hashCode() {
        return Objects.hash(this.ocspReq);
    }

    public String toString() {
        return this.ocspReq.toString();
    }
}

