/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors.gradients;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.colors.gradients.GradientColorStop;
import com.itextpdf.kernel.colors.gradients.GradientSpreadMethod;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfShading;
import com.itextpdf.kernel.pdf.function.AbstractPdfFunction;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import com.itextpdf.kernel.pdf.function.PdfType2Function;
import com.itextpdf.kernel.pdf.function.PdfType3Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinearGradientBuilder {
    protected static final double ZERO_EPSILON = 1.0E-10;
    private final List<GradientColorStop> stops = new ArrayList<GradientColorStop>();
    private GradientSpreadMethod spreadMethod = GradientSpreadMethod.NONE;

    public AbstractLinearGradientBuilder addColorStop(GradientColorStop gradientColorStop) {
        if (gradientColorStop != null) {
            this.stops.add(gradientColorStop);
        }
        return this;
    }

    public AbstractLinearGradientBuilder setSpreadMethod(GradientSpreadMethod gradientSpreadMethod) {
        this.spreadMethod = this.spreadMethod != null ? gradientSpreadMethod : GradientSpreadMethod.NONE;
        return this;
    }

    public List<GradientColorStop> getColorStops() {
        return new ArrayList<GradientColorStop>(this.stops);
    }

    public GradientSpreadMethod getSpreadMethod() {
        return this.spreadMethod;
    }

    public Color buildColor(Rectangle targetBoundingBox, AffineTransform contextTransform, PdfDocument document) {
        PdfShading.Axial axial;
        AffineTransform gradientTransformation;
        Point[] baseCoordinatesVector = this.getGradientVector(targetBoundingBox, contextTransform);
        if (baseCoordinatesVector == null || this.stops.isEmpty()) {
            return null;
        }
        AffineTransform shadingTransform = new AffineTransform();
        if (contextTransform != null) {
            shadingTransform.concatenate(contextTransform);
        }
        if ((gradientTransformation = this.getCurrentSpaceToGradientVectorSpaceTransformation(targetBoundingBox, contextTransform)) != null) {
            try {
                if (targetBoundingBox != null) {
                    targetBoundingBox = Rectangle.calculateBBox(Arrays.asList(gradientTransformation.inverseTransform(new Point(targetBoundingBox.getLeft(), targetBoundingBox.getBottom()), null), gradientTransformation.inverseTransform(new Point(targetBoundingBox.getLeft(), targetBoundingBox.getTop()), null), gradientTransformation.inverseTransform(new Point(targetBoundingBox.getRight(), targetBoundingBox.getBottom()), null), gradientTransformation.inverseTransform(new Point(targetBoundingBox.getRight(), targetBoundingBox.getTop()), null)));
                }
                shadingTransform.concatenate(gradientTransformation);
            }
            catch (NoninvertibleTransformException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to invert gradient transformation, ignoring it");
            }
        }
        if ((axial = AbstractLinearGradientBuilder.createAxialShading(baseCoordinatesVector, this.stops, this.spreadMethod, targetBoundingBox)) == null) {
            return null;
        }
        PdfPattern.Shading shading = new PdfPattern.Shading(axial);
        if (!shadingTransform.isIdentity()) {
            double[] matrix = new double[6];
            shadingTransform.getMatrix(matrix);
            shading.setMatrix(new PdfArray(matrix));
        }
        return new PatternColor(shading);
    }

    protected abstract Point[] getGradientVector(Rectangle var1, AffineTransform var2);

    protected AffineTransform getCurrentSpaceToGradientVectorSpaceTransformation(Rectangle targetBoundingBox, AffineTransform contextTransform) {
        return null;
    }

    protected static double[] evaluateCoveringDomain(Point[] coords, Rectangle toCover) {
        double minX;
        if (toCover == null) {
            return new double[]{0.0, 1.0};
        }
        AffineTransform transform = new AffineTransform();
        double scale = 1.0 / coords[0].distance(coords[1]);
        double sin = -(coords[1].getY() - coords[0].getY()) * scale;
        double cos = (coords[1].getX() - coords[0].getX()) * scale;
        if (Math.abs(cos) < 1.0E-10) {
            cos = 0.0;
            sin = sin > 0.0 ? 1.0 : -1.0;
        } else if (Math.abs(sin) < 1.0E-10) {
            sin = 0.0;
            cos = cos > 0.0 ? 1.0 : -1.0;
        }
        transform.concatenate(new AffineTransform(cos, sin, -sin, cos, 0.0, 0.0));
        transform.scale(scale, scale);
        transform.translate(-coords[0].getX(), -coords[0].getY());
        Point[] rectanglePoints = toCover.toPointsArray();
        double maxX = minX = transform.transform(rectanglePoints[0], null).getX();
        for (int i = 1; i < rectanglePoints.length; ++i) {
            double currentX = transform.transform(rectanglePoints[i], null).getX();
            minX = Math.min(minX, currentX);
            maxX = Math.max(maxX, currentX);
        }
        return new double[]{minX, maxX};
    }

    protected static Point[] createCoordinatesForNewDomain(double[] newDomain, Point[] baseVector) {
        double xDiff = baseVector[1].getX() - baseVector[0].getX();
        double yDiff = baseVector[1].getY() - baseVector[0].getY();
        Point[] targetCoords = new Point[]{baseVector[0].getLocation(), baseVector[1].getLocation()};
        targetCoords[0].translate(xDiff * newDomain[0], yDiff * newDomain[0]);
        targetCoords[1].translate(xDiff * (newDomain[1] - 1.0), yDiff * (newDomain[1] - 1.0));
        return targetCoords;
    }

    private static PdfShading.Axial createAxialShading(Point[] baseCoordinatesVector, List<GradientColorStop> stops, GradientSpreadMethod spreadMethod, Rectangle targetBoundingBox) {
        Point[] actualCoordinates;
        double baseVectorLength = baseCoordinatesVector[1].distance(baseCoordinatesVector[0]);
        List<GradientColorStop> stopsToConstruct = AbstractLinearGradientBuilder.normalizeStops(stops, baseVectorLength);
        double[] coordinatesDomain = new double[]{0.0, 1.0};
        if (baseVectorLength < 1.0E-10 || stopsToConstruct.size() == 1) {
            if (spreadMethod == GradientSpreadMethod.NONE) {
                return null;
            }
            actualCoordinates = new Point[]{new Point(targetBoundingBox.getLeft(), targetBoundingBox.getBottom()), new Point(targetBoundingBox.getRight(), targetBoundingBox.getBottom())};
            GradientColorStop lastColorStop = stopsToConstruct.get(stopsToConstruct.size() - 1);
            stopsToConstruct = Arrays.asList(new GradientColorStop(lastColorStop, 0.0, GradientColorStop.OffsetType.RELATIVE), new GradientColorStop(lastColorStop, 1.0, GradientColorStop.OffsetType.RELATIVE));
        } else {
            coordinatesDomain = AbstractLinearGradientBuilder.evaluateCoveringDomain(baseCoordinatesVector, targetBoundingBox);
            if (spreadMethod == GradientSpreadMethod.REPEAT || spreadMethod == GradientSpreadMethod.REFLECT) {
                stopsToConstruct = AbstractLinearGradientBuilder.adjustNormalizedStopsToCoverDomain(stopsToConstruct, coordinatesDomain, spreadMethod);
            } else if (spreadMethod == GradientSpreadMethod.PAD) {
                AbstractLinearGradientBuilder.adjustStopsForPadIfNeeded(stopsToConstruct, coordinatesDomain);
            } else {
                double firstStopOffset = stopsToConstruct.get(0).getOffset();
                double lastStopOffset = stopsToConstruct.get(stopsToConstruct.size() - 1).getOffset();
                if (lastStopOffset - firstStopOffset < 1.0E-10 || coordinatesDomain[1] <= firstStopOffset || coordinatesDomain[0] >= lastStopOffset) {
                    return null;
                }
                coordinatesDomain[0] = Math.max(coordinatesDomain[0], firstStopOffset);
                coordinatesDomain[1] = Math.min(coordinatesDomain[1], lastStopOffset);
            }
            assert (coordinatesDomain[0] <= coordinatesDomain[1]);
            actualCoordinates = AbstractLinearGradientBuilder.createCoordinatesForNewDomain(coordinatesDomain, baseCoordinatesVector);
        }
        return new PdfShading.Axial(new PdfDeviceCs.Rgb(), AbstractLinearGradientBuilder.createCoordsPdfArray(actualCoordinates), new PdfArray(coordinatesDomain), AbstractLinearGradientBuilder.constructFunction(stopsToConstruct));
    }

    private static List<GradientColorStop> normalizeStops(List<GradientColorStop> toNormalize, double baseVectorLength) {
        if (baseVectorLength < 1.0E-10) {
            return Arrays.asList(new GradientColorStop(toNormalize.get(toNormalize.size() - 1), 0.0, GradientColorStop.OffsetType.RELATIVE));
        }
        List<GradientColorStop> result = AbstractLinearGradientBuilder.copyStopsAndNormalizeAbsoluteOffsets(toNormalize, baseVectorLength);
        AbstractLinearGradientBuilder.normalizeFirstStopOffset(result);
        AbstractLinearGradientBuilder.normalizeAutoStops(result);
        AbstractLinearGradientBuilder.normalizeHintsOffsets(result);
        return result;
    }

    private static void normalizeHintsOffsets(List<GradientColorStop> result) {
        for (int i = 0; i < result.size() - 1; ++i) {
            double nextStopOffset;
            GradientColorStop stopColor = result.get(i);
            if (stopColor.getHintOffsetType() != GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT) continue;
            double currentStopOffset = stopColor.getOffset();
            if (currentStopOffset != (nextStopOffset = result.get(i + 1).getOffset())) {
                double hintOffset = (stopColor.getHintOffset() - currentStopOffset) / (nextStopOffset - currentStopOffset);
                stopColor.setHint(hintOffset, GradientColorStop.HintOffsetType.RELATIVE_BETWEEN_COLORS);
                continue;
            }
            stopColor.setHint(0.0, GradientColorStop.HintOffsetType.NONE);
        }
        result.get(result.size() - 1).setHint(0.0, GradientColorStop.HintOffsetType.NONE);
    }

    private static void normalizeAutoStops(List<GradientColorStop> toNormalize) {
        assert (toNormalize.get(0).getOffsetType() == GradientColorStop.OffsetType.RELATIVE);
        int firstAutoStopIndex = 1;
        GradientColorStop firstStopColor = toNormalize.get(0);
        double prevOffset = firstStopColor.getHintOffsetType() == GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT ? firstStopColor.getHintOffset() : firstStopColor.getOffset();
        for (int i = 1; i < toNormalize.size(); ++i) {
            GradientColorStop currentStop = toNormalize.get(i);
            if (currentStop.getOffsetType() == GradientColorStop.OffsetType.AUTO) {
                if (currentStop.getHintOffsetType() != GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT) continue;
                double hintOffset = currentStop.getHintOffset();
                AbstractLinearGradientBuilder.normalizeAutoStops(toNormalize, firstAutoStopIndex, i + 1, prevOffset, hintOffset);
                prevOffset = hintOffset;
                firstAutoStopIndex = i + 1;
                continue;
            }
            if (firstAutoStopIndex < i) {
                double offset = currentStop.getOffset();
                AbstractLinearGradientBuilder.normalizeAutoStops(toNormalize, firstAutoStopIndex, i, prevOffset, offset);
            }
            firstAutoStopIndex = i + 1;
            prevOffset = currentStop.getHintOffsetType() == GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT ? currentStop.getHintOffset() : currentStop.getOffset();
        }
        if (firstAutoStopIndex < toNormalize.size()) {
            double lastStopOffset = Math.max(1.0, prevOffset);
            AbstractLinearGradientBuilder.normalizeAutoStops(toNormalize, firstAutoStopIndex, toNormalize.size(), prevOffset, lastStopOffset);
        }
    }

    private static void normalizeAutoStops(List<GradientColorStop> toNormalizeList, int fromIndex, int toIndex, double prevOffset, double nextOffset) {
        assert (toIndex >= fromIndex);
        int intervalsCount = Math.min(toIndex, toNormalizeList.size() - 1) - fromIndex + 1;
        double offsetShift = (nextOffset - prevOffset) / (double)intervalsCount;
        double currentOffset = prevOffset;
        for (int i = fromIndex; i < toIndex; ++i) {
            currentOffset += offsetShift;
            GradientColorStop currentAutoStop = toNormalizeList.get(i);
            assert (currentAutoStop.getOffsetType() == GradientColorStop.OffsetType.AUTO);
            currentAutoStop.setOffset(currentOffset, GradientColorStop.OffsetType.RELATIVE);
        }
    }

    private static void normalizeFirstStopOffset(List<GradientColorStop> result) {
        GradientColorStop firstStop = result.get(0);
        if (firstStop.getOffsetType() != GradientColorStop.OffsetType.AUTO) {
            return;
        }
        double firstStopOffset = 0.0;
        for (GradientColorStop stopColor : result) {
            if (stopColor.getOffsetType() == GradientColorStop.OffsetType.RELATIVE) {
                firstStopOffset = stopColor.getOffset();
                break;
            }
            if (stopColor.getHintOffsetType() != GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT) continue;
            firstStopOffset = stopColor.getHintOffset();
            break;
        }
        firstStopOffset = Math.min(0.0, firstStopOffset);
        firstStop.setOffset(firstStopOffset, GradientColorStop.OffsetType.RELATIVE);
    }

    private static List<GradientColorStop> copyStopsAndNormalizeAbsoluteOffsets(List<GradientColorStop> toNormalize, double baseVectorLength) {
        double lastUsedOffset = Double.NEGATIVE_INFINITY;
        ArrayList<GradientColorStop> copy = new ArrayList<GradientColorStop>(toNormalize.size());
        for (GradientColorStop stop : toNormalize) {
            double offset = stop.getOffset();
            GradientColorStop.OffsetType offsetType = stop.getOffsetType();
            if (offsetType == GradientColorStop.OffsetType.ABSOLUTE) {
                offsetType = GradientColorStop.OffsetType.RELATIVE;
                offset /= baseVectorLength;
            }
            if (offsetType == GradientColorStop.OffsetType.RELATIVE) {
                if (offset < lastUsedOffset) {
                    offset = lastUsedOffset;
                }
                lastUsedOffset = offset;
            }
            GradientColorStop result = new GradientColorStop(stop, offset, offsetType);
            double hintOffset = stop.getHintOffset();
            GradientColorStop.HintOffsetType hintOffsetType = stop.getHintOffsetType();
            if (hintOffsetType == GradientColorStop.HintOffsetType.ABSOLUTE_ON_GRADIENT) {
                hintOffsetType = GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT;
                hintOffset /= baseVectorLength;
            }
            if (hintOffsetType == GradientColorStop.HintOffsetType.RELATIVE_ON_GRADIENT) {
                if (hintOffset < lastUsedOffset) {
                    hintOffset = lastUsedOffset;
                }
                lastUsedOffset = hintOffset;
            }
            result.setHint(hintOffset, hintOffsetType);
            copy.add(result);
        }
        return copy;
    }

    private static void adjustStopsForPadIfNeeded(List<GradientColorStop> stopsToConstruct, double[] coordinatesDomain) {
        GradientColorStop lastStop;
        GradientColorStop firstStop = stopsToConstruct.get(0);
        if (coordinatesDomain[0] < firstStop.getOffset()) {
            stopsToConstruct.add(0, new GradientColorStop(firstStop, coordinatesDomain[0], GradientColorStop.OffsetType.RELATIVE));
        }
        if (coordinatesDomain[1] > (lastStop = stopsToConstruct.get(stopsToConstruct.size() - 1)).getOffset()) {
            stopsToConstruct.add(new GradientColorStop(lastStop, coordinatesDomain[1], GradientColorStop.OffsetType.RELATIVE));
        }
    }

    private static List<GradientColorStop> adjustNormalizedStopsToCoverDomain(List<GradientColorStop> normalizedStops, double[] targetDomain, GradientSpreadMethod spreadMethod) {
        double originalIntervalStart;
        ArrayList<GradientColorStop> adjustedStops = new ArrayList<GradientColorStop>();
        GradientColorStop lastColorStop = normalizedStops.get(normalizedStops.size() - 1);
        double originalIntervalEnd = lastColorStop.getOffset();
        double originalIntervalLength = originalIntervalEnd - (originalIntervalStart = normalizedStops.get(0).getOffset());
        if (originalIntervalLength <= 1.0E-10) {
            return Arrays.asList(new GradientColorStop(lastColorStop, targetDomain[0], GradientColorStop.OffsetType.RELATIVE), new GradientColorStop(lastColorStop, targetDomain[1], GradientColorStop.OffsetType.RELATIVE));
        }
        double startIntervalsShift = Math.floor((targetDomain[0] - originalIntervalStart) / originalIntervalLength);
        double iterationOffset = originalIntervalStart + originalIntervalLength * startIntervalsShift;
        boolean isIterationInverse = spreadMethod == GradientSpreadMethod.REFLECT && Math.abs(startIntervalsShift) % 2.0 != 0.0;
        int currentIterationIndex = isIterationInverse ? normalizedStops.size() - 1 : 0;
        double lastComputedOffset = iterationOffset;
        while (lastComputedOffset <= targetDomain[1]) {
            GradientColorStop currentStop = normalizedStops.get(currentIterationIndex);
            lastComputedOffset = isIterationInverse ? iterationOffset + originalIntervalEnd - currentStop.getOffset() : iterationOffset + currentStop.getOffset() - originalIntervalStart;
            GradientColorStop computedStop = new GradientColorStop(currentStop, lastComputedOffset, GradientColorStop.OffsetType.RELATIVE);
            if (lastComputedOffset < targetDomain[0] && !adjustedStops.isEmpty()) {
                adjustedStops.set(0, computedStop);
            } else {
                adjustedStops.add(computedStop);
            }
            if (isIterationInverse) {
                if (--currentIterationIndex < 0) {
                    iterationOffset += originalIntervalLength;
                    isIterationInverse = false;
                    currentIterationIndex = 1;
                }
            } else if (++currentIterationIndex == normalizedStops.size()) {
                iterationOffset += originalIntervalLength;
                isIterationInverse = spreadMethod == GradientSpreadMethod.REFLECT;
                int n = currentIterationIndex = isIterationInverse ? normalizedStops.size() - 2 : 0;
            }
            if (isIterationInverse) {
                GradientColorStop nextColor = normalizedStops.get(currentIterationIndex);
                computedStop.setHint(1.0 - nextColor.getHintOffset(), nextColor.getHintOffsetType());
                continue;
            }
            computedStop.setHint(currentStop.getHintOffset(), currentStop.getHintOffsetType());
        }
        return adjustedStops;
    }

    private static IPdfFunction constructFunction(List<GradientColorStop> toConstruct) {
        GradientColorStop currentStop;
        int functionsAmount = toConstruct.size() - 1;
        double[] bounds = new double[functionsAmount - 1];
        ArrayList<AbstractPdfFunction<? extends PdfDictionary>> type2Functions = new ArrayList<AbstractPdfFunction<? extends PdfDictionary>>(functionsAmount);
        GradientColorStop nextStop = toConstruct.get(0);
        double domainStart = nextStop.getOffset();
        for (int i = 1; i < functionsAmount; ++i) {
            currentStop = nextStop;
            nextStop = toConstruct.get(i);
            bounds[i - 1] = nextStop.getOffset();
            type2Functions.add(AbstractLinearGradientBuilder.constructSingleGradientSegmentFunction(currentStop, nextStop));
        }
        currentStop = nextStop;
        nextStop = toConstruct.get(toConstruct.size() - 1);
        type2Functions.add(AbstractLinearGradientBuilder.constructSingleGradientSegmentFunction(currentStop, nextStop));
        double domainEnd = nextStop.getOffset();
        double[] encode = new double[functionsAmount * 2];
        for (int i = 0; i < encode.length; i += 2) {
            encode[i] = 0.0;
            encode[i + 1] = 1.0;
        }
        return new PdfType3Function(new double[]{domainStart, domainEnd}, null, type2Functions, bounds, encode);
    }

    private static AbstractPdfFunction<? extends PdfDictionary> constructSingleGradientSegmentFunction(GradientColorStop from, GradientColorStop to) {
        double exponent = 1.0;
        float[] fromColor = from.getRgbArray();
        float[] toColor = to.getRgbArray();
        if (from.getHintOffsetType() == GradientColorStop.HintOffsetType.RELATIVE_BETWEEN_COLORS) {
            double hintOffset = from.getHintOffset();
            if (hintOffset <= 1.0E-10) {
                fromColor = toColor;
            } else if (hintOffset >= 0.9999999999) {
                toColor = fromColor;
            } else {
                exponent = Math.log(0.5) / Math.log(hintOffset);
            }
        }
        return new PdfType2Function(new float[]{0.0f, 1.0f}, null, fromColor, toColor, exponent);
    }

    private static PdfArray createCoordsPdfArray(Point[] coordsPoints) {
        assert (coordsPoints != null && coordsPoints.length == 2);
        return new PdfArray(new double[]{coordsPoints[0].getX(), coordsPoints[0].getY(), coordsPoints[1].getX(), coordsPoints[1].getY()});
    }
}

