/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.ListSymbolAlignment;
import com.itextpdf.layout.properties.ListSymbolPosition;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ListRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingDummyElement;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListItemRenderer
extends DivRenderer {
    protected IRenderer symbolRenderer;
    protected float symbolAreaWidth;
    private boolean symbolAddedInside;

    public ListItemRenderer(ListItem modelElement) {
        super(modelElement);
    }

    public void addSymbolRenderer(IRenderer symbolRenderer, float symbolAreaWidth) {
        this.symbolRenderer = symbolRenderer;
        this.symbolAreaWidth = symbolAreaWidth;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        if (this.symbolRenderer != null && this.getProperty(27) == null && !this.isListSymbolEmpty(this.symbolRenderer)) {
            float[] ascenderDescender = this.calculateAscenderDescender();
            float minHeight = Math.max(this.symbolRenderer.getOccupiedArea().getBBox().getHeight(), ascenderDescender[0] - ascenderDescender[1]);
            this.updateMinHeight(UnitValue.createPointValue(minHeight));
        }
        this.applyListSymbolPosition();
        LayoutResult result = super.layout(layoutContext);
        if (2 == result.getStatus()) {
            result.getOverflowRenderer().deleteOwnProperty(85);
        }
        return result;
    }

    @Override
    public void draw(DrawContext drawContext) {
        LayoutTaggingHelper taggingHelper;
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(ListItemRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Drawing won't be performed."}));
            return;
        }
        if (drawContext.isTaggingEnabled() && (taggingHelper = (LayoutTaggingHelper)this.getProperty(108)) != null) {
            if (this.symbolRenderer != null) {
                LayoutTaggingHelper.addTreeHints(taggingHelper, this.symbolRenderer);
            }
            if (taggingHelper.isArtifact(this)) {
                taggingHelper.markArtifactHint(this.symbolRenderer);
            } else {
                TaggingHintKey hintKey = LayoutTaggingHelper.getHintKey(this);
                TaggingHintKey parentHint = taggingHelper.getAccessibleParentHint(hintKey);
                if (parentHint != null && !"LI".equals(parentHint.getAccessibleElement().getAccessibilityProperties().getRole())) {
                    TaggingDummyElement listItemIntermediate = new TaggingDummyElement("LI");
                    List<TaggingHintKey> intermediateKid = Collections.singletonList(LayoutTaggingHelper.getOrCreateHintKey(listItemIntermediate));
                    taggingHelper.replaceKidHint(hintKey, intermediateKid);
                    if (this.symbolRenderer != null) {
                        taggingHelper.addKidsHint(listItemIntermediate, Collections.singletonList(this.symbolRenderer));
                    }
                    taggingHelper.addKidsHint(listItemIntermediate, Collections.singletonList(this));
                }
            }
        }
        super.draw(drawContext);
        if (this.symbolRenderer != null && !this.symbolAddedInside) {
            boolean isRtl = BaseDirection.RIGHT_TO_LEFT == this.getProperty(7);
            this.symbolRenderer.setParent(this);
            float x = isRtl ? this.occupiedArea.getBBox().getRight() : this.occupiedArea.getBBox().getLeft();
            ListSymbolPosition symbolPosition = (ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(this, this.parent, 83));
            if (symbolPosition != ListSymbolPosition.DEFAULT) {
                Float symbolIndent = this.getPropertyAsFloat(39);
                x = isRtl ? (x += this.symbolAreaWidth + (symbolIndent == null ? 0.0f : symbolIndent.floatValue())) : (x -= this.symbolAreaWidth + (symbolIndent == null ? 0.0f : symbolIndent.floatValue()));
                if (symbolPosition == ListSymbolPosition.OUTSIDE) {
                    Logger logger;
                    if (isRtl) {
                        UnitValue marginRightUV = this.getPropertyAsUnitValue(45);
                        if (!marginRightUV.isPointValue()) {
                            logger = LoggerFactory.getLogger(ListItemRenderer.class);
                            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
                        }
                        x -= marginRightUV.getValue();
                    } else {
                        UnitValue marginLeftUV = this.getPropertyAsUnitValue(44);
                        if (!marginLeftUV.isPointValue()) {
                            logger = LoggerFactory.getLogger(ListItemRenderer.class);
                            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
                        }
                        x += marginLeftUV.getValue();
                    }
                }
            }
            this.applyMargins(this.occupiedArea.getBBox(), false);
            this.applyBorderBox(this.occupiedArea.getBBox(), false);
            if (this.childRenderers.size() > 0) {
                Float yLine = null;
                for (int i = 0; !(i >= this.childRenderers.size() || ((IRenderer)this.childRenderers.get(i)).getOccupiedArea().getBBox().getHeight() > 0.0f && (yLine = ((AbstractRenderer)this.childRenderers.get(i)).getFirstYLineRecursively()) != null); ++i) {
                }
                if (yLine != null) {
                    if (this.symbolRenderer instanceof LineRenderer) {
                        this.symbolRenderer.move(0.0f, yLine.floatValue() - ((LineRenderer)this.symbolRenderer).getYLine());
                    } else {
                        this.symbolRenderer.move(0.0f, yLine.floatValue() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
                    }
                } else {
                    this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - (this.symbolRenderer.getOccupiedArea().getBBox().getY() + this.symbolRenderer.getOccupiedArea().getBBox().getHeight()));
                }
            } else if (this.symbolRenderer instanceof TextRenderer) {
                ((TextRenderer)this.symbolRenderer).moveYLineTo(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.calculateAscenderDescender()[0]);
            } else {
                this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
            }
            this.applyBorderBox(this.occupiedArea.getBBox(), true);
            this.applyMargins(this.occupiedArea.getBBox(), true);
            ListSymbolAlignment listSymbolAlignment = this.parent.getProperty(38, isRtl ? ListSymbolAlignment.LEFT : ListSymbolAlignment.RIGHT);
            float dxPosition = x - this.symbolRenderer.getOccupiedArea().getBBox().getX();
            if (listSymbolAlignment == ListSymbolAlignment.RIGHT) {
                if (!isRtl) {
                    dxPosition += this.symbolAreaWidth - this.symbolRenderer.getOccupiedArea().getBBox().getWidth();
                }
            } else if (listSymbolAlignment == ListSymbolAlignment.LEFT && isRtl) {
                dxPosition -= this.symbolAreaWidth - this.symbolRenderer.getOccupiedArea().getBBox().getWidth();
            }
            if (this.symbolRenderer instanceof LineRenderer) {
                if (isRtl) {
                    this.symbolRenderer.move(dxPosition - this.symbolRenderer.getOccupiedArea().getBBox().getWidth(), 0.0f);
                } else {
                    this.symbolRenderer.move(dxPosition, 0.0f);
                }
            } else {
                this.symbolRenderer.move(dxPosition, 0.0f);
            }
            RootRenderer root = this.getRootRenderer();
            Rectangle effectiveArea = root.getCurrentArea().getBBox();
            if (!isRtl && this.symbolRenderer.getOccupiedArea().getBBox().getRight() > effectiveArea.getLeft() || isRtl && this.symbolRenderer.getOccupiedArea().getBBox().getLeft() < effectiveArea.getRight()) {
                this.beginElementOpacityApplying(drawContext);
                this.symbolRenderer.draw(drawContext);
                this.endElementOpacityApplying(drawContext);
            }
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ListItemRenderer((ListItem)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        ListItemRenderer splitRenderer = (ListItemRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.symbolAddedInside = this.symbolAddedInside;
        splitRenderer.isLastRendererForModelElement = false;
        if (layoutResult == 2) {
            splitRenderer.symbolRenderer = this.symbolRenderer;
            splitRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        splitRenderer.addAllProperties(this.getOwnProperties());
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        ListItemRenderer overflowRenderer = (ListItemRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        if (layoutResult == 3) {
            overflowRenderer.symbolRenderer = this.symbolRenderer;
            overflowRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return overflowRenderer;
    }

    private void applyListSymbolPosition() {
        ListSymbolPosition symbolPosition;
        if (this.symbolRenderer != null && (symbolPosition = (ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(this, this.parent, 83))) == ListSymbolPosition.INSIDE) {
            IRenderer paragraphRenderer;
            boolean isRtl = BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7));
            if (this.childRenderers.size() > 0 && this.childRenderers.get(0) instanceof ParagraphRenderer) {
                paragraphRenderer = (ParagraphRenderer)this.childRenderers.get(0);
                Float symbolIndent = this.getPropertyAsFloat(39);
                if (this.symbolRenderer instanceof LineRenderer) {
                    if (symbolIndent != null) {
                        this.symbolRenderer.getChildRenderers().get(1).setProperty(isRtl ? 44 : 45, UnitValue.createPointValue(symbolIndent.floatValue()));
                    }
                    for (IRenderer childRenderer : this.symbolRenderer.getChildRenderers()) {
                        ((ParagraphRenderer)paragraphRenderer).childRenderers.add(0, childRenderer);
                    }
                } else {
                    if (symbolIndent != null) {
                        this.symbolRenderer.setProperty(isRtl ? 44 : 45, UnitValue.createPointValue(symbolIndent.floatValue()));
                    }
                    ((ParagraphRenderer)paragraphRenderer).childRenderers.add(0, this.symbolRenderer);
                }
                this.symbolAddedInside = true;
            } else if (this.childRenderers.size() > 0 && this.childRenderers.get(0) instanceof ImageRenderer) {
                paragraphRenderer = this.renderSymbolInNeutralParagraph();
                paragraphRenderer.addChild((IRenderer)this.childRenderers.get(0));
                this.childRenderers.set(0, paragraphRenderer);
                this.symbolAddedInside = true;
            }
            if (!this.symbolAddedInside) {
                paragraphRenderer = this.renderSymbolInNeutralParagraph();
                this.childRenderers.add(0, paragraphRenderer);
                this.symbolAddedInside = true;
            }
        }
    }

    private IRenderer renderSymbolInNeutralParagraph() {
        Paragraph p = (Paragraph)new Paragraph().setNeutralRole();
        IRenderer paragraphRenderer = ((Paragraph)p.setMargin(0.0f)).createRendererSubTree();
        Float symbolIndent = (Float)ListRenderer.getListItemOrListProperty(this, this.parent, 39);
        if (symbolIndent != null) {
            this.symbolRenderer.setProperty(45, UnitValue.createPointValue(symbolIndent.floatValue()));
        }
        paragraphRenderer.addChild(this.symbolRenderer);
        return paragraphRenderer;
    }

    private boolean isListSymbolEmpty(IRenderer listSymbolRenderer) {
        if (listSymbolRenderer instanceof TextRenderer) {
            return ((TextRenderer)listSymbolRenderer).getText().toString().length() == 0;
        }
        if (listSymbolRenderer instanceof LineRenderer) {
            return ((TextRenderer)listSymbolRenderer.getChildRenderers().get(1)).getText().toString().length() == 0;
        }
        return false;
    }

    private float[] calculateAscenderDescender() {
        PdfFont listItemFont = this.resolveFirstPdfFont();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (listItemFont != null && fontSize != null) {
            if (!fontSize.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(ListItemRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
            }
            float[] ascenderDescender = TextRenderer.calculateAscenderDescender(listItemFont);
            return new float[]{fontSize.getValue() * FontProgram.convertTextSpaceToGlyphSpace((float)ascenderDescender[0]), fontSize.getValue() * FontProgram.convertTextSpaceToGlyphSpace((float)ascenderDescender[1])};
        }
        return new float[]{0.0f, 0.0f};
    }
}

