/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ApplicationLoggingContextDataConfig
extends BaseConfig {
    public static final String ROOT = "context_data";
    public static final String ENABLED = "enabled";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public static final boolean DEFAULT_ENABLED = false;
    private final boolean enabled;
    private final List<String> include;
    private final List<String> exclude;

    public ApplicationLoggingContextDataConfig(Map<String, Object> props, String parentRoot, boolean highSecurity) {
        super(props, parentRoot + ROOT + ".");
        boolean bl = this.enabled = !highSecurity && this.getProperty(ENABLED, false) != false;
        if (this.enabled) {
            this.include = this.getUniqueStrings(INCLUDE);
            this.exclude = this.getUniqueStrings(EXCLUDE);
        } else {
            this.include = Collections.emptyList();
            this.exclude = Collections.emptyList();
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }
}

