/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.weave.UtilityClass;
import com.newrelic.weave.utils.WeaveUtils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class InitProblemClasses {
    public static final void loadInitialClasses() {
        try {
            String holdCounterClassName;
            Utils.getClassResourceName(Class.forName("java.net.URL"));
            UtilityClass.class.getName();
            ClassLoader classLoader = UtilityClass.class.getClassLoader();
            classLoader.getResource(WeaveUtils.getClassResourceName(UtilityClass.class.getName()));
            if (null != InstrumentationContextManager.class.getProtectionDomain()) {
                InstrumentationContextManager.class.getProtectionDomain().getCodeSource();
            }
            if (null != Throwable.class.getProtectionDomain()) {
                Throwable.class.getProtectionDomain().getCodeSource();
            }
            ConcurrentHashMap<Object, Object> optimizedWeavePackagePreload = new ConcurrentHashMap<Object, Object>();
            optimizedWeavePackagePreload.values().iterator();
            optimizedWeavePackagePreload.put(new Object(), new Object());
            for (Map.Entry entry : optimizedWeavePackagePreload.entrySet()) {
                Set singletonSet = Collections.singleton(entry.getKey());
                for (Object k : singletonSet) {
                }
            }
            for (Map.Entry entry : optimizedWeavePackagePreload.values()) {
            }
            Reference.class.getName();
            InterruptedException.class.getName();
            ReferenceQueue.class.getName();
            try {
                Class.forName("sun.misc.Cleaner");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                holdCounterClassName = "java.util.concurrent.locks.ReentrantReadWriteLock$Sync$HoldCounter";
                Class.forName(holdCounterClassName);
                Agent.LOG.log(Level.FINE, "Worked around loading class " + holdCounterClassName);
            }
            catch (ClassNotFoundException e) {
                Agent.LOG.log(Level.WARNING, "Error working around class loading issue:", e);
            }
            try {
                holdCounterClassName = "java.util.concurrent.ThreadLocalRandom";
                Class.forName(holdCounterClassName);
                Agent.LOG.log(Level.FINE, "Worked around loading class " + holdCounterClassName);
            }
            catch (ClassNotFoundException e) {
                Agent.LOG.log(Level.WARNING, "Error working around class loading issue:", e);
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, e, "Exception while performing initial loading");
        }
    }
}

