/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.okhttp;

import com.newrelic.agent.deps.io.grpc.internal.AbstractReadableBuffer;
import com.newrelic.agent.deps.io.grpc.internal.ReadableBuffer;
import com.newrelic.agent.deps.okio.Buffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class OkHttpReadableBuffer
extends AbstractReadableBuffer {
    private final Buffer buffer;

    OkHttpReadableBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int readableBytes() {
        return (int)this.buffer.size();
    }

    @Override
    public int readUnsignedByte() {
        try {
            this.fakeEofExceptionMethod();
            return this.buffer.readByte() & 0xFF;
        }
        catch (EOFException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    private void fakeEofExceptionMethod() throws EOFException {
    }

    @Override
    public void skipBytes(int length) {
        try {
            this.buffer.skip(length);
        }
        catch (EOFException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void readBytes(byte[] dest, int destOffset, int length) {
        while (length > 0) {
            int bytesRead = this.buffer.read(dest, destOffset, length);
            if (bytesRead == -1) {
                throw new IndexOutOfBoundsException("EOF trying to read " + length + " bytes");
            }
            length -= bytesRead;
            destOffset += bytesRead;
        }
    }

    @Override
    public void readBytes(ByteBuffer dest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readBytes(OutputStream dest, int length) throws IOException {
        this.buffer.writeTo(dest, length);
    }

    @Override
    public ReadableBuffer readBytes(int length) {
        Buffer buf = new Buffer();
        buf.write(this.buffer, (long)length);
        return new OkHttpReadableBuffer(buf);
    }

    @Override
    public void close() {
        this.buffer.clear();
    }
}

