/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.logging.ApacheCommonsAdaptingLogFactory;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLogManager;

public class AgentLogManager {
    static final String ROOT_LOGGER_NAME = "com.newrelic";
    private static final IAgentLogManager INSTANCE = AgentLogManager.createAgentLogManager();
    private static final IAgentLogger ROOT_LOGGER = INSTANCE.getRootLogger();

    private AgentLogManager() {
    }

    private static IAgentLogManager createAgentLogManager() {
        System.setProperty("com.newrelic.agent.deps.org.apache.commons.logging.LogFactory", ApacheCommonsAdaptingLogFactory.class.getName());
        return Log4jLogManager.create(ROOT_LOGGER_NAME);
    }

    public static IAgentLogger getLogger() {
        return ROOT_LOGGER;
    }

    public static String getLogFilePath() {
        return INSTANCE.getLogFilePath();
    }

    public static void configureLogger(AgentConfig agentConfig) {
        INSTANCE.configureLogger(agentConfig);
    }

    public static void addConsoleHandler() {
        INSTANCE.addConsoleHandler();
    }

    public static void setLogLevel(String level) {
        INSTANCE.setLogLevel(level);
    }

    public static String getLogLevel() {
        return INSTANCE.getLogLevel();
    }
}

