/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.service.module.JarData;
import com.newrelic.agent.service.module.JarInfo;
import com.newrelic.agent.service.module.ShaChecksums;
import com.newrelic.api.agent.Logger;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.File;
import java.util.function.Consumer;
import java.util.logging.Level;

public class WeavePackageAnalyzer
implements Runnable {
    private final File file;
    private final Consumer<JarData> analyzedJars;
    private final Logger logger;

    public WeavePackageAnalyzer(File file, Consumer<JarData> analyzedJars, Logger logger) {
        this.file = file;
        this.analyzedJars = analyzedJars;
        this.logger = logger;
    }

    @Override
    public void run() {
        WeavePackageConfig weaveConfig;
        try {
            weaveConfig = WeavePackageConfig.builder().url(this.file.toURI().toURL()).build();
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, (Throwable)e, "{0} failed to build weave config for file");
            return;
        }
        JarData jarData = this.getWeaveJar(this.file, weaveConfig);
        this.logger.log(Level.FINEST, "{0} adding analyzed jar from weave package: {1}", (Object)this.file, (Object)jarData);
        this.analyzedJars.accept(jarData);
    }

    @VisibleForTesting
    JarData getWeaveJar(File file, WeavePackageConfig weavePackageConfig) {
        String sha1Checksum = "UNKNOWN";
        try {
            sha1Checksum = ShaChecksums.computeSha(file);
        }
        catch (Exception ex) {
            this.logger.log(Level.FINEST, (Throwable)ex, "{0} Error getting weave file checksum", (Object)file);
        }
        ImmutableMap<String, String> attributes = ImmutableMap.of("weaveFile", weavePackageConfig.getSource(), "sha1Checksum", sha1Checksum);
        JarInfo info = new JarInfo(Float.toString(weavePackageConfig.getVersion()), attributes);
        return new JarData(weavePackageConfig.getName(), info);
    }
}

