/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Gauge;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.palominolabs.metrics.guice.MetricNamer;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public class DefaultMetricNamer
implements MetricNamer {
    static final String COUNTER_SUFFIX = "counter";
    static final String COUNTER_SUFFIX_MONOTONIC = "current";
    static final String GAUGE_SUFFIX = "gauge";
    static final String METERED_SUFFIX = "meter";
    static final String TIMED_SUFFIX = "timer";

    @Override
    @Nonnull
    public String getNameForCounted(@Nonnull Method method, @Nonnull Counted counted) {
        if (counted.absolute()) {
            return counted.name();
        }
        if (counted.name().isEmpty()) {
            if (counted.monotonic()) {
                return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), COUNTER_SUFFIX_MONOTONIC});
            }
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), COUNTER_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{counted.name()});
    }

    @Override
    @Nonnull
    public String getNameForExceptionMetered(@Nonnull Method method, @Nonnull ExceptionMetered exceptionMetered) {
        if (exceptionMetered.absolute()) {
            return exceptionMetered.name();
        }
        if (exceptionMetered.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), "exceptions"});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{exceptionMetered.name()});
    }

    @Override
    @Nonnull
    public String getNameForGauge(@Nonnull Method method, @Nonnull Gauge gauge) {
        if (gauge.absolute()) {
            return gauge.name();
        }
        if (gauge.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), GAUGE_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{gauge.name()});
    }

    @Override
    @Nonnull
    public String getNameForMetered(@Nonnull Method method, @Nonnull Metered metered) {
        if (metered.absolute()) {
            return metered.name();
        }
        if (metered.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), METERED_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{metered.name()});
    }

    @Override
    @Nonnull
    public String getNameForTimed(@Nonnull Method method, @Nonnull Timed timed) {
        if (timed.absolute()) {
            return timed.name();
        }
        if (timed.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), TIMED_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{timed.name()});
    }
}

