/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV01;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV02;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.NamespaceReader;
import java.util.Optional;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class AppHdrParser {
    public static Optional<AppHdr> parse(String xml) {
        try {
            boolean headerIsPresent;
            Optional<String> namespace = NamespaceReader.findAppHdrNamespace(xml);
            boolean bl = headerIsPresent = namespace.isPresent() || NamespaceReader.elementExists(xml, "AppHdr");
            if (headerIsPresent) {
                AppHdr parsedHeader = AppHdrParser.parseHeaderFromSAXSource(xml, namespace.orElse(null));
                return Optional.ofNullable(parsedHeader);
            }
        }
        catch (Exception e) {
            MxParseUtils.handleParseException(e);
        }
        return Optional.empty();
    }

    private static AppHdr parseHeaderFromSAXSource(String xml, String namespace) throws SAXException {
        SAXSource source = MxParseUtils.createFilteredSAXSource(xml, "AppHdr");
        if (StringUtils.equals((CharSequence)"urn:swift:xsd:$ahV10", (CharSequence)namespace)) {
            return (LegacyAppHdr)MxParseUtils.parseSAXSource(source, LegacyAppHdr.class, LegacyAppHdr._classes);
        }
        if (StringUtils.equals((CharSequence)"urn:iso:std:iso:20022:tech:xsd:head.001.001.02", (CharSequence)namespace)) {
            return (BusinessAppHdrV02)MxParseUtils.parseSAXSource(source, BusinessAppHdrV02.class, BusinessAppHdrV02._classes);
        }
        return (BusinessAppHdrV01)MxParseUtils.parseSAXSource(source, BusinessAppHdrV01.class, BusinessAppHdrV01._classes);
    }

    public static Optional<AppHdr> parse(Element e) {
        return AppHdrParser.parse(AppHdrParser.asXml(e));
    }

    private static String asXml(Element e) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(e);
    }
}

