/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxWrite;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.XsysNamespaces;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import org.apache.commons.lang3.Validate;

public class MxWriteImpl
implements MxWrite {
    private static final transient Logger log = Logger.getLogger(MxWriteImpl.class.getName());

    @Deprecated
    public static String write(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        return MxWriteImpl.write(namespace, obj, classes, prefix, includeXMLDeclaration, null);
    }

    public static String write(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        Validate.notNull((Object)namespace, (String)"namespace can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)obj, (String)"MxSwiftMessage can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)classes, (String)"Class[] can not be null", (Object[])new Object[0]);
        try {
            JAXBContext context = JaxbContextLoader.INSTANCE.get(obj);
            JAXBElement element = new JAXBElement(new QName("Document"), obj.getClass(), null, (Object)obj);
            Marshaller marshaller = context.createMarshaller();
            StringWriter sw = new StringWriter();
            XmlEventWriter writer = new XmlEventWriter(sw, prefix, includeXMLDeclaration, "Document", escapeHandler);
            HashMap<String, String> preferredPrefixes = new HashMap<String, String>();
            for (XsysNamespaces xsys : XsysNamespaces.values()) {
                preferredPrefixes.put(xsys.namespaceURI(), xsys.prefix());
            }
            writer.setPreferredPrefixes(preferredPrefixes);
            marshaller.marshal((Object)element, (XMLEventWriter)writer);
            if (log.isLoggable(Level.FINER)) {
                log.finer("XML: \n" + sw.getBuffer().toString());
            }
            return sw.getBuffer().toString();
        }
        catch (ExecutionException | JAXBException e) {
            log.log(Level.SEVERE, "Error writing XML:" + e + "\n for message: " + obj);
            return null;
        }
    }

    @Override
    @Deprecated
    public String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        return MxWriteImpl.write(namespace, obj, classes, prefix, includeXMLDeclaration, null);
    }

    @Override
    public String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        return MxWriteImpl.write(namespace, obj, classes, prefix, includeXMLDeclaration, escapeHandler);
    }
}

