/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.mx.DefaultEscapeHandler;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class XmlEventWriter
implements XMLEventWriter {
    private static final transient Logger log = Logger.getLogger(XmlEventWriter.class.getName());
    private static final String INDENT = "    ";
    private final Writer out;
    private StartElement delayedStart;
    private boolean startTagIncomplete = false;
    private int startElementCount;
    private int nestedLevel;
    private String defaultPrefix;
    private Map<String, String> preferredPrefixes;
    private boolean includeXMLDeclaration;
    private String rootElement;
    private String currentElement;
    private boolean preserveQnamePrefixes = false;
    private int previousNestedStartLevel;
    private XMLEvent previousEvent;
    private EscapeHandler escapeHandler;

    @Deprecated
    public XmlEventWriter(Writer baos, String defaultPrefix, boolean includeXMLDeclaration, String rootElement) {
        this(baos, defaultPrefix, includeXMLDeclaration, rootElement, null);
    }

    public XmlEventWriter(Writer baos, String defaultPrefix, boolean includeXMLDeclaration, String rootElement, EscapeHandler escapeHandler) {
        this.out = baos;
        this.startElementCount = 0;
        this.nestedLevel = 0;
        this.defaultPrefix = defaultPrefix;
        this.includeXMLDeclaration = includeXMLDeclaration;
        this.rootElement = rootElement;
        this.escapeHandler = escapeHandler != null ? escapeHandler : new DefaultEscapeHandler();
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (event != null) {
            try {
                int type = event.getEventType();
                switch (type) {
                    case 7: {
                        if (this.includeXMLDeclaration) {
                            String encoding = ((StartDocument)event).getCharacterEncodingScheme();
                            String encodingOrDefault = encoding != null ? encoding : "UTF-8";
                            this.out.write("<?xml version=\"1.0\" encoding=\"" + encodingOrDefault + "\" ?>\n");
                        } else {
                            log.finest("skipping xml declaration");
                        }
                        this.previousEvent = event;
                        break;
                    }
                    case 1: {
                        ++this.startElementCount;
                        this.closeStartTagIfNeeded();
                        StartElement se = event.asStartElement();
                        String localPart = se.getName().getLocalPart();
                        if (StringUtils.equals((CharSequence)localPart, (CharSequence)this.rootElement) && this.startElementCount == 1) {
                            this.delayedStart = se;
                            log.finest("local part is Document, initializing delayed start, startElementCount=" + this.startElementCount);
                        } else {
                            this.writeIndentIfNeeded(this.out, this.nestedLevel);
                            this.out.write("<" + this.prefixString(se.getName()) + localPart);
                            this.startTagIncomplete = true;
                        }
                        this.previousNestedStartLevel = this.nestedLevel++;
                        this.currentElement = localPart;
                        this.previousEvent = event;
                        break;
                    }
                    case 13: {
                        Namespace ne = (Namespace)event;
                        StringBuilder sb = new StringBuilder();
                        if (this.delayedStart != null) {
                            String localPart = this.delayedStart.getName().getLocalPart();
                            sb.append("<" + this.prefixString(ne.getName()) + localPart);
                            this.delayedStart = null;
                            this.currentElement = localPart;
                        }
                        sb.append(this.namespace(ne));
                        this.out.write(sb.toString());
                        this.startTagIncomplete = true;
                        this.previousEvent = event;
                        break;
                    }
                    case 4: {
                        this.closeStartTagIfNeeded();
                        Characters ce = event.asCharacters();
                        if (ce.isIgnorableWhiteSpace()) {
                            this.previousEvent = event;
                            break;
                        }
                        if (ce.isWhiteSpace() && this.previousEvent != null && this.previousEvent.getEventType() == 2) {
                            this.previousEvent = event;
                            break;
                        }
                        char[] arr = ce.getData().toCharArray();
                        String escapedString = this.escapeHandler.escape(arr, false);
                        this.out.write(escapedString);
                        this.previousEvent = event;
                        break;
                    }
                    case 2: {
                        --this.nestedLevel;
                        this.closeStartTagIfNeeded();
                        EndElement ee = event.asEndElement();
                        String localPart = ee.getName().getLocalPart();
                        if (!localPart.equals(this.currentElement)) {
                            this.writeIndentIfNeeded(this.out, this.nestedLevel);
                        } else if (localPart.equals(this.currentElement) && this.previousNestedStartLevel != this.nestedLevel) {
                            --this.previousNestedStartLevel;
                            this.writeIndentIfNeeded(this.out, this.previousNestedStartLevel);
                        }
                        this.out.write("</" + this.prefixString(ee.getName()) + localPart + ">");
                        this.previousNestedStartLevel = this.nestedLevel;
                        this.previousEvent = event;
                        break;
                    }
                    case 8: {
                        this.closeStartTagIfNeeded();
                        this.previousEvent = event;
                        break;
                    }
                    case 10: {
                        Attribute a = (Attribute)event;
                        String escapedString = a.getValue() != null ? this.escapeHandler.escape(a.getValue().toCharArray(), true) : "";
                        this.out.write(" " + a.getName() + "=\"" + escapedString + "\"");
                        this.previousEvent = event;
                        break;
                    }
                    default: {
                        log.finer("PW Unhandled XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                        this.previousEvent = event;
                        break;
                    }
                }
            }
            catch (IOException e) {
                log.severe("PW I/O error: " + e.getMessage());
                log.log(Level.FINER, "PW I/O error: ", e);
                throw new XMLStreamException(e);
            }
        }
    }

    private void writeIndentIfNeeded(Writer writer, int nestedLevel) throws IOException {
        this.out.write(System.lineSeparator());
        if (nestedLevel > 0) {
            for (int i = 0; i < nestedLevel; ++i) {
                writer.write(INDENT);
            }
        }
    }

    private String namespace(Namespace namespace) {
        StringBuilder sb = new StringBuilder(" xmlns");
        String prefix = this.resolvePrefix(namespace);
        if (prefix != null) {
            sb.append(":").append(prefix);
        }
        sb.append("=\"").append(namespace.getValue()).append("\"");
        return sb.toString();
    }

    private String prefixString(QName qname) {
        String prefix = this.resolvePrefix(qname);
        if (prefix != null) {
            return prefix + ":";
        }
        return "";
    }

    private String resolvePrefix(QName qname) {
        String prefix;
        if (this.preferredPrefixes != null && (prefix = this.preferredPrefixes.get(qname.getNamespaceURI())) != null) {
            return prefix;
        }
        if (this.preserveQnamePrefixes && StringUtils.isNotBlank((CharSequence)qname.getPrefix())) {
            return qname.getPrefix();
        }
        return this.defaultPrefix;
    }

    private String resolvePrefix(Namespace namespace) {
        String prefix;
        if (this.preferredPrefixes != null && (prefix = this.preferredPrefixes.get(namespace.getValue())) != null) {
            return prefix;
        }
        if (this.preserveQnamePrefixes && StringUtils.isNotBlank((CharSequence)namespace.getPrefix())) {
            return namespace.getPrefix();
        }
        return this.defaultPrefix;
    }

    private void closeStartTagIfNeeded() throws IOException {
        if (this.startTagIncomplete) {
            this.out.write(62);
            this.startTagIncomplete = false;
        }
    }

    @Override
    public void add(XMLEventReader arg0) {
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) {
    }

    @Override
    public String getPrefix(String arg0) {
        return null;
    }

    @Override
    public void setDefaultNamespace(String arg0) {
    }

    @Override
    public void setPrefix(String arg0, String arg1) {
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    @Deprecated
    public Map<String, String> getPeferredPrefixes() {
        DeprecationUtils.phase2(XmlEventWriter.class, (String)"getPeferredPrefixes()", (String)"Use getPreferredPrefixes() instead");
        return this.getPreferredPrefixes();
    }

    @Deprecated
    public void setPeferredPrefixes(Map<String, String> preferredPrefixes) {
        DeprecationUtils.phase2(XmlEventWriter.class, (String)"setPeferredPrefixes(Map)", (String)"Use setPreferredPrefixes(Map) instead");
        this.setPreferredPrefixes(preferredPrefixes);
    }

    public Map<String, String> getPreferredPrefixes() {
        return this.preferredPrefixes;
    }

    public void setPreferredPrefixes(Map<String, String> preferredPrefixes) {
        this.preferredPrefixes = preferredPrefixes;
    }

    public boolean isIncludeXMLDeclaration() {
        return this.includeXMLDeclaration;
    }

    public void setIncludeXMLDeclaration(boolean includeXMLDeclaration) {
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public void setPreserveQnamePrefixes(boolean preserveQnamePrefixes) {
        this.preserveQnamePrefixes = preserveQnamePrefixes;
    }
}

