
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * ATM information.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AutomatedTellerMachine5", propOrder = {
    "id",
    "addtlId",
    "seqNb",
    "baseCcy",
    "lctn",
    "lctnCtgy",
    "eqpmnt",
    "outOfSvcDvc",
    "msgPrtcn"
})
public class AutomatedTellerMachine5 {

    @XmlElement(name = "Id", required = true)
    protected String id;
    @XmlElement(name = "AddtlId")
    protected String addtlId;
    @XmlElement(name = "SeqNb")
    protected String seqNb;
    @XmlElement(name = "BaseCcy", required = true)
    protected String baseCcy;
    @XmlElement(name = "Lctn")
    protected PostalAddress17 lctn;
    @XmlElement(name = "LctnCtgy")
    @XmlSchemaType(name = "string")
    protected TransactionEnvironment2Code lctnCtgy;
    @XmlElement(name = "Eqpmnt")
    protected ATMEquipment1 eqpmnt;
    @XmlElement(name = "OutOfSvcDvc")
    @XmlSchemaType(name = "string")
    protected List<ATMDevice2Code> outOfSvcDvc;
    @XmlElement(name = "MsgPrtcn")
    @XmlSchemaType(name = "string")
    protected MessageProtection1Code msgPrtcn;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public AutomatedTellerMachine5 setId(String value) {
        this.id = value;
        return this;
    }

    /**
     * Gets the value of the addtlId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAddtlId() {
        return addtlId;
    }

    /**
     * Sets the value of the addtlId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public AutomatedTellerMachine5 setAddtlId(String value) {
        this.addtlId = value;
        return this;
    }

    /**
     * Gets the value of the seqNb property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSeqNb() {
        return seqNb;
    }

    /**
     * Sets the value of the seqNb property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public AutomatedTellerMachine5 setSeqNb(String value) {
        this.seqNb = value;
        return this;
    }

    /**
     * Gets the value of the baseCcy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBaseCcy() {
        return baseCcy;
    }

    /**
     * Sets the value of the baseCcy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public AutomatedTellerMachine5 setBaseCcy(String value) {
        this.baseCcy = value;
        return this;
    }

    /**
     * Gets the value of the lctn property.
     * 
     * @return
     *     possible object is
     *     {@link PostalAddress17 }
     *     
     */
    public PostalAddress17 getLctn() {
        return lctn;
    }

    /**
     * Sets the value of the lctn property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostalAddress17 }
     *     
     */
    public AutomatedTellerMachine5 setLctn(PostalAddress17 value) {
        this.lctn = value;
        return this;
    }

    /**
     * Gets the value of the lctnCtgy property.
     * 
     * @return
     *     possible object is
     *     {@link TransactionEnvironment2Code }
     *     
     */
    public TransactionEnvironment2Code getLctnCtgy() {
        return lctnCtgy;
    }

    /**
     * Sets the value of the lctnCtgy property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransactionEnvironment2Code }
     *     
     */
    public AutomatedTellerMachine5 setLctnCtgy(TransactionEnvironment2Code value) {
        this.lctnCtgy = value;
        return this;
    }

    /**
     * Gets the value of the eqpmnt property.
     * 
     * @return
     *     possible object is
     *     {@link ATMEquipment1 }
     *     
     */
    public ATMEquipment1 getEqpmnt() {
        return eqpmnt;
    }

    /**
     * Sets the value of the eqpmnt property.
     * 
     * @param value
     *     allowed object is
     *     {@link ATMEquipment1 }
     *     
     */
    public AutomatedTellerMachine5 setEqpmnt(ATMEquipment1 value) {
        this.eqpmnt = value;
        return this;
    }

    /**
     * Gets the value of the outOfSvcDvc property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the outOfSvcDvc property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOutOfSvcDvc().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ATMDevice2Code }
     * 
     * 
     * @return
     *     The value of the outOfSvcDvc property.
     */
    public List<ATMDevice2Code> getOutOfSvcDvc() {
        if (outOfSvcDvc == null) {
            outOfSvcDvc = new ArrayList<>();
        }
        return this.outOfSvcDvc;
    }

    /**
     * Gets the value of the msgPrtcn property.
     * 
     * @return
     *     possible object is
     *     {@link MessageProtection1Code }
     *     
     */
    public MessageProtection1Code getMsgPrtcn() {
        return msgPrtcn;
    }

    /**
     * Sets the value of the msgPrtcn property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageProtection1Code }
     *     
     */
    public AutomatedTellerMachine5 setMsgPrtcn(MessageProtection1Code value) {
        this.msgPrtcn = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the outOfSvcDvc list.
     * @see #getOutOfSvcDvc()
     * 
     */
    public AutomatedTellerMachine5 addOutOfSvcDvc(ATMDevice2Code outOfSvcDvc) {
        getOutOfSvcDvc().add(outOfSvcDvc);
        return this;
    }

}
