/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.DefaultMxMetadataStrategy;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

@Entity(name="mx")
@DiscriminatorValue(value="mx")
public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = -4394356007627575831L;
    private static final transient Logger log = Logger.getLogger(MxSwiftMessage.class.getName());
    @Enumerated(value=EnumType.STRING)
    @Column(length=4, name="business_process")
    private MxBusinessProcess businessProcess;
    @Column(length=3)
    private String functionality;
    @Column(length=3)
    private String variant;
    @Column(length=2)
    private String version;

    public MxSwiftMessage() {
    }

    public MxSwiftMessage(String xml) {
        this(xml, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(String xml, MessageMetadataStrategy metadataStrategy) {
        super(xml, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(InputStream stream) throws IOException {
        this(stream, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(InputStream stream, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(stream, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(File file) throws IOException {
        this(file, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(File file, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(file, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(AbstractMX mx) {
        this(mx, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(AbstractMX mx, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(mx, "the message model cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.setMessage(mx.message());
        this._updateFromMessage(mx.getMxId(), metadataStrategy);
    }

    public static MxSwiftMessage parse(String xml) {
        return new MxSwiftMessage(xml);
    }

    public static MxSwiftMessage parse(InputStream stream) throws IOException {
        return new MxSwiftMessage(stream);
    }

    public static MxSwiftMessage parse(File file) throws IOException {
        return new MxSwiftMessage(file);
    }

    public static MxSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MxSwiftMessage)((Object)gson.fromJson(json, MxSwiftMessage.class));
    }

    protected void updateFromMessage() {
        this._updateFromMessage(null, new DefaultMxMetadataStrategy());
    }

    protected void updateFromMessage(MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this._updateFromMessage(null, metadataStrategy);
    }

    private void _updateFromMessage(MxId id, MessageMetadataStrategy metadataStrategy) {
        if (this.message() != null && !this.message().isEmpty()) {
            MxId identifier = id != null ? id : (MxId)MxParseUtils.identifyMessage(this.message()).orElse(null);
            AppHdr header = this.getAppHdr();
            if (identifier == null && header != null && header.messageName() != null) {
                identifier = new MxId(header.messageName());
            }
            this.extractMetadata(identifier, header, metadataStrategy);
        }
    }

    public void updateFromModel(AbstractMX mx) {
        this.updateFromModel(mx, new DefaultMxMetadataStrategy());
    }

    public void updateFromModel(AbstractMX mx, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(mx, "the mx parameter cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.setMessage(mx.message());
        this.setFileFormat(FileFormat.MX);
        this.extractMetadata(mx.getMxId(), mx.getAppHdr(), metadataStrategy);
    }

    private void extractMetadata(MxId identifier, AppHdr headerModel, MessageMetadataStrategy metadataStrategy) {
        String lenientXml = MxParseUtils.makeXmlLenient(this.message());
        MxNode parsedMessage = MxNode.parse(lenientXml);
        if (headerModel == null || !this.extractMetadata(headerModel)) {
            this.extractMetadata(parsedMessage);
        }
        if (identifier != null) {
            this.identifier = identifier.id();
            this.businessProcess = identifier.getBusinessProcess();
            this.functionality = identifier.getFunctionality();
            this.variant = identifier.getVariant();
            this.version = identifier.getVersion();
        }
        this.applyStrategy(lenientXml, metadataStrategy);
    }

    private boolean extractMetadata(AppHdr h) {
        boolean updated = false;
        if (h != null) {
            String to;
            String from = h.from();
            if (from != null) {
                this.sender = this.bic11(from);
                updated = true;
            }
            if ((to = h.to()) != null) {
                this.receiver = this.bic11(to);
                updated = true;
            }
        }
        return updated;
    }

    private boolean extractMetadata(MxNode n) {
        MxNode groupHeader;
        boolean updated = false;
        MxNode mxNode = groupHeader = n != null ? n.findFirstByName("GrpHdr") : null;
        if (groupHeader != null) {
            MxNode receiverBic;
            MxNode senderBic = groupHeader.findFirst("./InstgAgt/FinInstnId/BIC");
            if (senderBic != null) {
                this.sender = this.bic11(senderBic.getValue());
                updated = true;
            }
            if ((receiverBic = groupHeader.findFirst("./InstdAgt/FinInstnId/BIC")) != null) {
                this.receiver = this.bic11(receiverBic.getValue());
                updated = true;
            }
        }
        if (!updated) {
            MxNode requestHeader;
            MxNode mxNode2 = requestHeader = n != null ? n.findFirstByName("RequestHeader") : null;
            if (requestHeader != null) {
                String responderBICString;
                MxNode responder;
                String requestorBicString;
                MxNode requestor = requestHeader.findFirstByName("Requestor");
                if (requestor != null && requestor.getValue() != null && (requestorBicString = MxParseUtils.getBICFromDN(requestor.getValue())) != null) {
                    BIC requestorBic = new BIC(requestorBicString);
                    this.sender = requestorBic.getBic11();
                    updated = true;
                }
                if ((responder = requestHeader.findFirstByName("Responder")) != null && responder.getValue() != null && (responderBICString = MxParseUtils.getBICFromDN(responder.getValue())) != null) {
                    BIC responderBIC = new BIC(responderBICString);
                    this.receiver = responderBIC.getBic11();
                    updated = true;
                }
            }
        }
        return updated;
    }

    public void updateFromXML(String xml) {
        this.updateFromXML(xml, null);
    }

    public void updateFromXML(String xml, MxId id) {
        this.updateFromXML(xml, id, new DefaultMxMetadataStrategy());
    }

    public void updateFromXML(String xml, MxId id, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(xml, "the xml message parameter cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.setMessage(xml);
        this.setFileFormat(FileFormat.MX);
        this._updateFromMessage(id, metadataStrategy);
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MxSwiftMessage that = (MxSwiftMessage)((Object)o);
        return this.businessProcess == that.businessProcess && Objects.equals(this.functionality, that.functionality) && Objects.equals(this.variant, that.variant) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.businessProcess, this.functionality, this.variant, this.version});
    }

    public AppHdr getAppHdr() {
        return AppHdrParser.parse(this.message()).orElse(null);
    }

    public void copyTo(MxSwiftMessage msg) {
        super.copyTo((AbstractSwiftMessage)msg);
        msg.setBusinessProcess(this.getBusinessProcess());
        msg.setFunctionality(this.getFunctionality());
        msg.setVariant(this.getVariant());
        msg.setVersion(this.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MxSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public MxId getMxId() {
        return new MxId(this.businessProcess, this.functionality, this.variant, this.version);
    }

    public String getCategory() {
        MxBusinessProcess proc;
        if (!StringUtils.isBlank((CharSequence)this.identifier) && (proc = new MxId(this.identifier).getBusinessProcess()) != null) {
            return proc.name();
        }
        return "";
    }

    public void updateMetadata(MessageMetadataStrategy strategy) {
        Objects.requireNonNull(strategy, "the strategy for metadata extraction cannot be null");
        this.applyStrategy(MxParseUtils.makeXmlLenient(this.message()), strategy);
    }

    private void applyStrategy(String lenientXml, MessageMetadataStrategy strategy) {
        Optional money;
        boolean isKnownType = this.businessProcess != null && this.functionality != null && this.variant != null && this.version != null;
        MxId mxId = isKnownType ? this.getMxId() : null;
        MxReadParams params = new MxReadParams();
        params.verbose = false;
        AbstractMX mx = MxReadImpl.parse(lenientXml, mxId, params);
        if (mx == null) {
            return;
        }
        String reference = strategy.reference((AbstractMessage)mx).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            this.setReference(reference);
        }
        if ((money = strategy.amount((AbstractMessage)mx)).isPresent()) {
            this.setCurrency(((Money)money.get()).getCurrency());
            this.setAmount(((Money)money.get()).getAmount());
        }
        strategy.valueDate((AbstractMessage)mx).ifPresent(arg_0 -> ((MxSwiftMessage)this).setValueDate(arg_0));
        strategy.tradeDate((AbstractMessage)mx).ifPresent(arg_0 -> ((MxSwiftMessage)this).setTradeDate(arg_0));
        strategy.sender((AbstractMessage)mx).ifPresent(arg_0 -> ((MxSwiftMessage)this).setSender(arg_0));
        strategy.receiver((AbstractMessage)mx).ifPresent(arg_0 -> ((MxSwiftMessage)this).setReceiver(arg_0));
        strategy.identifier((AbstractMessage)mx).ifPresent(arg_0 -> ((MxSwiftMessage)this).setIdentifier(arg_0));
    }
}

