/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field70D
extends Field
implements Serializable,
GenericField,
MultiLineField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "70D";
    public static final String F_70D = "70D";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S[$S]0-5";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSSSS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSSSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer NARRATIVE = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field70D() {
        super(7);
    }

    public Field70D(String value) {
        super(value);
    }

    public Field70D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"70D")) {
            throw new IllegalArgumentException("cannot create field 70D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field70D newInstance(Field70D source) {
        Field70D cp = new Field70D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("70D", value);
    }

    public static Tag emptyTag() {
        return new Tag("70D", "");
    }

    @Override
    public void parse(String value) {
        this.init(7);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), ":", "//"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), "//"));
        }
        SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.appendInLines(result, 3, 7);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 7) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 70D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSSSSSS";
    }

    @Override
    public String typesPattern() {
        return "SSSSSSS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//35x[$35x]0-5";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        if (component == 6) {
            return true;
        }
        return component == 7;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 7;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        result.add("Narrative 5");
        result.add("Narrative 6");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "narrative");
        result.put(3, "narrative2");
        result.put(4, "narrative3");
        result.put(5, "narrative4");
        result.put(6, "narrative5");
        result.put(7, "narrative6");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("narrative", 2);
        this.labelMap.put("narrative2", 3);
        this.labelMap.put("narrative3", 4);
        this.labelMap.put("narrative4", 5);
        this.labelMap.put("narrative5", 6);
        this.labelMap.put("narrative6", 7);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine1() {
        return this.getComponent2();
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 8; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine2() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine3() {
        return this.getComponent4();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getNarrativeLine4() {
        return this.getComponent5();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getNarrativeLine5() {
        return this.getComponent6();
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public String getNarrativeLine6() {
        return this.getComponent7();
    }

    public Field70D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field70D setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field70D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field70D setNarrativeLine1(String component2) {
        return this.setComponent2(component2);
    }

    public Field70D setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 6, 0, lines);
        return this;
    }

    public Field70D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field70D setNarrativeLine2(String component3) {
        return this.setComponent3(component3);
    }

    public Field70D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field70D setNarrativeLine3(String component4) {
        return this.setComponent4(component4);
    }

    public Field70D setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field70D setNarrativeLine4(String component5) {
        return this.setComponent5(component5);
    }

    public Field70D setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field70D setNarrativeLine5(String component6) {
        return this.setComponent6(component6);
    }

    public Field70D setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field70D setNarrativeLine6(String component7) {
        return this.setComponent7(component7);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "70D";
    }

    public static Field70D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("70D");
        if (t == null) {
            return null;
        }
        return new Field70D(t);
    }

    public static Field70D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field70D.get(msg.getBlock4());
    }

    public static List<Field70D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field70D.getAll(msg.getBlock4());
    }

    public static List<Field70D> getAll(SwiftTagListBlock block) {
        ArrayList<Field70D> result = new ArrayList<Field70D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("70D");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field70D(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field70D cp = Field70D.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field70D cp = Field70D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field70D cp = Field70D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field70D fromJson(String json) {
        Field70D field = new Field70D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent3(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent4(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent5(jsonObject.get("narrative4").getAsString());
        }
        if (jsonObject.get("narrative5") != null) {
            field.setComponent6(jsonObject.get("narrative5").getAsString());
        }
        if (jsonObject.get("narrative6") != null) {
            field.setComponent7(jsonObject.get("narrative6").getAsString());
        }
        return field;
    }
}

