/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt3xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field15A;
import com.prowidesoftware.swift.model.field.Field15B;
import com.prowidesoftware.swift.model.field.Field15E;
import com.prowidesoftware.swift.model.field.Field15J;
import com.prowidesoftware.swift.model.field.Field15K;
import com.prowidesoftware.swift.model.field.Field15L;
import com.prowidesoftware.swift.model.field.Field15M;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21B;
import com.prowidesoftware.swift.model.field.Field21N;
import com.prowidesoftware.swift.model.field.Field22A;
import com.prowidesoftware.swift.model.field.Field22B;
import com.prowidesoftware.swift.model.field.Field22C;
import com.prowidesoftware.swift.model.field.Field22D;
import com.prowidesoftware.swift.model.field.Field23A;
import com.prowidesoftware.swift.model.field.Field29A;
import com.prowidesoftware.swift.model.field.Field30F;
import com.prowidesoftware.swift.model.field.Field30P;
import com.prowidesoftware.swift.model.field.Field30Q;
import com.prowidesoftware.swift.model.field.Field30T;
import com.prowidesoftware.swift.model.field.Field30V;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32G;
import com.prowidesoftware.swift.model.field.Field32M;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field33E;
import com.prowidesoftware.swift.model.field.Field37G;
import com.prowidesoftware.swift.model.field.Field37M;
import com.prowidesoftware.swift.model.field.Field37N;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field82A;
import com.prowidesoftware.swift.model.field.Field82D;
import com.prowidesoftware.swift.model.field.Field83A;
import com.prowidesoftware.swift.model.field.Field83D;
import com.prowidesoftware.swift.model.field.Field83J;
import com.prowidesoftware.swift.model.field.Field86A;
import com.prowidesoftware.swift.model.field.Field86D;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.field.Field94A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT365
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT365.class.getName());
    public static final String NAME = "365";

    public MT365(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT365(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT365 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT365(m);
    }

    public MT365() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT365(String sender, String receiver) {
        super(365, sender, receiver);
    }

    public MT365(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT365.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT365 object from FIN content with a Service Message. Check if the MT365 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT365 object from FIN content with message type " + param.getType());
        }
    }

    public static MT365 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT365(fin);
    }

    public MT365(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT365 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT365(stream);
    }

    public MT365(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT365 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT365(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT365 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT365 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT365 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT365 fromJson(String json) {
        return (MT365)AbstractMT.fromJson(json);
    }

    public Field15A getField15A() {
        Tag t = this.tag("15A");
        if (t != null) {
            return new Field15A(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field22A getField22A() {
        Tag t = this.tag("22A");
        if (t != null) {
            return new Field22A(t.getValue());
        }
        return null;
    }

    public Field94A getField94A() {
        Tag t = this.tag("94A");
        if (t != null) {
            return new Field94A(t.getValue());
        }
        return null;
    }

    public Field22B getField22B() {
        Tag t = this.tag("22B");
        if (t != null) {
            return new Field22B(t.getValue());
        }
        return null;
    }

    public Field22C getField22C() {
        Tag t = this.tag("22C");
        if (t != null) {
            return new Field22C(t.getValue());
        }
        return null;
    }

    public Field23A getField23A() {
        Tag t = this.tag("23A");
        if (t != null) {
            return new Field23A(t.getValue());
        }
        return null;
    }

    public Field21N getField21N() {
        Tag t = this.tag("21N");
        if (t != null) {
            return new Field21N(t.getValue());
        }
        return null;
    }

    public Field21B getField21B() {
        Tag t = this.tag("21B");
        if (t != null) {
            return new Field21B(t.getValue());
        }
        return null;
    }

    public Field30T getField30T() {
        Tag t = this.tag("30T");
        if (t != null) {
            return new Field30T(t.getValue());
        }
        return null;
    }

    public Field30Q getField30Q() {
        Tag t = this.tag("30Q");
        if (t != null) {
            return new Field30Q(t.getValue());
        }
        return null;
    }

    public Field30P getField30P() {
        Tag t = this.tag("30P");
        if (t != null) {
            return new Field30P(t.getValue());
        }
        return null;
    }

    public Field30V getField30V() {
        Tag t = this.tag("30V");
        if (t != null) {
            return new Field30V(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field33B getField33B() {
        Tag t = this.tag("33B");
        if (t != null) {
            return new Field33B(t.getValue());
        }
        return null;
    }

    public Field82A getField82A() {
        Tag t = this.tag("82A");
        if (t != null) {
            return new Field82A(t.getValue());
        }
        return null;
    }

    public Field82D getField82D() {
        Tag t = this.tag("82D");
        if (t != null) {
            return new Field82D(t.getValue());
        }
        return null;
    }

    public Field87A getField87A() {
        Tag t = this.tag("87A");
        if (t != null) {
            return new Field87A(t.getValue());
        }
        return null;
    }

    public Field87D getField87D() {
        Tag t = this.tag("87D");
        if (t != null) {
            return new Field87D(t.getValue());
        }
        return null;
    }

    public Field83A getField83A() {
        Tag t = this.tag("83A");
        if (t != null) {
            return new Field83A(t.getValue());
        }
        return null;
    }

    public Field83D getField83D() {
        Tag t = this.tag("83D");
        if (t != null) {
            return new Field83D(t.getValue());
        }
        return null;
    }

    public Field83J getField83J() {
        Tag t = this.tag("83J");
        if (t != null) {
            return new Field83J(t.getValue());
        }
        return null;
    }

    public Field22D getField22D() {
        Tag t = this.tag("22D");
        if (t != null) {
            return new Field22D(t.getValue());
        }
        return null;
    }

    public Field32G getField32G() {
        Tag t = this.tag("32G");
        if (t != null) {
            return new Field32G(t.getValue());
        }
        return null;
    }

    public Field33E getField33E() {
        Tag t = this.tag("33E");
        if (t != null) {
            return new Field33E(t.getValue());
        }
        return null;
    }

    public Field37N getField37N() {
        Tag t = this.tag("37N");
        if (t != null) {
            return new Field37N(t.getValue());
        }
        return null;
    }

    public Field29A getField29A() {
        Tag t = this.tag("29A");
        if (t != null) {
            return new Field29A(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public Field15B getField15B() {
        Tag t = this.tag("15B");
        if (t != null) {
            return new Field15B(t.getValue());
        }
        return null;
    }

    public Field15E getField15E() {
        Tag t = this.tag("15E");
        if (t != null) {
            return new Field15E(t.getValue());
        }
        return null;
    }

    public Field15J getField15J() {
        Tag t = this.tag("15J");
        if (t != null) {
            return new Field15J(t.getValue());
        }
        return null;
    }

    public Field15K getField15K() {
        Tag t = this.tag("15K");
        if (t != null) {
            return new Field15K(t.getValue());
        }
        return null;
    }

    public Field15L getField15L() {
        Tag t = this.tag("15L");
        if (t != null) {
            return new Field15L(t.getValue());
        }
        return null;
    }

    public Field15M getField15M() {
        Tag t = this.tag("15M");
        if (t != null) {
            return new Field15M(t.getValue());
        }
        return null;
    }

    public List<Field37M> getField37M() {
        ArrayList<Field37M> result = new ArrayList<Field37M>();
        Tag[] tags = this.tags("37M");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field37M(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field37G> getField37G() {
        ArrayList<Field37G> result = new ArrayList<Field37G>();
        Tag[] tags = this.tags("37G");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field37G(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30F> getField30F() {
        ArrayList<Field30F> result = new ArrayList<Field30F>();
        Tag[] tags = this.tags("30F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32M> getField32M() {
        ArrayList<Field32M> result = new ArrayList<Field32M>();
        Tag[] tags = this.tags("32M");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32M(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field53A> getField53A() {
        ArrayList<Field53A> result = new ArrayList<Field53A>();
        Tag[] tags = this.tags("53A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field53A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field53D> getField53D() {
        ArrayList<Field53D> result = new ArrayList<Field53D>();
        Tag[] tags = this.tags("53D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field53D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86A> getField86A() {
        ArrayList<Field86A> result = new ArrayList<Field86A>();
        Tag[] tags = this.tags("86A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86D> getField86D() {
        ArrayList<Field86D> result = new ArrayList<Field86D>();
        Tag[] tags = this.tags("86D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57D(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("A")) {
            return new SequenceA(map.get("A"));
        }
        return new SequenceA();
    }

    public SequenceB getSequenceB() {
        return this.getSequenceB(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("B")) {
            return new SequenceB(map.get("B"));
        }
        return new SequenceB();
    }

    public SequenceE getSequenceE() {
        return this.getSequenceE(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceE getSequenceE(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("E")) {
            return new SequenceE(map.get("E"));
        }
        return new SequenceE();
    }

    public SequenceJ getSequenceJ() {
        return this.getSequenceJ(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceJ getSequenceJ(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("J")) {
            return new SequenceJ(map.get("J"));
        }
        return new SequenceJ();
    }

    public SequenceK getSequenceK() {
        return this.getSequenceK(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceK getSequenceK(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("K")) {
            return new SequenceK(map.get("K"));
        }
        return new SequenceK();
    }

    public SequenceL getSequenceL() {
        return this.getSequenceL(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceL getSequenceL(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("L")) {
            return new SequenceL(map.get("L"));
        }
        return new SequenceL();
    }

    public SequenceM getSequenceM() {
        return this.getSequenceM(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceM getSequenceM(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("M")) {
            return new SequenceM(map.get("M"));
        }
        return new SequenceM();
    }

    public static class SequenceM
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15M.emptyTag();

        private SequenceM() {
            super(new ArrayList<Tag>());
        }

        private SequenceM(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceM newInstance(Tag ... tags) {
            SequenceM result = new SequenceM();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceM newInstance() {
            SequenceM result = new SequenceM();
            result.append(START_TAG);
            return result;
        }

        public static SequenceM newInstance(SwiftTagListBlock ... sequences) {
            SequenceM result = new SequenceM();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceL
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15L.emptyTag();

        private SequenceL() {
            super(new ArrayList<Tag>());
        }

        private SequenceL(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceL newInstance(Tag ... tags) {
            SequenceL result = new SequenceL();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceL newInstance() {
            SequenceL result = new SequenceL();
            result.append(START_TAG);
            return result;
        }

        public static SequenceL newInstance(SwiftTagListBlock ... sequences) {
            SequenceL result = new SequenceL();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceK
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15K.emptyTag();

        private SequenceK() {
            super(new ArrayList<Tag>());
        }

        private SequenceK(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceK newInstance(Tag ... tags) {
            SequenceK result = new SequenceK();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceK newInstance() {
            SequenceK result = new SequenceK();
            result.append(START_TAG);
            return result;
        }

        public static SequenceK newInstance(SwiftTagListBlock ... sequences) {
            SequenceK result = new SequenceK();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceJ
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15J.emptyTag();

        private SequenceJ() {
            super(new ArrayList<Tag>());
        }

        private SequenceJ(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceJ newInstance(Tag ... tags) {
            SequenceJ result = new SequenceJ();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceJ newInstance() {
            SequenceJ result = new SequenceJ();
            result.append(START_TAG);
            return result;
        }

        public static SequenceJ newInstance(SwiftTagListBlock ... sequences) {
            SequenceJ result = new SequenceJ();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceE
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15E.emptyTag();

        private SequenceE() {
            super(new ArrayList<Tag>());
        }

        private SequenceE(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceE newInstance(Tag ... tags) {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceE newInstance() {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            return result;
        }

        public static SequenceE newInstance(SwiftTagListBlock ... sequences) {
            SequenceE result = new SequenceE();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15B.emptyTag();

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15A.emptyTag();

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }
}

