/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field77E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT498
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT498.class.getName());
    public static final String NAME = "498";

    public MT498(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT498(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT498 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT498(m);
    }

    public MT498() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT498(String sender, String receiver) {
        super(498, sender, receiver);
    }

    public MT498(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT498.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT498 object from FIN content with a Service Message. Check if the MT498 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT498 object from FIN content with message type " + param.getType());
        }
    }

    public static MT498 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT498(fin);
    }

    public MT498(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT498 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT498(stream);
    }

    public MT498(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT498 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT498(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT498 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT498 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT498 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT498 fromJson(String json) {
        return (MT498)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field12 getField12() {
        Tag t = this.tag("12");
        if (t != null) {
            return new Field12(t.getValue());
        }
        return null;
    }

    public Field77E getField77E() {
        Tag t = this.tag("77E");
        if (t != null) {
            return new Field77E(t.getValue());
        }
        return null;
    }
}

