/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field77E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT798
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT798.class.getName());
    public static final String NAME = "798";

    public MT798(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT798(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT798 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT798(m);
    }

    public MT798() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT798(String sender, String receiver) {
        super(798, sender, receiver);
    }

    public MT798(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT798.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT798 object from FIN content with a Service Message. Check if the MT798 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT798 object from FIN content with message type " + param.getType());
        }
    }

    public static MT798 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT798(fin);
    }

    public MT798(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT798 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT798(stream);
    }

    public MT798(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT798 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT798(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT798 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT798 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT798 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT798 fromJson(String json) {
        return (MT798)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field12 getField12() {
        Tag t = this.tag("12");
        if (t != null) {
            return new Field12(t.getValue());
        }
        return null;
    }

    public Field77E getField77E() {
        Tag t = this.tag("77E");
        if (t != null) {
            return new Field77E(t.getValue());
        }
        return null;
    }

    public SwiftMessage getSubMessage() {
        Field12 field12 = this.getField12();
        if (field12 == null) {
            return null;
        }
        SwiftMessage result = new SwiftMessage(true);
        if (this.m.getBlock1() != null) {
            result.getBlock1().setValue(this.m.getBlock1().getValue());
        }
        if (this.m.getBlock2() != null) {
            SwiftBlock2 newBlock2;
            Object currentBlock2;
            if (this.m.isInput()) {
                currentBlock2 = (SwiftBlock2Input)this.m.getBlock2();
                newBlock2 = new SwiftBlock2Input(((SwiftBlock2Input)currentBlock2).getValue());
                ((SwiftBlock2Input)newBlock2).setMessageType(field12.getValue());
                result.setBlock2(newBlock2);
            } else {
                currentBlock2 = (SwiftBlock2Output)this.m.getBlock2();
                newBlock2 = new SwiftBlock2Output(((SwiftBlock2Output)currentBlock2).getValue());
                newBlock2.setMessageType(field12.getValue());
                result.setBlock2(newBlock2);
            }
        }
        if (this.m.getBlock3() != null) {
            for (Tag tag : this.m.getBlock3().getTags()) {
                result.getBlock3().append(new Tag(tag));
            }
        }
        if (this.m.getBlock4() != null) {
            boolean found77E = false;
            for (Tag tag : this.m.getBlock4().getTags()) {
                if (found77E) {
                    result.getBlock4().append(new Tag(tag));
                }
                if (!"77E".equals(tag.getName())) continue;
                found77E = true;
            }
        }
        return result;
    }
}

