/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.mt.mt5xx.MT535;
import com.prowidesoftware.swift.model.mt.mt5xx.MT536;
import com.prowidesoftware.swift.model.mt.mt5xx.MT537;
import com.prowidesoftware.swift.model.mt.mt5xx.MT538;
import com.prowidesoftware.swift.model.mt.mt5xx.MT548;
import com.prowidesoftware.swift.model.mt.mt5xx.MT564;
import com.prowidesoftware.swift.model.mt.mt5xx.MT566;
import com.prowidesoftware.swift.model.mt.mt5xx.MT575;
import com.prowidesoftware.swift.model.mt.mt5xx.MT576;
import com.prowidesoftware.swift.model.mt.mt5xx.MT586;
import com.prowidesoftware.swift.model.mt.mt6xx.MT670;
import com.prowidesoftware.swift.model.mt.mt6xx.MT671;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SequenceUtils {
    private SequenceUtils() {
        throw new AssertionError();
    }

    public static List<MT535.SequenceB1b1> resolveMT535GetSequenceB1b1List_sru2024(MT535 mt) {
        ArrayList<MT535.SequenceB1b1> result = new ArrayList<MT535.SequenceB1b1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB1bList(), "BREAK")) {
            MT535.SequenceB1b1 s = MT535.SequenceB1b1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT535.SequenceB1c> resolveMT535GetSequenceB1cList_sru2024(MT535 mt) {
        ArrayList<MT535.SequenceB1c> result = new ArrayList<MT535.SequenceB1c>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB1List(), "BREAK")) {
            MT535.SequenceB1c s = MT535.SequenceB1c.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT536.SequenceA1> resolveMT536GetSequenceA1List_sru2024(MT536 mt) {
        ArrayList<MT536.SequenceA1> result = new ArrayList<MT536.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT536.SequenceA1 s = MT536.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT536.SequenceB1a1> resolveMT536GetSequenceB1a1List_sru2024(MT536 mt) {
        ArrayList<MT536.SequenceB1a1> result = new ArrayList<MT536.SequenceB1a1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB1aList(), "LINK")) {
            MT536.SequenceB1a1 s = MT536.SequenceB1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceA1> resolveMT537GetSequenceA1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceA1> result = new ArrayList<MT537.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT537.SequenceA1 s = MT537.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB> resolveMT537GetSequenceBList_sru2024(MT537 mt) {
        return SequenceUtils.resolveMT537GetSequenceBList_sru2024(mt.getSwiftMessage().getBlock4());
    }

    public static List<MT537.SequenceB> resolveMT537GetSequenceBList_sru2024(SwiftTagListBlock mt) {
        Objects.requireNonNull(mt);
        ArrayList<MT537.SequenceB> result = new ArrayList<MT537.SequenceB>();
        List<SwiftTagListBlock> raw = mt.getSubBlockBeforeFirst(Field16R.tag("TRANS"), false).getSubBlockBeforeFirst(Field16R.tag("PENA"), false).getSubBlocks("STAT");
        if (raw == null) {
            return null;
        }
        for (SwiftTagListBlock swiftTagListBlock : raw) {
            MT537.SequenceB sequenceB = MT537.SequenceB.newInstance();
            sequenceB.getTags().clear();
            sequenceB.append(swiftTagListBlock);
            result.add(sequenceB);
        }
        return result;
    }

    public static List<MT537.SequenceB1> resolveMT537GetSequenceB1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceB1> result = new ArrayList<MT537.SequenceB1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceBList(), "REAS")) {
            MT537.SequenceB1 s = MT537.SequenceB1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2> resolveMT537GetSequenceB2List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceB2> result = new ArrayList<MT537.SequenceB2>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceBList(), "TRAN")) {
            MT537.SequenceB2 s = MT537.SequenceB2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2a> resolveMT537GetSequenceB2aList_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceB2a> result = new ArrayList<MT537.SequenceB2a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB2List(), "LINK")) {
            MT537.SequenceB2a s = MT537.SequenceB2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2b> resolveMT537GetSequenceB2bList_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceB2b> result = new ArrayList<MT537.SequenceB2b>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB2List(), "TRANSDET")) {
            MT537.SequenceB2b s = MT537.SequenceB2b.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2b1> resolveMT537GetSequenceB2b1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceB2b1> result = new ArrayList<MT537.SequenceB2b1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB2bList(), "SETPRTY")) {
            MT537.SequenceB2b1 s = MT537.SequenceB2b1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC1> resolveMT537GetSequenceC1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceC1> result = new ArrayList<MT537.SequenceC1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceCList(), "LINK")) {
            MT537.SequenceC1 s = MT537.SequenceC1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC2> resolveMT537GetSequenceC2List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceC2> result = new ArrayList<MT537.SequenceC2>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceCList(), "TRANSDET")) {
            MT537.SequenceC2 s = MT537.SequenceC2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC2a> resolveMT537GetSequenceC2aList_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceC2a> result = new ArrayList<MT537.SequenceC2a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceC2List(), "SETPRTY")) {
            MT537.SequenceC2a s = MT537.SequenceC2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC3> resolveMT537GetSequenceC3List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceC3> result = new ArrayList<MT537.SequenceC3>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceCList(), "STAT")) {
            MT537.SequenceC3 s = MT537.SequenceC3.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC3a> resolveMT537GetSequenceC3aList_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceC3a> result = new ArrayList<MT537.SequenceC3a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceC3List(), "REAS")) {
            MT537.SequenceC3a s = MT537.SequenceC3a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceD1a1B1> resolveMT537GetSequenceD1a1B1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceD1a1B1> result = new ArrayList<MT537.SequenceD1a1B1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceD1a1BList(), "TRAN")) {
            MT537.SequenceD1a1B1 s = MT537.SequenceD1a1B1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceD1a1B1a> resolveMT537GetSequenceD1a1B1aList_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceD1a1B1a> result = new ArrayList<MT537.SequenceD1a1B1a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceD1a1B1List(), "STAT")) {
            MT537.SequenceD1a1B1a s = MT537.SequenceD1a1B1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceD1a1B1a1> resolveMT537GetSequenceD1a1B1a1List_sru2024(MT537 mt) {
        ArrayList<MT537.SequenceD1a1B1a1> result = new ArrayList<MT537.SequenceD1a1B1a1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceD1a1B1aList(), "REAS")) {
            MT537.SequenceD1a1B1a1 s = MT537.SequenceD1a1B1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT538.SequenceA1> resolveMT538GetSequenceA1List_sru2024(MT538 mt) {
        ArrayList<MT538.SequenceA1> result = new ArrayList<MT538.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT538.SequenceA1 s = MT538.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT538.SequenceB2a1> resolveMT538GetSequenceB2a1List_sru2024(MT538 mt) {
        ArrayList<MT538.SequenceB2a1> result = new ArrayList<MT538.SequenceB2a1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB2aList(), "LINK")) {
            MT538.SequenceB2a1 s = MT538.SequenceB2a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT548.SequenceA2> resolveMT548GetSequenceA2List_sru2024(MT548 mt) {
        ArrayList<MT548.SequenceA2> result = new ArrayList<MT548.SequenceA2>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "STAT")) {
            MT548.SequenceA2 s = MT548.SequenceA2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT548.SequenceA2a> resolveMT548GetSequenceA2aList_sru2024(MT548 mt) {
        ArrayList<MT548.SequenceA2a> result = new ArrayList<MT548.SequenceA2a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA2List(), "REAS")) {
            MT548.SequenceA2a s = MT548.SequenceA2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT548.SequenceC1a1B1a> resolveMT548GetSequenceC1a1B1aList_sru2024(MT548 mt) {
        ArrayList<MT548.SequenceC1a1B1a> result = new ArrayList<MT548.SequenceC1a1B1a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceC1a1B1List(), "STAT")) {
            MT548.SequenceC1a1B1a s = MT548.SequenceC1a1B1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT548.SequenceC1a1B1a1> resolveMT548GetSequenceC1a1B1a1List_sru2024(MT548 mt) {
        ArrayList<MT548.SequenceC1a1B1a1> result = new ArrayList<MT548.SequenceC1a1B1a1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceC1a1B1aList(), "REAS")) {
            MT548.SequenceC1a1B1a1 s = MT548.SequenceC1a1B1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT564.SequenceB1 resolveMT564GetSequenceB1_sru2024(MT564 mt) {
        Objects.requireNonNull(mt);
        MT564.SequenceB1 result = MT564.SequenceB1.newInstance();
        result.clear().append(mt.getSequenceB().getSubBlock("FIA"));
        return result;
    }

    public static List<MT564.SequenceE1a> resolveMT564GetSequenceE1aList_sru2024(MT564 mt) {
        ArrayList<MT564.SequenceE1a> result = new ArrayList<MT564.SequenceE1a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceE1List(), "FIA")) {
            MT564.SequenceE1a s = MT564.SequenceE1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT566.SequenceB1 resolveMT566GetSequenceB1_sru2024(MT566 mt) {
        Objects.requireNonNull(mt);
        MT566.SequenceB1 result = MT566.SequenceB1.newInstance();
        result.clear().append(mt.getSequenceB().getSubBlock("FIA"));
        return result;
    }

    public static List<MT566.SequenceD1a> resolveMT566GetSequenceD1aList_sru2024(MT566 mt) {
        ArrayList<MT566.SequenceD1a> result = new ArrayList<MT566.SequenceD1a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceD1List(), "FIA")) {
            MT566.SequenceD1a s = MT566.SequenceD1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceA1> resolveMT575GetSequenceA1List_sru2024(MT575 mt) {
        ArrayList<MT575.SequenceA1> result = new ArrayList<MT575.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT575.SequenceA1 s = MT575.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceB1a1> resolveMT575GetSequenceB1a1List_sru2024(MT575 mt) {
        ArrayList<MT575.SequenceB1a1> result = new ArrayList<MT575.SequenceB1a1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB1aList(), "LINK")) {
            MT575.SequenceB1a1 s = MT575.SequenceB1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceB1a4> resolveMT575GetSequenceB1a4List_sru2024(MT575 mt) {
        ArrayList<MT575.SequenceB1a4> result = new ArrayList<MT575.SequenceB1a4>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB1aList(), "SETPRTY")) {
            MT575.SequenceB1a4 s = MT575.SequenceB1a4.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceC1> resolveMT575GetSequenceC1List_sru2024(MT575 mt) {
        ArrayList<MT575.SequenceC1> result = new ArrayList<MT575.SequenceC1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceCList(), "LINK")) {
            MT575.SequenceC1 s = MT575.SequenceC1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceC2a> resolveMT575GetSequenceC2aList_sru2024(MT575 mt) {
        ArrayList<MT575.SequenceC2a> result = new ArrayList<MT575.SequenceC2a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceC2List(), "SETPRTY")) {
            MT575.SequenceC2a s = MT575.SequenceC2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT576.SequenceA1> resolveMT576GetSequenceA1List_sru2024(MT576 mt) {
        ArrayList<MT576.SequenceA1> result = new ArrayList<MT576.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT576.SequenceA1 s = MT576.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT576.SequenceB2a> resolveMT576GetSequenceB2aList_sru2024(MT576 mt) {
        ArrayList<MT576.SequenceB2a> result = new ArrayList<MT576.SequenceB2a>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceB2List(), "LINK")) {
            MT576.SequenceB2a s = MT576.SequenceB2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT586.SequenceA1> resolveMT586GetSequenceA1List_sru2024(MT586 mt) {
        ArrayList<MT586.SequenceA1> result = new ArrayList<MT586.SequenceA1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceA(), "LINK")) {
            MT586.SequenceA1 s = MT586.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT586.SequenceB1> resolveMT586GetSequenceB1List_sru2024(MT586 mt) {
        ArrayList<MT586.SequenceB1> result = new ArrayList<MT586.SequenceB1>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceBList(), "LINK")) {
            MT586.SequenceB1 s = MT586.SequenceB1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT670.SequenceB2> resolveMT670GetSequenceB2List_sru2024(MT670 mt) {
        ArrayList<MT670.SequenceB2> result = new ArrayList<MT670.SequenceB2>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceBList(), "OTHRDET")) {
            MT670.SequenceB2 s = MT670.SequenceB2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT670.SequenceC resolveMT670GetSequenceC_sru2024(MT670 mt) {
        Objects.requireNonNull(mt);
        MT670.SequenceC result = MT670.SequenceC.newInstance();
        result.clear().append(SequenceUtils.getMT670_1_C(mt.getSwiftMessage().getBlock4(), "SSIDET"));
        return result;
    }

    public static List<MT671.SequenceB2> resolveMT671GetSequenceB2List_sru2024(MT671 mt) {
        ArrayList<MT671.SequenceB2> result = new ArrayList<MT671.SequenceB2>();
        for (SwiftTagListBlock seq : SequenceUtils.resolveNotUniqueSeparator(mt.getSequenceBList(), "OTHRDET")) {
            MT671.SequenceB2 s = MT671.SequenceB2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT671.SequenceC resolveMT671GetSequenceC_sru2024(MT671 mt) {
        Objects.requireNonNull(mt);
        MT671.SequenceC result = MT671.SequenceC.newInstance();
        result.clear().append(SequenceUtils.getMT670_1_C(mt.getSwiftMessage().getBlock4(), "SSIDET"));
        return result;
    }

    private static SwiftTagListBlock getMT670_1_C(SwiftTagListBlock b4, String B_startEnd16rs) {
        int last = b4.indexOfLastValue("16S", B_startEnd16rs);
        if (last >= 0) {
            if (last + 1 == b4.size()) {
                return SwiftTagListBlock.EMPTY_LIST;
            }
            return b4.sublist(last, b4.size());
        }
        return b4;
    }

    private static List<SwiftTagListBlock> resolveNotUniqueSeparator(List<? extends SwiftTagListBlock> allParent, String separator) {
        return SequenceUtils.resolveNotUniqueSeparator(SwiftMessageUtils.join(allParent), separator);
    }

    private static List<SwiftTagListBlock> resolveNotUniqueSeparator(SwiftTagListBlock parent, String separator) {
        if (parent != null && !parent.isEmpty()) {
            return parent.getSubBlocks(separator);
        }
        return Collections.emptyList();
    }
}

