/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Locale;

@StatelessCheck
public final class AnnotationUseStyleCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_INCORRECT_STYLE = "annotation.incorrect.style";
    public static final String MSG_KEY_ANNOTATION_PARENS_MISSING = "annotation.parens.missing";
    public static final String MSG_KEY_ANNOTATION_PARENS_PRESENT = "annotation.parens.present";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING = "annotation.trailing.comma.missing";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT = "annotation.trailing.comma.present";
    private static final String ANNOTATION_ELEMENT_SINGLE_NAME = "value";
    private ElementStyleOption elementStyle = ElementStyleOption.COMPACT_NO_ARRAY;
    private TrailingArrayCommaOption trailingArrayComma = TrailingArrayCommaOption.NEVER;
    private ClosingParensOption closingParens = ClosingParensOption.NEVER;

    public void setElementStyle(String style) {
        this.elementStyle = AnnotationUseStyleCheck.getOption(ElementStyleOption.class, style);
    }

    public void setTrailingArrayComma(String comma) {
        this.trailingArrayComma = AnnotationUseStyleCheck.getOption(TrailingArrayCommaOption.class, comma);
    }

    public void setClosingParens(String parens) {
        this.closingParens = AnnotationUseStyleCheck.getOption(ClosingParensOption.class, parens);
    }

    private static <T extends Enum<T>> T getOption(Class<T> enumClass, String value) {
        try {
            return Enum.valueOf(enumClass, value.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("unable to parse " + value, iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{159};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.checkStyleType(ast);
        this.checkCheckClosingParensOption(ast);
        this.checkTrailingComma(ast);
    }

    private void checkStyleType(DetailAST annotation) {
        switch (this.elementStyle) {
            case COMPACT_NO_ARRAY: {
                this.checkCompactNoArrayStyle(annotation);
                break;
            }
            case COMPACT: {
                this.checkCompactStyle(annotation);
                break;
            }
            case EXPANDED: {
                this.checkExpandedStyle(annotation);
                break;
            }
        }
    }

    private void checkExpandedStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(160);
        if (valuePairCount == 0 && AnnotationUseStyleCheck.hasArguments(annotation)) {
            this.log(annotation, MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyleOption.EXPANDED});
        }
    }

    private static boolean hasArguments(DetailAST annotation) {
        DetailAST firstToken = annotation.findFirstToken(76);
        return firstToken != null && firstToken.getNextSibling().getType() != 77;
    }

    private void checkCompactStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(160);
        DetailAST valuePair = annotation.findFirstToken(160);
        if (valuePairCount == 1 && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText())) {
            this.log(annotation, MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyleOption.COMPACT});
        }
    }

    private void checkCompactNoArrayStyle(DetailAST annotation) {
        DetailAST arrayInit = annotation.findFirstToken(162);
        if (arrayInit != null && arrayInit.getChildCount(28) == 1) {
            this.log(annotation, MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyleOption.COMPACT_NO_ARRAY});
        } else {
            for (DetailAST ast = annotation.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
                DetailAST nestedArrayInit = ast.findFirstToken(162);
                if (nestedArrayInit == null || nestedArrayInit.getChildCount(28) != 1) continue;
                this.log(annotation, MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyleOption.COMPACT_NO_ARRAY});
            }
        }
    }

    private void checkTrailingComma(DetailAST annotation) {
        if (this.trailingArrayComma != TrailingArrayCommaOption.IGNORE) {
            for (DetailAST child = annotation.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST arrayInit = null;
                if (child.getType() == 160) {
                    arrayInit = child.findFirstToken(162);
                } else if (child.getType() == 162) {
                    arrayInit = child;
                }
                if (arrayInit == null) continue;
                this.logCommaViolation(arrayInit);
            }
        }
    }

    private void logCommaViolation(DetailAST ast) {
        DetailAST rCurly = ast.findFirstToken(73);
        DetailAST comma = rCurly.getPreviousSibling();
        if (this.trailingArrayComma == TrailingArrayCommaOption.NEVER) {
            if (comma != null && comma.getType() == 74) {
                this.log(comma, MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT, new Object[0]);
            }
        } else if (comma == null || comma.getType() != 74) {
            this.log(rCurly, MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING, new Object[0]);
        }
    }

    private void checkCheckClosingParensOption(DetailAST ast) {
        if (this.closingParens != ClosingParensOption.IGNORE) {
            DetailAST paren = ast.getLastChild();
            if (this.closingParens == ClosingParensOption.NEVER) {
                if (paren.getPreviousSibling().getType() == 76) {
                    this.log(ast, MSG_KEY_ANNOTATION_PARENS_PRESENT, new Object[0]);
                }
            } else if (paren.getType() != 77) {
                this.log(ast, MSG_KEY_ANNOTATION_PARENS_MISSING, new Object[0]);
            }
        }
    }

    public static enum ElementStyleOption {
        EXPANDED,
        COMPACT,
        COMPACT_NO_ARRAY,
        IGNORE;

    }

    public static enum TrailingArrayCommaOption {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    public static enum ClosingParensOption {
        ALWAYS,
        NEVER,
        IGNORE;

    }
}

