/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.nvd.NvdCveClient;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NvdCveClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCveClientBuilder.class);
    private final List<NameValuePair> filters = new ArrayList<NameValuePair>();
    private String apiKey;
    private String endpoint;
    private int resultsPerPage;
    private long delay;
    private int maxRetryCount = 10;
    private int threadCount = 1;
    private int maxPageCount = 0;
    private HttpAsyncClientSupplier httpClientSupplier;
    private String userAgent;

    private NvdCveClientBuilder() {
    }

    public static NvdCveClientBuilder aNvdCveApi() {
        return new NvdCveClientBuilder();
    }

    public NvdCveClientBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public NvdCveClientBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public NvdCveClientBuilder withDelay(long milliseconds) {
        this.delay = milliseconds;
        return this;
    }

    public NvdCveClientBuilder withMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public NvdCveClientBuilder withThreadCount(int count) {
        this.threadCount = count;
        return this;
    }

    public NvdCveClientBuilder withMaxPageCount(int count) {
        this.maxPageCount = count;
        return this;
    }

    public NvdCveClientBuilder withResultsPerPage(int resultsPerPage) {
        if (resultsPerPage > 0 && resultsPerPage <= 2000) {
            this.resultsPerPage = resultsPerPage;
        } else {
            LOG.warn("Invalid results per page - must be between 1 and 2000: {}", (Object)resultsPerPage);
        }
        return this;
    }

    public NvdCveClientBuilder withFilter(String filter, String value) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter, value));
        return this;
    }

    public NvdCveClientBuilder withFilter(Filter filter, String value) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter.toParameterName(), value));
        return this;
    }

    public NvdCveClientBuilder withFilter(BooleanFilter filter) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter.toParameterName(), null));
        return this;
    }

    public NvdCveClientBuilder withLastModifiedFilter(ZonedDateTime utcStartDate, ZonedDateTime utcEndDate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.filters.add((NameValuePair)new BasicNameValuePair("lastModStartDate", utcStartDate.format(dtf)));
        this.filters.add((NameValuePair)new BasicNameValuePair("lastModEndDate", utcEndDate.format(dtf)));
        return this;
    }

    public NvdCveClientBuilder withAdditionalUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public NvdCveClientBuilder withPublishedDateFilter(ZonedDateTime utcStartDate, ZonedDateTime utcEndDate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.filters.add((NameValuePair)new BasicNameValuePair("pubStartDate", utcStartDate.format(dtf)));
        this.filters.add((NameValuePair)new BasicNameValuePair("pubEndDate", utcEndDate.format(dtf)));
        return this;
    }

    public NvdCveClientBuilder withCvssV2SeverityFilter(CvssV2Severity severity) {
        this.withFilter("cvssV2Severity", severity.toString());
        return this;
    }

    public NvdCveClientBuilder withCvssV3SeverityFilter(CvssV3Severity severity) {
        this.withFilter("cvssV3Severity", severity.toString());
        return this;
    }

    public NvdCveClientBuilder withVirtualMatchString(String virtualMatchString) {
        this.withFilter("virtualMatchString", virtualMatchString);
        return this;
    }

    public NvdCveClientBuilder withVersionStart(String versionStart) {
        this.withFilter("versionStart", versionStart);
        return this;
    }

    public NvdCveClientBuilder withVersionStart(String versionStart, VersionType startType) {
        this.withFilter("versionStart", versionStart);
        this.withFilter("versionStartType", startType.toString().toLowerCase());
        return this;
    }

    public NvdCveClientBuilder withVersionEnd(String versionEnd) {
        this.withFilter("versionEnd", versionEnd);
        return this;
    }

    public NvdCveClientBuilder withVersionEnd(String versionEnd, VersionType endType) {
        this.withFilter("versionEnd", versionEnd);
        this.withFilter("versionEndType", endType.toString().toLowerCase());
        return this;
    }

    public NvdCveClientBuilder withHttpClientSupplier(HttpAsyncClientSupplier httpClientSupplier) {
        this.httpClientSupplier = httpClientSupplier;
        return this;
    }

    public NvdCveClient build() {
        NvdCveClient client = new NvdCveClient(this.apiKey, this.endpoint, this.delay, this.threadCount, this.maxPageCount, this.maxRetryCount, this.httpClientSupplier, this.userAgent);
        if (!this.filters.isEmpty()) {
            client.setFilters(this.filters);
        }
        if (this.resultsPerPage > 0) {
            client.setResultsPerPage(this.resultsPerPage);
        }
        return client;
    }

    public static enum CvssV3Severity {
        LOW,
        MEDIUM,
        HIGH,
        CRITICAL;

    }

    public static enum CvssV2Severity {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum BooleanFilter {
        HAS_CERT_ALERTS,
        HAS_CERT_NOTES,
        HAS_KEV,
        HAS_OVAL,
        IS_VULNERABLE,
        NO_REJECTED;


        public String toParameterName() {
            switch (this) {
                case HAS_CERT_ALERTS: {
                    return "hasCertAlerts";
                }
                case HAS_CERT_NOTES: {
                    return "hasCertNotes";
                }
                case HAS_KEV: {
                    return "hasKev";
                }
                case HAS_OVAL: {
                    return "hasOval";
                }
                case IS_VULNERABLE: {
                    return "isVulnerable";
                }
                case NO_REJECTED: {
                    return "noRejected";
                }
            }
            return "unknown";
        }
    }

    public static enum Filter {
        CPE_NAME,
        CVE_ID,
        CVSS_V2_METRICS,
        CVSS_V3_METRICS,
        CWE_ID,
        KEYWORD_EXACT_MATCH,
        KEYWORD_SEARCH;


        public String toParameterName() {
            switch (this) {
                case CPE_NAME: {
                    return "cpeName";
                }
                case CVE_ID: {
                    return "cveId";
                }
                case CVSS_V2_METRICS: {
                    return "cvssV2Metrics";
                }
                case CVSS_V3_METRICS: {
                    return "cvssV3Metrics";
                }
                case CWE_ID: {
                    return "cweId";
                }
                case KEYWORD_EXACT_MATCH: {
                    return "keywordExactMatch";
                }
                case KEYWORD_SEARCH: {
                    return "keywordSearch";
                }
            }
            return "unknown";
        }
    }

    public static enum VersionType {
        INCLUDING,
        EXCLUDING;

    }
}

