/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TraversingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\f\u0010\u0019\u001a\u00020\u0013*\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isNotReferenced", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "comment", "", "isTopLevelOrInPublicClass", "isUndocumented", "shouldBeDocumented", "detekt-rules-documentation"})
public final class UndocumentedPublicProperty
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        if (TraversingKt.isPublicInherited((KtNamedDeclaration)((KtNamedDeclaration)constructor))) {
            void $this$filterTo$iv$iv;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)constructor));
            String comment = ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getDocComment()) != null ? ktClassOrObject.getText() : null;
            Iterable $this$filter$iv = constructor.getValueParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                KtParameter ktParameter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                if (!(KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)ktParameter)) && it.hasValOrVar() && this.isUndocumented(it, comment))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter it = (KtParameter)element$iv;
                boolean bl = false;
                KtParameter ktParameter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                this.report((KtNamedDeclaration)ktParameter);
            }
        }
        super.visitPrimaryConstructor(constructor);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (TraversingKt.isPublicInherited((KtNamedDeclaration)((KtNamedDeclaration)property)) && !property.isLocal() && this.shouldBeDocumented(property)) {
            this.report((KtNamedDeclaration)property);
        }
        super.visitProperty(property);
    }

    private final boolean isUndocumented(@NotNull KtParameter $this$isUndocumented, String comment) {
        return comment == null || this.isNotReferenced($this$isUndocumented, comment);
    }

    private final boolean isNotReferenced(@NotNull KtParameter $this$isNotReferenced, String comment) {
        Name name = $this$isNotReferenced.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"nameAsSafeName");
        Name name2 = name;
        return !StringsKt.contains$default((CharSequence)comment, (CharSequence)("" + '[' + name2 + ']'), (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)comment, (CharSequence)("@property " + name2), (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)comment, (CharSequence)("@param " + name2), (boolean)false, (int)2, null);
    }

    private final boolean shouldBeDocumented(@NotNull KtProperty $this$shouldBeDocumented) {
        return $this$shouldBeDocumented.getDocComment() == null && this.isTopLevelOrInPublicClass($this$shouldBeDocumented) && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)$this$shouldBeDocumented));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelOrInPublicClass(@NotNull KtProperty $this$isTopLevelOrInPublicClass) {
        if ($this$isTopLevelOrInPublicClass.isTopLevel()) return true;
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$isTopLevelOrInPublicClass));
        if (ktClass == null) return false;
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)ktClass))) return false;
        return true;
    }

    private final void report(KtNamedDeclaration property) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "The property " + property.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
    }

    public UndocumentedPublicProperty(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Public properties require documentation.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ UndocumentedPublicProperty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UndocumentedPublicProperty() {
        this(null, 1, null);
    }
}

