/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.documentation.LicenceHeaderLoaderExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\f\u0010\u0010\u001a\u00020\n*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCondition", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitKtFile", "", "file", "hasValidLicense", "Companion", "detekt-rules-documentation"})
public final class AbsentOrWrongFileLicense
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_FILE = "licenseTemplateFile";
    @NotNull
    public static final String DEFAULT_LICENSE_TEMPLATE_FILE = "license.template";
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_IS_REGEX = "licenseTemplateIsRegex";
    public static final boolean DEFAULT_LICENSE_TEMPLATE_IS_REGEX = false;
    @NotNull
    private static final String RULE_NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return super.visitCondition(root) && (LicenceHeaderLoaderExtensionKt.hasLicenseHeader(root) || LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex(root));
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.hasValidLicense(file)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atPackageOrFirstDecl(file), "Expected license not found or incorrect in the file: " + file.getName() + '.', null, null, 24, null));
        }
    }

    private final boolean hasValidLicense(KtFile $this$hasValidLicense) {
        boolean bl;
        if (LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex($this$hasValidLicense)) {
            Regex regex = LicenceHeaderLoaderExtensionKt.getLicenseHeaderRegex($this$hasValidLicense);
            String string = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            bl = matchResult != null && (matchResult = matchResult.getRange()) != null && matchResult.getStart() == 0;
        } else {
            String string = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            bl = StringsKt.startsWith$default((String)string, (String)LicenceHeaderLoaderExtensionKt.getLicenseHeader($this$hasValidLicense), (boolean)false, (int)2, null);
        }
        return bl;
    }

    public AbsentOrWrongFileLicense(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue(RULE_NAME, Severity.Maintainability, "License text is absent or incorrect in the file.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ AbsentOrWrongFileLicense(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public AbsentOrWrongFileLicense() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        String string = AbsentOrWrongFileLicense.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AbsentOrWrongFileLicense::class.java.simpleName");
        RULE_NAME = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense$Companion;", "", "()V", "DEFAULT_LICENSE_TEMPLATE_FILE", "", "DEFAULT_LICENSE_TEMPLATE_IS_REGEX", "", "PARAM_LICENSE_TEMPLATE_FILE", "PARAM_LICENSE_TEMPLATE_IS_REGEX", "RULE_NAME", "getRULE_NAME", "()Ljava/lang/String;", "detekt-rules-documentation"})
    public static final class Companion {
        @NotNull
        public final String getRULE_NAME() {
            return RULE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

