/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.api.SingleAssign;
import io.gitlab.arturbosch.detekt.rules.documentation.AbsentOrWrongFileLicense;
import io.gitlab.arturbosch.detekt.rules.documentation.LicenceHeaderLoaderExtensionKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/LicenceHeaderLoaderExtension;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "<set-?>", "Lio/gitlab/arturbosch/detekt/api/Config;", "config", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "setConfig", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "config$delegate", "Lio/gitlab/arturbosch/detekt/api/SingleAssign;", "configPath", "Ljava/nio/file/Path;", "init", "", "context", "Lio/gitlab/arturbosch/detekt/api/SetupContext;", "onStart", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "detekt-rules-documentation"})
public final class LicenceHeaderLoaderExtension
implements FileProcessListener {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SingleAssign config$delegate = new SingleAssign();
    @Nullable
    private Path configPath;

    private final Config getConfig() {
        return (Config)this.config$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setConfig(Config config) {
        this.config$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)config);
    }

    /*
     * WARNING - void declaration
     */
    public void init(@NotNull SetupContext context) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setConfig(context.getConfig());
        LicenceHeaderLoaderExtension licenceHeaderLoaderExtension = this;
        URI uRI = (URI)CollectionsKt.lastOrNull((Iterable)context.getConfigUris());
        if (uRI == null) {
            path = null;
        } else {
            void p0;
            URI uRI2 = uRI;
            boolean bl = false;
            boolean bl2 = false;
            URI uRI3 = uRI2;
            LicenceHeaderLoaderExtension licenceHeaderLoaderExtension2 = licenceHeaderLoaderExtension;
            boolean bl3 = false;
            Path path2 = Paths.get((URI)p0);
            licenceHeaderLoaderExtension = licenceHeaderLoaderExtension2;
            path = path2;
        }
        licenceHeaderLoaderExtension.configPath = path;
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (this.configPath != null && LicenceHeaderLoaderExtension.onStart$shouldRuleRun(this)) {
            Path path;
            Path path2 = this.configPath;
            Path path3 = path = path2 == null ? null : path2.getParent();
            if (path == null) {
                return;
            }
            Path configDir = path;
            LicenceHeaderLoaderExtension.onStart$cacheLicence(files, this, configDir, LicenceHeaderLoaderExtension.onStart$isRegexTemplate(this));
        }
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onFinish(files, result, bindingContext)", imports={}))
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result) {
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcess(file, bindingContext)", imports={}))
    public void onProcess(@NotNull KtFile file) {
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcessComplete(file, findings, bindingContext)", imports={}))
    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onStart(files, bindingContext)", imports={}))
    public void onStart(@NotNull List<? extends KtFile> files) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files);
    }

    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result, (BindingContext)bindingContext);
    }

    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file, (BindingContext)bindingContext);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext);
    }

    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId((FileProcessListener)this);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    private static final boolean onStart$isActive(Config $this$onStart_u24isActive) {
        return (Boolean)$this$onStart_u24isActive.valueOrDefault("active", (Object)false);
    }

    private static final boolean onStart$shouldRuleRun(LicenceHeaderLoaderExtension this$0) {
        Config comments = this$0.getConfig().subConfig("comments");
        Config ruleConfig = comments.subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME());
        return LicenceHeaderLoaderExtension.onStart$isActive(comments) && LicenceHeaderLoaderExtension.onStart$isActive(ruleConfig);
    }

    private static final String onStart$getPathToTemplate(LicenceHeaderLoaderExtension this$0) {
        return (String)this$0.getConfig().subConfig("comments").subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME()).valueOrDefault("licenseTemplateFile", (Object)"license.template");
    }

    private static final boolean onStart$isRegexTemplate(LicenceHeaderLoaderExtension this$0) {
        return (Boolean)this$0.getConfig().subConfig("comments").subConfig(AbsentOrWrongFileLicense.Companion.getRULE_NAME()).valueOrDefault("licenseTemplateIsRegex", (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String onStart$loadLicence(LicenceHeaderLoaderExtension this$0, Path dir) {
        String string;
        Path templateFile = dir.resolve(LicenceHeaderLoaderExtension.onStart$getPathToTemplate(this$0));
        boolean bl = Files.exists(templateFile, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = StringsKt.trimIndent((String)("\n                Rule '" + AbsentOrWrongFileLicense.Companion.getRULE_NAME() + "': License template file not found at `" + templateFile.toAbsolutePath() + "`.\n                Create file license header file or check your running path.\n                "));
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Closeable closeable = Files.newBufferedReader(templateFile);
        bl2 = false;
        bl3 = false;
        Throwable throwable = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean bl5 = false;
            string = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return LicenceHeaderLoaderExtensionKt.access$convertLineSeparators(string);
    }

    private static final void onStart$cacheLicence(List<? extends KtFile> $files, LicenceHeaderLoaderExtension this$0, Path dir, boolean isRegexTemplate) {
        String licenceHeader = LicenceHeaderLoaderExtension.onStart$loadLicence(this$0, dir);
        if (!isRegexTemplate) {
            for (KtFile ktFile : $files) {
                ktFile.putUserData(LicenceHeaderLoaderExtensionKt.getLICENCE_KEY(), (Object)licenceHeader);
            }
            return;
        }
        String string = licenceHeader;
        RegexOption regexOption = RegexOption.MULTILINE;
        boolean bl = false;
        Regex licenseHeaderRegex = new Regex(string, regexOption);
        for (KtFile ktFile : $files) {
            ktFile.putUserData(LicenceHeaderLoaderExtensionKt.getLICENCE_REGEX_KEY(), (Object)licenseHeaderRegex);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LicenceHeaderLoaderExtension.class), "config", "getConfig()Lio/gitlab/arturbosch/detekt/api/Config;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

