/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.documentation.EndOfSentenceFormat;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/EndOfSentenceFormat;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "endOfSentenceFormat", "Lkotlin/text/Regex;", "getEndOfSentenceFormat$annotations", "()V", "getEndOfSentenceFormat", "()Lkotlin/text/Regex;", "endOfSentenceFormat$delegate", "Lkotlin/properties/ReadOnlyProperty;", "htmlTag", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "startsWithHtmlTag", "", "", "detekt-rules-documentation"})
public final class EndOfSentenceFormat
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty endOfSentenceFormat$delegate;
    @NotNull
    private final Regex htmlTag;

    public EndOfSentenceFormat(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "The first sentence in a KDoc comment should end with correct punctuation.", Debt.Companion.getFIVE_MINS());
        this.endOfSentenceFormat$delegate = ConfigPropertyKt.config((Object)"([.?!][ \\t\\n\\r\\f<])|([.?!:]$)", (Function1)endOfSentenceFormat.2.INSTANCE);
        this.htmlTag = new Regex("<.+>");
    }

    public /* synthetic */ EndOfSentenceFormat(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getEndOfSentenceFormat() {
        return (Regex)this.endOfSentenceFormat$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="regular expression which should match the end of the first sentence in the KDoc")
    private static /* synthetic */ void getEndOfSentenceFormat$annotations() {
    }

    public void visitDeclaration(@NotNull KtDeclaration dcl) {
        Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
        super.visitDeclaration(dcl);
        KDoc kDoc = dcl.getDocComment();
        if (kDoc != null) {
            KDoc kDoc2 = kDoc;
            boolean bl = false;
            boolean bl2 = false;
            KDoc it = kDoc2;
            boolean bl3 = false;
            String text = it.getDefaultSection().getContent();
            CharSequence charSequence = text;
            boolean bl4 = false;
            if (charSequence.length() == 0 || this.startsWithHtmlTag(text)) {
                return;
            }
            if (!this.getEndOfSentenceFormat().containsMatchIn((CharSequence)text) && !StringExtensionsKt.lastArgumentMatchesUrl((String)text)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)dcl), (int)0, (int)2, null), "The first sentence of this KDoc does not end with the correct punctuation.", null, null, 24, null));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean startsWithHtmlTag(String $this$startsWithHtmlTag) {
        if (!StringsKt.startsWith$default((String)$this$startsWithHtmlTag, (String)"<", (boolean)false, (int)2, null)) return false;
        CharSequence charSequence = $this$startsWithHtmlTag;
        Regex regex = this.htmlTag;
        boolean bl = false;
        if (!regex.containsMatchIn(charSequence)) return false;
        return true;
    }

    public EndOfSentenceFormat() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(EndOfSentenceFormat.class, "endOfSentenceFormat", "getEndOfSentenceFormat()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

