/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.rules.documentation.DeprecatedBlockTag;
import io.gitlab.arturbosch.detekt.rules.documentation.EndOfSentenceFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/KDocStyle;", "Lio/gitlab/arturbosch/detekt/api/MultiRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "deprecatedBlockTag", "Lio/gitlab/arturbosch/detekt/rules/documentation/DeprecatedBlockTag;", "endOfSentenceFormat", "Lio/gitlab/arturbosch/detekt/rules/documentation/EndOfSentenceFormat;", "rules", "", "Lio/gitlab/arturbosch/detekt/api/Rule;", "getRules", "()Ljava/util/List;", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "detekt-rules-documentation"})
public final class KDocStyle
extends MultiRule {
    @NotNull
    private final DeprecatedBlockTag deprecatedBlockTag;
    @NotNull
    private final EndOfSentenceFormat endOfSentenceFormat;
    @NotNull
    private final List<Rule> rules;

    public KDocStyle(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.deprecatedBlockTag = new DeprecatedBlockTag(config);
        this.endOfSentenceFormat = new EndOfSentenceFormat(config);
        Object[] objectArray = new Rule[]{this.deprecatedBlockTag, this.endOfSentenceFormat};
        this.rules = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ KDocStyle(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public List<Rule> getRules() {
        return this.rules;
    }

    public void visitDeclaration(@NotNull KtDeclaration dcl) {
        Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
        this.deprecatedBlockTag.visitDeclaration(dcl);
        this.endOfSentenceFormat.visitDeclaration(dcl);
    }

    public KDocStyle() {
        this(null, 1, null);
    }
}

