/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.documentation.LicenceHeaderLoaderExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\f\u0010\u001d\u001a\u00020\u0012*\u00020\u0019H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0010\u0012\u0004\b\u0013\u0010\f\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "licenseTemplateFile", "", "getLicenseTemplateFile$annotations", "()V", "getLicenseTemplateFile", "()Ljava/lang/String;", "licenseTemplateFile$delegate", "Lkotlin/properties/ReadOnlyProperty;", "licenseTemplateIsRegex", "", "getLicenseTemplateIsRegex$annotations", "getLicenseTemplateIsRegex", "()Z", "licenseTemplateIsRegex$delegate", "visitCondition", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitKtFile", "", "file", "hasValidLicense", "Companion", "detekt-rules-documentation"})
public final class AbsentOrWrongFileLicense
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty licenseTemplateFile$delegate;
    @NotNull
    private final ReadOnlyProperty licenseTemplateIsRegex$delegate;
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_FILE = "licenseTemplateFile";
    @NotNull
    public static final String DEFAULT_LICENSE_TEMPLATE_FILE = "license.template";
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_IS_REGEX = "licenseTemplateIsRegex";
    public static final boolean DEFAULT_LICENSE_TEMPLATE_IS_REGEX = false;
    @NotNull
    private static final String RULE_NAME;

    public AbsentOrWrongFileLicense(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue(RULE_NAME, Severity.Maintainability, "License text is absent or incorrect.", Debt.Companion.getFIVE_MINS());
        this.licenseTemplateFile$delegate = ConfigPropertyKt.config((Object)DEFAULT_LICENSE_TEMPLATE_FILE);
        this.licenseTemplateIsRegex$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ AbsentOrWrongFileLicense(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final String getLicenseTemplateFile() {
        return (String)this.licenseTemplateFile$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="path to file with license header template resolved relatively to config file")
    private static /* synthetic */ void getLicenseTemplateFile$annotations() {
    }

    private final boolean getLicenseTemplateIsRegex() {
        return (Boolean)this.licenseTemplateIsRegex$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="whether or not the license header template is a regex template")
    private static /* synthetic */ void getLicenseTemplateIsRegex$annotations() {
    }

    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return super.visitCondition(root) && (LicenceHeaderLoaderExtensionKt.hasLicenseHeader(root) || LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex(root));
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.hasValidLicense(file)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atPackageOrFirstDecl(file), "Expected license not found or incorrect in the file: " + file.getName() + '.', null, null, 24, null));
        }
    }

    private final boolean hasValidLicense(KtFile $this$hasValidLicense) {
        boolean bl;
        if (LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex($this$hasValidLicense)) {
            Regex regex = LicenceHeaderLoaderExtensionKt.getLicenseHeaderRegex($this$hasValidLicense);
            String string = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            bl = matchResult != null && (matchResult = matchResult.getRange()) != null ? matchResult.getStart() == 0 : false;
        } else {
            String string = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            bl = StringsKt.startsWith$default((String)string, (String)LicenceHeaderLoaderExtensionKt.getLicenseHeader($this$hasValidLicense), (boolean)false, (int)2, null);
        }
        return bl;
    }

    public AbsentOrWrongFileLicense() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(AbsentOrWrongFileLicense.class, PARAM_LICENSE_TEMPLATE_FILE, "getLicenseTemplateFile()Ljava/lang/String;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(AbsentOrWrongFileLicense.class, PARAM_LICENSE_TEMPLATE_IS_REGEX, "getLicenseTemplateIsRegex()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        String string = AbsentOrWrongFileLicense.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AbsentOrWrongFileLicense::class.java.simpleName");
        RULE_NAME = string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense$Companion;", "", "()V", "DEFAULT_LICENSE_TEMPLATE_FILE", "", "DEFAULT_LICENSE_TEMPLATE_IS_REGEX", "", "PARAM_LICENSE_TEMPLATE_FILE", "PARAM_LICENSE_TEMPLATE_IS_REGEX", "RULE_NAME", "getRULE_NAME", "()Ljava/lang/String;", "detekt-rules-documentation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRULE_NAME() {
            return RULE_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

