/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TraversingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\n*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\n*\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\u00020\n*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\f\u0010 \u001a\u00020\n*\u00020\u0019H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchProtectedProperty", "", "getSearchProtectedProperty$annotations", "()V", "getSearchProtectedProperty", "()Z", "searchProtectedProperty$delegate", "Lkotlin/properties/ReadOnlyProperty;", "report", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isNotReferenced", "Lorg/jetbrains/kotlin/psi/KtParameter;", "comment", "", "isTopLevelOrInPublicClass", "isUndocumented", "shouldBeDocumented", "detekt-rules-documentation"})
public final class UndocumentedPublicProperty
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchProtectedProperty$delegate;

    public UndocumentedPublicProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Public properties require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchProtectedProperty$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ UndocumentedPublicProperty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchProtectedProperty() {
        return (Boolean)this.searchProtectedProperty$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if protected functions should be searched")
    private static /* synthetic */ void getSearchProtectedProperty$annotations() {
    }

    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        if (TraversingKt.isPublicInherited((KtNamedDeclaration)((KtNamedDeclaration)constructor))) {
            KtParameter it;
            Iterable $this$filterTo$iv$iv;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)constructor));
            String comment = ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getDocComment()) != null ? ktClassOrObject.getText() : null;
            Iterable $this$filter$iv = constructor.getValueParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)it)) && it.hasValOrVar())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(this.isUndocumented(it, comment) && it.getDocComment() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter it2 = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                this.report((KtNamedDeclaration)it2);
            }
        }
        super.visitPrimaryConstructor(constructor);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (TraversingKt.isPublicInherited((KtNamedDeclaration)((KtNamedDeclaration)property), (boolean)this.getSearchProtectedProperty()) && !property.isLocal() && this.shouldBeDocumented(property)) {
            this.report((KtNamedDeclaration)property);
        }
        super.visitProperty(property);
    }

    private final boolean isUndocumented(KtParameter $this$isUndocumented, String comment) {
        return comment == null || this.isNotReferenced($this$isUndocumented, comment);
    }

    private final boolean isNotReferenced(KtParameter $this$isNotReferenced, String comment) {
        Name name = $this$isNotReferenced.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"nameAsSafeName");
        Name name2 = name;
        return !StringsKt.contains$default((CharSequence)comment, (CharSequence)("" + '[' + name2 + ']'), (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)comment, (CharSequence)("@property " + name2), (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)comment, (CharSequence)("@param " + name2), (boolean)false, (int)2, null);
    }

    private final boolean shouldBeDocumented(KtProperty $this$shouldBeDocumented) {
        return $this$shouldBeDocumented.getDocComment() == null && this.isTopLevelOrInPublicClass($this$shouldBeDocumented) && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)$this$shouldBeDocumented), (boolean)this.getSearchProtectedProperty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelOrInPublicClass(KtProperty $this$isTopLevelOrInPublicClass) {
        if ($this$isTopLevelOrInPublicClass.isTopLevel()) return true;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isTopLevelOrInPublicClass));
        if (ktClassOrObject == null) return false;
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)ktClassOrObject))) return false;
        return true;
    }

    private final void report(KtNamedDeclaration property) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "The property " + property.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
    }

    public UndocumentedPublicProperty() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicProperty.class, "searchProtectedProperty", "getSearchProtectedProperty()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

