/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.documentation.UndocumentedPublicFunction$shouldBeDocumented$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\n*\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchProtectedFunction", "", "getSearchProtectedFunction$annotations", "()V", "getSearchProtectedFunction", "()Z", "searchProtectedFunction$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeDocumented", "detekt-rules-documentation"})
@SourceDebugExtension(value={"SMAP\nUndocumentedPublicFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndocumentedPublicFunction.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n473#2:58\n1224#2,2:59\n473#2:61\n1224#2,2:62\n*S KotlinDebug\n*F\n+ 1 UndocumentedPublicFunction.kt\nio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction\n*L\n52#1:58\n52#1:59,2\n54#1:61\n54#1:62,2\n*E\n"})
public final class UndocumentedPublicFunction
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchProtectedFunction$delegate;

    public UndocumentedPublicFunction(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Maintainability, "Public functions require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchProtectedFunction$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ UndocumentedPublicFunction(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchProtectedFunction() {
        return (Boolean)this.searchProtectedFunction$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if protected functions should be searched")
    private static /* synthetic */ void getSearchProtectedFunction$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.getFunKeyword() == null && function.isLocal()) {
            return;
        }
        if (function.getDocComment() == null && this.shouldBeDocumented(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "The function " + function.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
        }
    }

    private final boolean shouldBeDocumented(KtNamedFunction $this$shouldBeDocumented) {
        boolean bl;
        block4: {
            if (this.getSearchProtectedFunction()) {
                Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)$this$shouldBeDocumented));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)shouldBeDocumented$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$all$iv = sequence;
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    boolean bl2 = false;
                    if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)) || KtModifierListKt.isProtected((KtModifierListOwner)((KtModifierListOwner)it))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            } else {
                Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)$this$shouldBeDocumented));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)shouldBeDocumented$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$all$iv = sequence;
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    boolean bl3 = false;
                    if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)$this$shouldBeDocumented), (boolean)this.getSearchProtectedFunction());
    }

    public UndocumentedPublicFunction() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicFunction.class, "searchProtectedFunction", "getSearchProtectedFunction()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

