/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.FieldArgs;
import java.util.Optional;

public class TextFieldArgs<K>
extends FieldArgs<K> {
    private Optional<Long> weight = Optional.empty();
    private boolean noStem;
    private Optional<PhoneticMatcher> phonetic = Optional.empty();
    private boolean withSuffixTrie;

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    @Override
    public String getFieldType() {
        return "TEXT";
    }

    public Optional<Long> getWeight() {
        return this.weight;
    }

    public boolean isNoStem() {
        return this.noStem;
    }

    public Optional<PhoneticMatcher> getPhonetic() {
        return this.phonetic;
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    @Override
    protected void buildTypeSpecificArgs(CommandArgs<K, ?> args) {
        this.weight.ifPresent(w -> args.add(CommandKeyword.WEIGHT).add((long)w));
        if (this.noStem) {
            args.add(CommandKeyword.NOSTEM);
        }
        this.phonetic.ifPresent(p -> args.add(CommandKeyword.PHONETIC).add(p.getMatcher()));
        if (this.withSuffixTrie) {
            args.add(CommandKeyword.WITHSUFFIXTRIE);
        }
    }

    public static class Builder<K>
    extends FieldArgs.Builder<K, TextFieldArgs<K>, Builder<K>> {
        public Builder() {
            super(new TextFieldArgs());
        }

        public Builder<K> weight(long weight) {
            ((TextFieldArgs)this.instance).weight = Optional.of(weight);
            return (Builder)this.self();
        }

        public Builder<K> noStem() {
            ((TextFieldArgs)this.instance).noStem = true;
            return (Builder)this.self();
        }

        public Builder<K> phonetic(PhoneticMatcher matcher) {
            ((TextFieldArgs)this.instance).phonetic = Optional.of(matcher);
            return (Builder)this.self();
        }

        public Builder<K> withSuffixTrie() {
            ((TextFieldArgs)this.instance).withSuffixTrie = true;
            return (Builder)this.self();
        }
    }

    public static enum PhoneticMatcher {
        ENGLISH("dm:en"),
        FRENCH("dm:fr"),
        PORTUGUESE("dm:pt"),
        SPANISH("dm:es");

        private final String matcher;

        private PhoneticMatcher(String matcher) {
            this.matcher = matcher;
        }

        public String getMatcher() {
            return this.matcher;
        }
    }
}

