/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class LinkBuilderImpl
implements Link.Builder {
    private static final String DOUBLE_QUOTE = "\"";
    private UriBuilder ub;
    private URI baseUri;
    private Map<String, String> params = new HashMap<String, String>(6);

    public Link build(Object ... values) {
        URI resolvedLinkUri = this.getResolvedUri(values);
        return new LinkImpl(resolvedLinkUri, new HashMap<String, String>(this.params));
    }

    public Link buildRelativized(URI requestUri, Object ... values) {
        URI resolvedLinkUri = this.getResolvedUri(values);
        URI relativized = HttpUtils.relativize(requestUri, resolvedLinkUri);
        return new LinkImpl(relativized, new HashMap<String, String>(this.params));
    }

    private URI getResolvedUri(Object ... values) {
        URI uri = this.ub.build(values);
        if (this.baseUri != null) {
            UriBuilder linkUriBuilder = UriBuilder.fromUri((URI)this.baseUri);
            String scheme = uri.getScheme();
            if (scheme != null && scheme.startsWith("http")) {
                return HttpUtils.resolve(linkUriBuilder, uri);
            }
            String theUri = uri.toString();
            return linkUriBuilder.path(theUri).build(new Object[0]);
        }
        return uri;
    }

    public Link.Builder link(Link link) {
        this.ub = UriBuilder.fromLink((Link)link);
        this.params.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        String[] tokens;
        for (String token : tokens = StringUtils.split((String)link, (String)";")) {
            String theToken = token.trim();
            if (theToken.startsWith("<") && theToken.endsWith(">")) {
                this.ub = UriBuilder.fromUri((String)theToken.substring(1, theToken.length() - 1));
                continue;
            }
            int i = theToken.indexOf(61);
            if (i == -1) continue;
            String name = theToken.substring(0, i);
            String value = this.stripQuotes(theToken.substring(i + 1));
            this.params.put(name, value);
        }
        return this;
    }

    public Link.Builder param(String name, String value) {
        this.checkNotNull(name);
        this.checkNotNull(value);
        this.params.put(name, value);
        return this;
    }

    public Link.Builder rel(String rel) {
        String exisingRel = this.params.get("rel");
        String newRel = exisingRel == null ? rel : exisingRel + " " + rel;
        return this.param("rel", newRel);
    }

    public Link.Builder title(String title) {
        return this.param("title", title);
    }

    public Link.Builder type(String type) {
        return this.param("type", type);
    }

    public Link.Builder uri(URI uri) {
        this.ub = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) {
        this.ub = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder uriBuilder(UriBuilder builder) {
        this.ub = builder;
        return this;
    }

    private String stripQuotes(String value) {
        return value.replaceAll(DOUBLE_QUOTE, "");
    }

    private void checkNotNull(String value) {
        if (value == null) {
            throw new IllegalArgumentException(value);
        }
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }

    static class LinkImpl
    extends Link {
        private static final Set<String> MAIN_PARAMETERS = new HashSet<String>(Arrays.asList("rel", "title", "type"));
        private URI uri;
        private Map<String, String> params;

        public LinkImpl(URI uri, Map<String, String> params) {
            this.uri = uri;
            this.params = params;
        }

        public Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }

        public String getRel() {
            return this.params.get("rel");
        }

        public List<String> getRels() {
            String rel = this.getRel();
            if (rel == null) {
                return Collections.emptyList();
            }
            String[] values = rel.split(" ");
            ArrayList<String> rels = new ArrayList<String>(values.length);
            for (String val : values) {
                rels.add(val.trim());
            }
            return rels;
        }

        public String getTitle() {
            return this.params.get("title");
        }

        public String getType() {
            return this.params.get("type");
        }

        public URI getUri() {
            return this.uri;
        }

        public UriBuilder getUriBuilder() {
            return UriBuilder.fromUri((URI)this.uri);
        }

        public String toString() {
            String type;
            String title;
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(this.uri.toString()).append(">");
            String rel = this.getRel();
            if (rel != null) {
                sb.append(";").append("rel").append("=\"").append(rel).append(LinkBuilderImpl.DOUBLE_QUOTE);
            }
            if ((title = this.getTitle()) != null) {
                sb.append(";").append("title").append("=\"").append(title).append(LinkBuilderImpl.DOUBLE_QUOTE);
            }
            if ((type = this.getType()) != null) {
                sb.append(";").append("type").append("=\"").append(type).append(LinkBuilderImpl.DOUBLE_QUOTE);
            }
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (MAIN_PARAMETERS.contains(entry.getKey())) continue;
                sb.append(";").append(entry.getKey()).append("=\"").append(entry.getValue()).append(LinkBuilderImpl.DOUBLE_QUOTE);
            }
            return sb.toString();
        }

        public int hashCode() {
            return this.uri.hashCode() + 37 * ((Object)this.params).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Link) {
                Link other = (Link)o;
                return this.uri.equals(other.getUri()) && ((Object)this.getParams()).equals(other.getParams());
            }
            return false;
        }
    }
}

