/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hc.client5.http.ConnectExceptionSupport;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.NamedEndpoint;
import org.junit.Assert;
import org.junit.Test;

public class ConnectExceptionSupportTest {
    @Test
    public void testConnectTimeoutExceptionFromNullMessageAndHost() {
        ConnectTimeoutException ctx = ConnectExceptionSupport.createConnectTimeoutException(null, null, (InetAddress[])new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote endpoint timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCause() {
        IOException cause = new IOException("something awful");
        ConnectTimeoutException ctx = ConnectExceptionSupport.createConnectTimeoutException((IOException)cause, null, (InetAddress[])new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote endpoint failed: something awful", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCauseAndHost() {
        HttpHost target = new HttpHost("localhost");
        IOException cause = new IOException();
        ConnectTimeoutException ctx = ConnectExceptionSupport.createConnectTimeoutException((IOException)cause, (NamedEndpoint)target, (InetAddress[])new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to http://localhost timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCauseHostAndRemoteAddress() throws Exception {
        HttpHost target = new HttpHost("localhost");
        InetAddress remoteAddress = InetAddress.getByAddress(new byte[]{1, 2, 3, 4});
        IOException cause = new IOException();
        ConnectTimeoutException ctx = ConnectExceptionSupport.createConnectTimeoutException((IOException)cause, (NamedEndpoint)target, (InetAddress[])new InetAddress[]{remoteAddress});
        Assert.assertEquals((Object)"Connect to http://localhost [/1.2.3.4] timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromNullCause() {
        HttpHostConnectException ctx = ConnectExceptionSupport.createHttpHostConnectException(null, null, (InetAddress[])null);
        Assert.assertEquals((Object)"Connect to remote endpoint refused", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCause() {
        IOException cause = new IOException("something awful");
        HttpHostConnectException ctx = ConnectExceptionSupport.createHttpHostConnectException((IOException)cause, null, (InetAddress[])new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote endpoint failed: something awful", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCauseAndHost() {
        HttpHost target = new HttpHost("localhost");
        IOException cause = new IOException();
        HttpHostConnectException ctx = ConnectExceptionSupport.createHttpHostConnectException((IOException)cause, (NamedEndpoint)target, (InetAddress[])new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to http://localhost refused", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCauseHostAndRemoteAddress() throws Exception {
        HttpHost target = new HttpHost("localhost");
        InetAddress remoteAddress1 = InetAddress.getByAddress(new byte[]{1, 2, 3, 4});
        InetAddress remoteAddress2 = InetAddress.getByAddress(new byte[]{5, 6, 7, 8});
        IOException cause = new IOException();
        HttpHostConnectException ctx = ConnectExceptionSupport.createHttpHostConnectException((IOException)cause, (NamedEndpoint)target, (InetAddress[])new InetAddress[]{remoteAddress1, remoteAddress2});
        Assert.assertEquals((Object)"Connect to http://localhost [/1.2.3.4, /5.6.7.8] refused", (Object)ctx.getMessage());
    }
}

