/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.core5.http.HttpHost;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthScope {
    @Test
    public void testBasics() {
        AuthScope authscope = new AuthScope("http", "somehost", 80, "somerealm", "SomeScheme");
        Assert.assertEquals((Object)"SomeScheme", (Object)authscope.getSchemeName());
        Assert.assertEquals((Object)"http", (Object)authscope.getProtocol());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals((Object)"somerealm", (Object)authscope.getRealm());
        Assert.assertEquals((Object)"SomeScheme 'somerealm' http://somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testByOrigin() {
        HttpHost host = new HttpHost("http", "somehost", 8080);
        AuthScope authscope = new AuthScope(host);
        Assert.assertEquals(null, (Object)authscope.getSchemeName());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)8080L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"http", (Object)authscope.getProtocol());
        Assert.assertEquals((Object)"<any auth scheme> <any realm> http://somehost:8080", (Object)authscope.toString());
    }

    @Test
    public void testMixedCaseHostname() {
        AuthScope authscope = new AuthScope("SomeHost", 80);
        Assert.assertEquals(null, (Object)authscope.getSchemeName());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any auth scheme> <any realm> <any protocol>://somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testByOriginMixedCaseHostname() throws Exception {
        HttpHost host = new HttpHost("http", "SomeHost", 8080);
        AuthScope authscope = new AuthScope(host);
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
    }

    @Test
    public void testBasicsAllOptional() {
        AuthScope authscope = new AuthScope(null, null, -1, null, null);
        Assert.assertEquals(null, (Object)authscope.getSchemeName());
        Assert.assertEquals(null, (Object)authscope.getHost());
        Assert.assertEquals((long)-1L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any auth scheme> <any realm> <any protocol>://<any host>:<any port>", (Object)authscope.toString());
    }

    @Test
    public void testScopeMatching() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        Assert.assertTrue((authscope1.match(authscope2) < 0 ? 1 : 0) != 0);
        int m1 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        int m2 = authscope1.match(new AuthScope(null, null, -1, "somerealm", null));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        m2 = authscope1.match(new AuthScope(null, null, -1, "somerealm", null));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, null, 80, null, null));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, "somehost", -1, null, null));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(null, "somehost", -1, null, null));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(null, null, -1, null, null));
        m2 = authscope1.match(new AuthScope(null, null, -1, null, "somescheme"));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("http", "somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("http", "somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("http", "somehost", 80, "somerealm", "someotherscheme");
        AuthScope authscope7 = new AuthScope("https", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope8 = new AuthScope("https", "somehost", 80, "somerealm", "SomeScheme");
        Assert.assertTrue((boolean)authscope1.equals((Object)authscope1));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope2));
        Assert.assertTrue((boolean)authscope1.equals((Object)authscope3));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope4));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope5));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope6));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope7));
        Assert.assertTrue((boolean)authscope7.equals((Object)authscope8));
    }

    @Test
    public void testHash() {
        AuthScope authscope1 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("http", "someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("http", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("http", "somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("http", "somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("http", "somehost", 80, "somerealm", "someotherscheme");
        AuthScope authscope7 = new AuthScope("https", "somehost", 80, "somerealm", "somescheme");
        AuthScope authscope8 = new AuthScope("https", "somehost", 80, "somerealm", "SomeScheme");
        Assert.assertTrue((authscope1.hashCode() == authscope1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((authscope1.hashCode() == authscope3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope6.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope7.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((authscope7.hashCode() == authscope8.hashCode() ? 1 : 0) != 0);
    }
}

