/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.junit.Assert;
import org.junit.Test;

public class TestMultipartFormHttpEntity {
    @Test
    public void testExplictContractorParams() throws Exception {
        HttpEntity entity = MultipartEntityBuilder.create().setLaxMode().setBoundary("whatever").setCharset(StandardCharsets.UTF_8).build();
        Assert.assertNull((Object)entity.getContentEncoding());
        String contentType = entity.getContentType();
        HeaderElement elem = BasicHeaderValueParser.INSTANCE.parseHeaderElement((CharSequence)contentType, new ParserCursor(0, contentType.length()));
        Assert.assertEquals((Object)"multipart/mixed", (Object)elem.getName());
        NameValuePair p1 = elem.getParameterByName("boundary");
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((Object)"whatever", (Object)p1.getValue());
        NameValuePair p2 = elem.getParameterByName("charset");
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)"UTF-8", (Object)p2.getValue());
    }

    @Test
    public void testImplictContractorParams() throws Exception {
        HttpEntity entity = MultipartEntityBuilder.create().build();
        Assert.assertNull((Object)entity.getContentEncoding());
        String contentType = entity.getContentType();
        HeaderElement elem = BasicHeaderValueParser.INSTANCE.parseHeaderElement((CharSequence)contentType, new ParserCursor(0, contentType.length()));
        Assert.assertEquals((Object)"multipart/mixed", (Object)elem.getName());
        NameValuePair p1 = elem.getParameterByName("boundary");
        Assert.assertNotNull((Object)p1);
        String boundary = p1.getValue();
        Assert.assertNotNull((Object)boundary);
        Assert.assertTrue((boundary.length() >= 30 ? 1 : 0) != 0);
        Assert.assertTrue((boundary.length() <= 40 ? 1 : 0) != 0);
        NameValuePair p2 = elem.getParameterByName("charset");
        Assert.assertNull((Object)p2);
    }

    @Test
    public void testRepeatable() throws Exception {
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("p1", "blah blah", ContentType.DEFAULT_TEXT).addTextBody("p2", "yada yada", ContentType.DEFAULT_TEXT).build();
        Assert.assertTrue((boolean)entity.isRepeatable());
        Assert.assertFalse((boolean)entity.isChunked());
        Assert.assertFalse((boolean)entity.isStreaming());
        long len = entity.getContentLength();
        Assert.assertTrue((len == entity.getContentLength() ? 1 : 0) != 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        byte[] bytes = out.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertTrue(((long)bytes.length == len ? 1 : 0) != 0);
        Assert.assertTrue((len == entity.getContentLength() ? 1 : 0) != 0);
        out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        bytes = out.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertTrue(((long)bytes.length == len ? 1 : 0) != 0);
    }

    @Test
    public void testNonRepeatable() throws Exception {
        HttpEntity entity = MultipartEntityBuilder.create().addPart("p1", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream("blah blah".getBytes()), ContentType.DEFAULT_BINARY)).addPart("p2", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream("yada yada".getBytes()), ContentType.DEFAULT_BINARY)).build();
        Assert.assertFalse((boolean)entity.isRepeatable());
        Assert.assertTrue((boolean)entity.isChunked());
        Assert.assertTrue((boolean)entity.isStreaming());
        Assert.assertTrue((entity.getContentLength() == -1L ? 1 : 0) != 0);
    }
}

